/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.common.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.Mailer;
import ch.elexis.ungrad.Resolver;
import ch.elexis.ungrad.common.ui.MailDialog;
import ch.rgw.tools.ExHandler;
import org.eclipse.swt.widgets.Shell;

public class MailUI {
    Shell shell;

    public MailUI(Shell shell) {
        this.shell = shell;
    }

    public void sendMail(String subject, String body, String recipient, String pdfFilePath) {
        String user = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpUser", "");
        String sender = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpSender", user);
        String smtpserver = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpHost", "localhost");
        String smtppwd = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpPwd", "doesntMatter");
        String smtpport = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpPort", "53");
        String[] attachments = new String[]{pdfFilePath};
        Resolver resolver = new Resolver();
        Mailer mailer = new Mailer(sender, smtpserver, smtppwd, smtpport, true);
        MailDialog mailDialog = new MailDialog(this.shell);
        mailDialog.sender = sender;
        mailDialog.mailTo = recipient;
        try {
            mailDialog.body = resolver.resolve(body);
            mailDialog.subject = resolver.resolve(subject);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            mailDialog.body = body;
            mailDialog.subject = subject;
        }
        mailDialog.attachments = attachments;
        if (mailDialog.open() == 0) {
            sender = mailDialog.sender;
            subject = mailDialog.subject;
            body = mailDialog.body;
            recipient = mailDialog.mailTo;
            attachments = mailDialog.attachments;
            try {
                String sec = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpSec", "plain");
                if (sec.equals("plain")) {
                    mailer.simpleMail(recipient, subject, body, attachments);
                } else if (sec.equals("tls")) {
                    mailer.tlsMail(user, recipient, subject, body, attachments);
                } else if (sec.equals("ssl")) {
                    mailer.sslMail(user, recipient, subject, body, attachments);
                }
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
                SWTHelper.showError((String)"Fehler beim Senden der Mail", (String)e.getMessage());
            }
        }
    }
}

