/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.common.ui;

import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MailDialog
extends TitleAreaDialog {
    Text tTo;
    Text tSubject;
    Text tBody;
    List lAttachments;
    public String mailTo = "";
    public String sender = "";
    public String subject = "";
    public String body = "";
    public String[] attachments = new String[0];

    public MailDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(4, 4, true, true));
        ret.setLayout((Layout)new GridLayout(2, false));
        Label lbTo = new Label(ret, 0);
        lbTo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        lbTo.setText("An");
        Composite cTo = new Composite(ret, 0);
        cTo.setLayout((Layout)new GridLayout(2, false));
        cTo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tTo = new Text(cTo, 2048);
        this.tTo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tTo.setText(this.mailTo);
        Button bSelect = new Button(cTo, 8);
        bSelect.setText("Suche...");
        this.tTo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MailDialog.this.mailTo = MailDialog.this.tTo.getText();
                if (StringTool.isMailAddress((String)MailDialog.this.mailTo)) {
                    MailDialog.this.setErrorMessage(null);
                    MailDialog.this.setMessage("Mail von " + MailDialog.this.sender);
                } else {
                    MailDialog.this.setErrorMessage("Es ist kein g\u00fcltiger Addressat gesetzt");
                }
                super.focusLost(e);
            }
        });
        bSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(MailDialog.this.getParentShell(), Kontakt.class, "Addressat", "Bitte w\u00e4hlen Sie", Kontakt.DEFAULT_SORT);
                if (ksl.open() == 0) {
                    Kontakt sel = (Kontakt)ksl.getSelection();
                    MailDialog.this.tTo.setText(sel.getMailAddress());
                    MailDialog.this.tTo.setFocus();
                }
            }
        });
        Label lbSubject = new Label(ret, 0);
        lbSubject.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        lbSubject.setText("Betreff");
        this.tSubject = new Text(ret, 2048);
        this.tSubject.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tSubject.setText(this.subject);
        this.tBody = new Text(ret, 2114);
        GridData gd = new GridData(-1, 100);
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.tBody.setLayoutData((Object)gd);
        String esc = this.body.replace("<br />", "\n");
        this.tBody.setText(esc);
        Label lbAttachments = new Label(ret, 0);
        lbAttachments.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        lbAttachments.setText("Anh\u00e4nge");
        Button bAdd = new Button(ret, 8);
        bAdd.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        bAdd.setText("Hinzu...");
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fld = new FileDialog(MailDialog.this.getShell());
                if (MailDialog.this.attachments.length > 0) {
                    fld.setFilterPath(FileTool.getFilepath((String)MailDialog.this.attachments[0]));
                }
                fld.setFilterExtensions(new String[]{"*.pdf;*.doc;*.odt;*.jpg;*.png;*.txt", "*.*"});
                String result = fld.open();
                if (result != null) {
                    MailDialog.this.lAttachments.add(result);
                    ret.layout();
                }
            }
        });
        GridData lgd = new GridData(-1, 100);
        lgd.horizontalSpan = 1;
        lgd.horizontalAlignment = 4;
        this.lAttachments = new List(ret, 2816);
        this.lAttachments.setLayoutData((Object)lgd);
        this.lAttachments.setItems(this.attachments);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle("Dokument als Mailanhang versenden");
        if (StringTool.isNothing((Object)this.mailTo)) {
            this.setErrorMessage("Es ist kein g\u00fcltiger Addressat gesetzt");
        } else {
            this.setMessage("Mail von: " + this.sender);
        }
    }

    protected void okPressed() {
        this.mailTo = this.tTo.getText();
        this.subject = this.tSubject.getText();
        this.body = this.tBody.getText().replace("\n", "<br />");
        this.attachments = this.lAttachments.getItems();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

