/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.types.Gender;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    static Logger log = LoggerFactory.getLogger((String)"elexis ungrad Util");
    static final String msg = "Requirement failed: ";

    public static void require(boolean it, String desc) {
        if (!it) {
            log.error(msg + desc);
            throw new Error(msg + desc);
        }
    }

    public static final boolean isFemale(IPerson p) {
        return !p.getGender().equals((Object)Gender.MALE);
    }

    public static final String reduceCharset(String in) {
        String out = in.replace("\u00fc", "ue").replace("\u00e4", "ae").replace("\u00f6", "oe").replaceAll("[\u00e9\u00e8]", "e").replace("\u00e0", "a");
        return out;
    }

    public static final String getSSN(IPatient pat) {
        String ahv = "";
        try {
            ahv = pat.getXid("www.ahv.ch/xid").getDomainId();
        }
        catch (Exception exception) {}
        if (StringTool.isNothing((Object)ahv)) {
            List coverages = pat.getCoverages();
            for (ICoverage fall : coverages) {
                String nr = fall.getInsuranceNumber();
                if (StringTool.isNothing((Object)nr) || !nr.matches("\\b756\\.?[0-9]{4}\\.?[0-9]{4}\\.?[0-9]{2}\\b")) continue;
                ahv = fall.getInsuranceNumber();
                break;
            }
        }
        return PersistentObject.checkNull((Object)ahv);
    }
}

