/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.data.Person;
import ch.rgw.tools.TimeTool;
import java.io.File;

public class StorageController {
    IContextService contextService = ContextServiceHolder.get();

    public File createFileFor(String id, String title, String extension, boolean bOverwrite) throws Exception {
        String name;
        File dir = this.getOutputDirFor(id, true);
        File ret = new File(dir, (name = this.createOutputFilename(title)) + extension);
        if (ret.exists() && !bOverwrite) {
            String suffix = new TimeTool().toString(8);
            ret = this.createFileFor(id, title + "_" + suffix, extension, false);
        }
        return ret;
    }

    public File getOutputDirFor(String id, boolean bCreateIfNotExists) throws Exception {
        if (id == null) {
            IPatient pat = (IPatient)this.contextService.getActivePatient().get();
            if (pat == null) {
                return null;
            }
            id = pat.getId();
        }
        Person p = Person.load((String)id);
        String name = p.getName();
        String fname = p.getVorname();
        String birthdate = p.getGeburtsdatum();
        File superdir = new File(CoreHub.localCfg.get("ch.elexis.ungrad.common/documentBase", ""), name.substring(0, 1).toLowerCase());
        File dir = new File(superdir, name + "_" + fname + "_" + birthdate);
        if (!dir.exists() && bCreateIfNotExists && !dir.mkdirs()) {
            throw new Exception("Can't create output dir");
        }
        return dir;
    }

    public String createOutputFilename(String basename) {
        StringBuilder ret = new StringBuilder();
        ret.append("A_").append(new TimeTool().toString(6)).append("_").append(basename);
        return ret.toString();
    }
}

