/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.ungrad.Util;
import ch.rgw.tools.StringTool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleObject {
    protected Map<String, String> props = new HashMap<String, String>();
    protected Logger log = LoggerFactory.getLogger((String)this.getClass().getName());

    public abstract String[] getFields();

    protected void load(ResultSet res) {
        Util.require(res != null, "ResultSet must not be null");
        String[] stringArray = this.getFields();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            try {
                this.props.put(field.toLowerCase(), res.getString(field));
            }
            catch (SQLException sQLException) {
                this.log.error("Illegal field name " + field);
            }
            ++n2;
        }
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.getFields();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sb.append(field).append(":").append(this.get(field)).append(",");
            ++n2;
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String get(String field) {
        Util.require(field != null, "field name must not be null");
        String[] stringArray = this.getFields();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (f.equalsIgnoreCase(field)) {
                String res = this.props.get(field.toLowerCase());
                return res == null ? "" : res;
            }
            ++n2;
        }
        throw new Error("Internal error: Bad field requested " + field);
    }

    public void set(String field, String value) {
        Util.require(field != null, "field name must not be null");
        Util.require(value != null, "value must not be null");
        this.props.put(field.toLowerCase(), value);
    }

    protected int compare(SimpleObject other, String field) {
        if (this.get(field) == null) {
            if (other.get(field) == null) {
                return 0;
            }
            return 2;
        }
        if (other.get(field) == null) {
            return -1;
        }
        String cnt = this.get(field);
        String o = other.get(field);
        if (cnt.matches("[\\d\\., ]+")) {
            Float f1 = Float.valueOf(SimpleObject.makeFloat(cnt));
            Float f2 = Float.valueOf(SimpleObject.makeFloat(o));
            return f1.compareTo(f2);
        }
        return cnt.compareTo(o);
    }

    public static float makeFloat(String raw) {
        Util.require(raw != null, "Raw must not be null");
        String s = raw.replaceAll("[\\s]", "");
        if (s.startsWith("<")) {
            return SimpleObject.makeFloatInternal(s.substring(1));
        }
        if (s.startsWith(">")) {
            return SimpleObject.makeFloatInternal(s.substring(1));
        }
        return SimpleObject.makeFloatInternal(s);
    }

    private static float makeFloatInternal(String s) {
        if (s == null || s.length() == 0) {
            return 0.0f;
        }
        String[] splitted = s.split("[\\.,]");
        if (splitted.length < 1) {
            System.out.println("Bad value: " + s);
            return -1.0f;
        }
        if (splitted[0].matches("\\s*[0-9]+\\s*")) {
            String einer = splitted[0].trim();
            String frac = "0";
            if (splitted.length > 2) {
                return -1.0f;
            }
            if (splitted.length == 2) {
                if (splitted[1].matches("\\s*[0-9]+\\s*")) {
                    frac = splitted[1].trim();
                } else {
                    return -1.0f;
                }
            }
            frac = StringTool.pad((int)2, (char)'0', (String)frac, (int)3);
            float fr = (float)Integer.parseInt(frac) / 1000.0f;
            float ret = (float)Integer.parseInt(einer) + fr;
            return ret;
        }
        return -1.0f;
    }
}

