/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.text.Messages;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resolver {
    private static Logger log = LoggerFactory.getLogger(Resolver.class);
    @Reference
    private IContextService contextService = ContextServiceHolder.get();
    Map<String, PersistentObject> replmap;
    boolean bAsHtml = false;

    public Resolver(Map<String, PersistentObject> fld, boolean asHTML) {
        this.replmap = fld;
        this.bAsHtml = asHTML;
    }

    public Resolver() {
        this(new HashMap<String, PersistentObject>(), false);
    }

    public void asHTML(boolean html) {
        this.bAsHtml = html;
    }

    public String resolve(String raw) throws Exception {
        String level1 = this.resolveSimple(raw);
        String level2 = this.resolveGenderized(level1);
        return level2;
    }

    public String resolveSimple(String raw) throws Exception {
        Pattern pat = Pattern.compile("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]");
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pat.matcher(raw);
        while (matcher.find()) {
            String found = matcher.group();
            String replacement = this.replaceTemplate(found);
            if (!replacement.startsWith("**ERROR")) {
                matcher.appendReplacement(sb, replacement);
                continue;
            }
            matcher.appendReplacement(sb, " ");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String resolveGenderized(String raw) throws Exception {
        Pattern pat = Pattern.compile("\\[[*]?[a-zA-Z]+:mwn?:[^\\[]+\\]");
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pat.matcher(raw);
        while (matcher.find()) {
            String found = matcher.group();
            String replacement = this.genderize(found);
            if (!replacement.startsWith("**ERROR")) {
                matcher.appendReplacement(sb, replacement);
                continue;
            }
            matcher.appendReplacement(sb, " ");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceTemplate(String tmpl) throws ClassNotFoundException {
        String[] rooted = tmpl.substring(1, tmpl.length() - 1).split("\\.");
        if (rooted.length == 2) {
            PersistentObject po;
            if (rooted[0].equals("Datum")) {
                return new TimeTool().toString(4);
            }
            if (rooted[1].equals("EAN") || rooted[1].equals("ZSR") || rooted[1].equals("GLN")) {
                System.out.println(rooted[0]);
            }
            if ((po = this.resolveObject(rooted[0])) == null) {
                return "";
            }
            String r = po.get(rooted[1]);
            if (r.startsWith("**ERROR")) {
                System.out.print(po.get("Bezeichnung1") + " " + po.get("Bezeichnung2") + " " + po.get("Bezeichnung3"));
                r = (String)po.getExtInfoStoredObjectByKey((Object)rooted[1]);
            }
            String replacement = StringTool.unNull((String)r);
            if (this.bAsHtml) {
                replacement = replacement.replaceAll("\\R", "<br />");
            }
            return replacement;
        }
        return tmpl;
    }

    private PersistentObject resolveObject(String name) {
        PersistentObject po = this.replmap.get(name);
        if (po == null) {
            String fqname = "ch.elexis.data." + name;
            try {
                Class.forName(fqname);
                po = (PersistentObject)ElexisEventDispatcher.getSelected(Class.forName(fqname));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return po;
    }

    private String genderize(String in) {
        String[] q;
        PersistentObject po;
        String inl = in.substring(1, in.length() - 1);
        boolean showErrors = true;
        if (inl.substring(0, 1).equalsIgnoreCase("*")) {
            inl = inl.substring(1);
            showErrors = false;
        }
        if ((po = this.resolveObject((q = inl.split(":"))[0])) == null) {
            if (showErrors) {
                return "???";
            }
            return "";
        }
        if (q.length != 3) {
            log.error("falsches genderize Format " + inl);
            return null;
        }
        if (!(po instanceof Kontakt)) {
            if (showErrors) {
                return Messages.TextContainer_FieldTypeForContactsOnly;
            }
            return "";
        }
        Kontakt k = (Kontakt)po;
        String[] g = q[2].split("/");
        if (g.length < 2) {
            if (showErrors) {
                return Messages.TextContainer_BadFieldDefinition;
            }
            return "";
        }
        if (k.istPerson()) {
            Person p = Person.load((String)k.getId());
            if (p.get("Geschlecht").equals("m")) {
                if (q[1].startsWith("m")) {
                    return g[0];
                }
                return g[1];
            }
            if (q[1].startsWith("w")) {
                return g[0];
            }
            return g[1];
        }
        if (g.length < 3) {
            if (showErrors) {
                return Messages.TextContainer_FieldTypeForPersonsOnly;
            }
            return "";
        }
        return g[2];
    }
}

