/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.ungrad.IObserver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.eclipse.swt.widgets.Display;

public class ObservableFile {
    private boolean cancelled = false;
    private WatchService watcher = FileSystems.getDefault().newWatchService();
    private File tempFile;

    public ObservableFile(File dir, IObserver observer) throws IOException {
        this.tempFile = File.createTempFile("ungr", "tmp", dir);
        this.tempFile.deleteOnExit();
        Path watchdir = dir.toPath();
        watchdir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        this.asyncWatchDir(observer);
    }

    public void cancel() {
        this.cancelled = true;
    }

    void asyncWatchDir(final IObserver observer) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                WatchKey watchKey = null;
                try {
                    while ((watchKey = ObservableFile.this.watcher.take()) != null) {
                        watchKey.pollEvents().stream().forEach(event -> observer.signal(event.context()));
                        watchKey.reset();
                        if (!ObservableFile.this.cancelled) continue;
                        watchKey.cancel();
                        ObservableFile.this.tempFile.delete();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

