/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.Util;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class MailQueue {
    private ArrayList<Mail> mails = new ArrayList();

    public void addMail(String subject, String body, String recipient, String[] attachments) {
        this.mails.add(new Mail(subject, body, recipient, attachments));
    }

    public void sendMails() {
        if (this.mails.size() > 0) {
            new SendJob().schedule();
        }
    }

    private static class Mail {
        String subject;
        String body;
        String recipient;
        String[] attachments;

        Mail(String s, String b, String r, String[] a) {
            this.subject = s;
            this.body = b;
            this.recipient = r;
            this.attachments = a;
        }
    }

    class SendJob
    extends Job {
        Result<String> ret;
        String user;
        String sender;
        String smtpHost;
        String smtpPassword;
        String smtpPort;

        SendJob() {
            super("send invoices");
            this.ret = new Result();
            this.user = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpUser", "");
            this.sender = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpSender", this.user);
            this.smtpHost = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpHost", "localhost");
            this.smtpPassword = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpPwd", "doesntMatter");
            this.smtpPort = CoreHub.localCfg.get("ch.elexis.ungrad.common/smtpPort", "53");
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Sending mails", MailQueue.this.mails.size());
            for (Mail mail : MailQueue.this.mails) {
                try {
                    this.sendMail(mail);
                    monitor.worked(1);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.showError((String)"SMTP Mailer", (String)ex.getMessage());
                    return new Status(4, "Mailer", ex.getMessage());
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private void sendMail(Mail mail) throws MessagingException {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.smtpHost);
            props.put("mail.smtp.port", this.smtpPort);
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.ssl.protocols", "TLSv1.2");
            props.put("mail.smtp.ssl.trust", this.smtpHost);
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SendJob.this.user, SendJob.this.smtpPassword);
                }
            };
            Session session = Session.getInstance((Properties)props, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.addHeader("Content-type", "text/html; charset=UTF-8");
            msg.addHeader("format", "flowed");
            msg.addHeader("Content-Transfer-Encoding", "8bit");
            msg.setFrom((Address)new InternetAddress(this.sender));
            msg.addRecipient(MimeMessage.RecipientType.BCC, msg.getFrom()[0]);
            msg.setReplyTo(msg.getFrom());
            msg.setSubject(mail.subject, "UTF-8");
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (mail.body.contains("<")) {
                messageBodyPart.setContent((Object)mail.body, "text/html; charset=UTF-8");
            } else {
                messageBodyPart.setText(mail.body);
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            String[] stringArray = mail.attachments;
            int n = mail.attachments.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(filename);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(Util.reduceCharset(FileTool.getFilename((String)filename)));
                multipart.addBodyPart((BodyPart)messageBodyPart);
                ++n2;
            }
            msg.setContent((Multipart)multipart);
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.recipient, (boolean)false));
            Transport.send((Message)msg);
        }
    }
}

