/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http {
    private Logger log = LoggerFactory.getLogger((String)"Lucinda v3 client");

    public URL makeURL(String server, int port, String call) throws MalformedURLException {
        return new URL("http://" + server + ":" + port + call);
    }

    public byte[] doGet(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("method", "get");
        conn.setConnectTimeout(5000);
        int response = conn.getResponseCode();
        if (response == 200) {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bin = new BufferedInputStream(conn.getInputStream());
            while ((c = bin.read()) != -1) {
                baos.write(c);
            }
            return baos.toByteArray();
        }
        throw new IOException("could not read " + url.toString() + ": Status was " + response);
    }

    public String doPost(URL url, String body, int expectedStatus) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Content-Length", String.valueOf(body.length()));
        conn.setDoOutput(true);
        OutputStreamWriter os = new OutputStreamWriter(conn.getOutputStream());
        os.write(body);
        os.flush();
        int response = conn.getResponseCode();
        if (response == expectedStatus) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            in.close();
            conn.disconnect();
            return buffer.toString();
        }
        this.log.error("Bad answer for " + url.toString() + ": " + response);
        return null;
    }
}

