/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.UnsupportedEncodingException;

public class JdbcLinkUtil {
    public static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    public static final String POSTGRESQL_DRIVER_CLASS_NAME = "org.postgresql.Driver";
    public static final String H2_DRIVER_CLASS_NAME = "org.h2.Driver";
    public static final String DBFLAVOR_MYSQL = "mysql";
    public static final String DBFLAVOR_POSTGRESQL = "postgresql";
    public static final String DBFLAVOR_H2 = "h2";

    public static String wrap(String s) {
        if (StringTool.isNothing(s)) {
            return "''";
        }
        try {
            return JdbcLinkUtil.wrap(s.getBytes("UTF-8"), DBFLAVOR_MYSQL);
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle(e);
            return JdbcLinkUtil.wrap(s.getBytes(), DBFLAVOR_MYSQL);
        }
    }

    public static String wrap(byte[] in, String flavor) {
        byte[] out = new byte[2 * in.length + 2];
        int j = 0;
        out[j++] = 39;
        int i = 0;
        while (i < in.length) {
            switch (in[i]) {
                case 0: 
                case 34: 
                case 39: {
                    if (flavor.startsWith(DBFLAVOR_POSTGRESQL) || flavor.startsWith("hsql")) {
                        out[j++] = 39;
                        break;
                    }
                    if (flavor.startsWith(DBFLAVOR_H2)) {
                        out[j++] = 39;
                        break;
                    }
                }
                case 92: {
                    boolean after;
                    boolean before = i > 1 && in[i - 1] == 92;
                    boolean bl = after = i < in.length - 1 && in[i + 1] == 92;
                    if (before || after) break;
                    out[j++] = 92;
                }
            }
            out[j++] = in[i];
            ++i;
        }
        out[j++] = 39;
        try {
            return new String(out, 0, j, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle(e);
            return null;
        }
    }
}

