/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    private int buffer;
    private int pos;
    private OutputStream stream;

    public static final String Version() {
        return "0.6.5";
    }

    public BitOutputStream(OutputStream out) {
        this.stream = out;
        this.pos = 128;
    }

    @Override
    public void write(int c) throws IOException {
        this.pushbits(c, 8);
    }

    public void pushbits(int c, int bitnum) throws IOException {
        int mask = 1 << bitnum - 1;
        while (mask > 0) {
            if ((c & mask) == 0) {
                this.write(false);
            } else {
                this.write(true);
            }
            mask >>= 1;
        }
    }

    public void write(boolean bit) throws IOException {
        if (bit) {
            this.buffer |= this.pos;
        }
        this.pos >>= 1;
        if (this.pos == 0) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.stream.write(this.buffer);
        this.buffer = 0;
        this.pos = 128;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.stream.write(0);
        this.stream.close();
    }
}

