/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.Huff;
import ch.rgw.compress.RLL;
import ch.rgw.tools.BinConverter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IntTool;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.prefs.Preferences;

public class HuffmanTree {
    static final int TABLESIZE = 256;
    public int[] freq;
    Node root;
    public static byte[] TextDeutsch;

    static {
        byte[] byArray = new byte[413];
        byArray[0] = 7;
        byArray[1] = 7;
        byArray[2] = 36;
        byArray[4] = 61;
        byArray[5] = 7;
        byArray[6] = 3;
        byArray[8] = 9;
        byArray[9] = 3;
        byArray[10] = 7;
        byArray[11] = 10;
        byArray[13] = -12;
        byArray[14] = 2;
        byArray[15] = 7;
        byArray[16] = 50;
        byArray[18] = 1;
        byArray[19] = 7;
        byArray[20] = 23;
        byArray[22] = -23;
        byArray[23] = 36;
        byArray[26] = 5;
        byArray[27] = 7;
        byArray[28] = 3;
        byArray[30] = -18;
        byArray[31] = 7;
        byArray[32] = 3;
        byArray[34] = 1;
        byArray[35] = 7;
        byArray[36] = 7;
        byArray[38] = 35;
        byArray[39] = 7;
        byArray[40] = 3;
        byArray[42] = 43;
        byArray[43] = 7;
        byArray[44] = 3;
        byArray[46] = 12;
        byArray[47] = 7;
        byArray[48] = 3;
        byArray[50] = -123;
        byArray[51] = 7;
        byArray[52] = 3;
        byArray[54] = -119;
        byArray[55] = 7;
        byArray[56] = 11;
        byArray[58] = 51;
        byArray[59] = 2;
        byArray[62] = -2;
        byArray[63] = 7;
        byArray[64] = 3;
        byArray[66] = 71;
        byArray[67] = 3;
        byArray[70] = -8;
        byArray[71] = 7;
        byArray[72] = 3;
        byArray[74] = 48;
        byArray[75] = 1;
        byArray[78] = -82;
        byArray[79] = 7;
        byArray[80] = 3;
        byArray[82] = -87;
        byArray[83] = 7;
        byArray[84] = 3;
        byArray[86] = 79;
        byArray[87] = 7;
        byArray[88] = 3;
        byArray[90] = 58;
        byArray[91] = 7;
        byArray[92] = 3;
        byArray[94] = 73;
        byArray[95] = 7;
        byArray[96] = 3;
        byArray[98] = 59;
        byArray[99] = 7;
        byArray[100] = 3;
        byArray[102] = 56;
        byArray[103] = 7;
        byArray[104] = 3;
        byArray[106] = 45;
        byArray[107] = 7;
        byArray[108] = 3;
        byArray[110] = 36;
        byArray[111] = 7;
        byArray[112] = 3;
        byArray[114] = -5;
        byArray[115] = 1;
        byArray[118] = 35;
        byArray[119] = 7;
        byArray[120] = 3;
        byArray[122] = 38;
        byArray[123] = 2;
        byArray[126] = 117;
        byArray[127] = 7;
        byArray[128] = 3;
        byArray[130] = 38;
        byArray[131] = 2;
        byArray[134] = 13;
        byArray[135] = 7;
        byArray[136] = 3;
        byArray[138] = 25;
        byArray[139] = 7;
        byArray[140] = 3;
        byArray[142] = -64;
        byArray[143] = 1;
        byArray[146] = -42;
        byArray[147] = 7;
        byArray[148] = 3;
        byArray[150] = -66;
        byArray[151] = 7;
        byArray[152] = 3;
        byArray[154] = 9;
        byArray[155] = 1;
        byArray[158] = 62;
        byArray[159] = 1;
        byArray[162] = -36;
        byArray[163] = 7;
        byArray[164] = 3;
        byArray[166] = -24;
        byArray[167] = 7;
        byArray[168] = 3;
        byArray[170] = -61;
        byArray[171] = 7;
        byArray[172] = 3;
        byArray[174] = 41;
        byArray[175] = 1;
        byArray[178] = 36;
        byArray[179] = 7;
        byArray[180] = 3;
        byArray[182] = -57;
        byArray[183] = 7;
        byArray[184] = 3;
        byArray[186] = -109;
        byArray[187] = 7;
        byArray[188] = 3;
        byArray[190] = 126;
        byArray[191] = 1;
        byArray[194] = -110;
        byArray[195] = 7;
        byArray[196] = 3;
        byArray[198] = 59;
        byArray[199] = 7;
        byArray[200] = 3;
        byArray[202] = 65;
        byArray[203] = 1;
        byArray[206] = 25;
        byArray[207] = 7;
        byArray[208] = 3;
        byArray[210] = -77;
        byArray[211] = 7;
        byArray[212] = 3;
        byArray[214] = 85;
        byArray[215] = 2;
        byArray[218] = -61;
        byArray[219] = 7;
        byArray[220] = 3;
        byArray[222] = 84;
        byArray[223] = 7;
        byArray[224] = 3;
        byArray[226] = -112;
        byArray[227] = 7;
        byArray[228] = 3;
        byArray[230] = -84;
        byArray[231] = 7;
        byArray[232] = 3;
        byArray[234] = 40;
        byArray[235] = 7;
        byArray[236] = 3;
        byArray[238] = 15;
        byArray[239] = 7;
        byArray[240] = 3;
        byArray[242] = 88;
        byArray[243] = 7;
        byArray[244] = 19;
        byArray[246] = 23;
        byArray[247] = 1;
        byArray[248] = 7;
        byArray[249] = 6;
        byArray[251] = -61;
        byArray[252] = 12;
        byArray[255] = 21;
        byArray[256] = 4;
        byArray[259] = 70;
        byArray[260] = 6;
        byArray[263] = 33;
        byArray[264] = 10;
        byArray[267] = -41;
        byArray[268] = 37;
        byArray[271] = -39;
        byArray[272] = 3;
        byArray[275] = -16;
        byArray[276] = 6;
        byArray[279] = -87;
        byArray[280] = 9;
        byArray[283] = 116;
        byArray[284] = 19;
        byArray[287] = 81;
        byArray[288] = 7;
        byArray[289] = 3;
        byArray[291] = 23;
        byArray[292] = 3;
        byArray[295] = 117;
        byArray[296] = 9;
        byArray[299] = -55;
        byArray[300] = 5;
        byArray[303] = 45;
        byArray[304] = 24;
        byArray[307] = -53;
        byArray[308] = 5;
        byArray[311] = 72;
        byArray[312] = 2;
        byArray[315] = 28;
        byArray[316] = 7;
        byArray[317] = 3;
        byArray[319] = 49;
        byArray[320] = 17;
        byArray[323] = 85;
        byArray[324] = 14;
        byArray[327] = 17;
        byArray[328] = 15;
        byArray[331] = 84;
        byArray[332] = 8;
        byArray[335] = -81;
        byArray[336] = 1;
        byArray[339] = 49;
        byArray[340] = 3;
        byArray[343] = -81;
        byArray[344] = 7;
        byArray[345] = 3;
        byArray[347] = 94;
        byArray[348] = 7;
        byArray[349] = 3;
        byArray[351] = -87;
        byArray[352] = 2;
        byArray[355] = 1;
        byArray[356] = 7;
        byArray[357] = 7;
        byArray[359] = 1;
        byArray[360] = 7;
        byArray[361] = 27;
        byArray[363] = 8;
        byArray[364] = 7;
        byArray[365] = 51;
        byArray[367] = 1;
        byArray[368] = 7;
        byArray[369] = 3;
        byArray[371] = 4;
        byArray[372] = 7;
        byArray[373] = 3;
        byArray[375] = 8;
        byArray[376] = 7;
        byArray[377] = 11;
        byArray[379] = 1;
        byArray[380] = 7;
        byArray[381] = 91;
        byArray[383] = 4;
        byArray[384] = 7;
        byArray[385] = 91;
        byArray[387] = 11;
        byArray[388] = 7;
        byArray[389] = 71;
        byArray[391] = 8;
        byArray[392] = 7;
        byArray[393] = 23;
        byArray[395] = 28;
        byArray[396] = 7;
        byArray[397] = 31;
        byArray[399] = 54;
        byArray[400] = 1;
        byArray[401] = 7;
        byArray[402] = 70;
        byArray[404] = -37;
        byArray[405] = 7;
        byArray[406] = 23;
        byArray[408] = 110;
        byArray[409] = 1;
        byArray[410] = 7;
        byArray[411] = 14;
        TextDeutsch = byArray;
    }

    public static String Version() {
        return "1.0.2";
    }

    public HuffmanTree() {
        this.root = null;
    }

    public HuffmanTree(byte[] source) {
        this.build(HuffmanTree.constructTable(source));
    }

    public HuffmanTree(int[] frequencyTable) {
        this.build(frequencyTable);
    }

    public Node build(int[] table) {
        this.root = null;
        if (table == null || table.length != 256) {
            return null;
        }
        this.freq = table;
        if (this.freq[7] == 0) {
            this.freq[7] = 1;
        }
        if (this.freq[255] == 0) {
            this.freq[255] = 1;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(this.freq.length);
        int i = 0;
        while (i < this.freq.length) {
            if (this.freq[i] != 0) {
                nodes.add(new Node((byte)i, this.freq[i]));
            }
            ++i;
        }
        Collections.sort(nodes);
        while (nodes.size() > 1) {
            Node a = (Node)nodes.remove(0);
            Node b = (Node)nodes.remove(0);
            int al = a.ch.length;
            byte[] bn = new byte[al + b.ch.length];
            int i2 = 0;
            while (i2 < al) {
                bn[i2] = a.ch[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < b.ch.length) {
                bn[i2 + al] = b.ch[i2];
                ++i2;
            }
            Arrays.sort(bn);
            Node n = new Node(bn, a.lfreq + b.lfreq);
            n.left = a;
            n.right = b;
            nodes.add(n);
            Collections.sort(nodes);
        }
        this.root = (Node)nodes.get(0);
        return this.root;
    }

    public static int[] constructTable(byte[] source) {
        int[] ret = new int[256];
        int i = 0;
        while (i < source.length) {
            int n = IntTool.ByteToInt(source[i]);
            ret[n] = ret[n] + 1;
            ++i;
        }
        return ret;
    }

    public static int[] constructTable(RandomAccessFile file) {
        int[] ret = new int[256];
        try {
            file.seek(0L);
            long l = file.length();
            long i = 0L;
            while (i < l) {
                int c;
                int n = c = file.read();
                ret[n] = ret[n] + 1;
                ++i;
            }
            return ret;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public InputStream constructTable(InputStream source, boolean copy) {
        this.freq = new int[256];
        try {
            if (!copy) ** GOTO lbl17
            file = File.createTempFile("huf", "tmp");
            file.deleteOnExit();
            fos = new FileOutputStream(file);
            while (source.available() != 0) {
                v0 = c = source.read();
                this.freq[v0] = this.freq[v0] + 1;
                fos.write(c);
            }
            source.close();
            fos.close();
            return new FileInputStream(file);
lbl-1000:
            // 1 sources

            {
                v1 = c = source.read();
                this.freq[v1] = this.freq[v1] + 1;
lbl17:
                // 2 sources

                ** while (source.available() != 0)
            }
lbl18:
            // 1 sources

            source.close();
            return null;
        }
        catch (IOException ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public boolean saveTable(OutputStream out) {
        byte[] tbl = HuffmanTree.compactTable(this.freq);
        try {
            short l = (short)tbl.length;
            out.write(l & 0xFF);
            out.write(l >> 8);
            int i = 0;
            while (i < tbl.length) {
                out.write(tbl[i]);
                ++i;
            }
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return false;
        }
    }

    public static int[] loadTable(InputStream in) {
        try {
            int l = in.read();
            byte[] tbl = new byte[l |= in.read() << 8];
            int i = 0;
            while (i < tbl.length) {
                tbl[i] = (byte)in.read();
                ++i;
            }
            return HuffmanTree.expandTable(tbl);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static int[] useTable(byte[] in) {
        return HuffmanTree.expandTable(in);
    }

    public static int[] useStandardTable(String name) {
        Preferences pr = Preferences.userNodeForPackage(Huff.class);
        Preferences node = pr.node("StandardTables");
        byte[] res = node.getByteArray(name, TextDeutsch);
        return HuffmanTree.expandTable(res);
    }

    public static boolean CreateStandardTableFromStream(String name, InputStream in) throws Exception {
        int[] tbl = new int[256];
        while (in.available() != 0) {
            int c;
            int n = c = in.read();
            tbl[n] = tbl[n] + 1;
        }
        byte[] dest = HuffmanTree.compactTable(tbl);
        Preferences pref = Preferences.userNodeForPackage(Huff.class);
        Preferences node = pref.node("StandardTables");
        node.putByteArray(name, dest);
        pref.flush();
        return true;
    }

    public Node getRootNode() {
        return this.root;
    }

    public int[] getTable() {
        return this.freq;
    }

    public static void dumpTable(int[] table) {
        int i = 0;
        while (i < table.length) {
            if (table[i] != 0) {
                System.out.println(i + " : " + table[i]);
            }
            ++i;
        }
    }

    public static boolean checkCompacter() {
        int[] nArray = new int[156];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 6;
        nArray[6] = 7;
        nArray[7] = 8;
        nArray[8] = 9;
        nArray[9] = 12345678;
        nArray[10] = 9876;
        nArray[134] = 1;
        nArray[135] = 1;
        nArray[136] = 1;
        nArray[137] = 1;
        nArray[138] = 1;
        nArray[139] = 1;
        nArray[140] = 1;
        nArray[141] = 1;
        nArray[142] = 1;
        nArray[143] = 1;
        nArray[144] = 1;
        nArray[145] = 1;
        nArray[146] = 1;
        nArray[147] = 2;
        nArray[148] = 2;
        nArray[149] = 2;
        nArray[150] = 2;
        nArray[151] = 2;
        nArray[152] = 2;
        nArray[153] = 2;
        nArray[154] = 2;
        nArray[155] = 267;
        int[] t1 = nArray;
        byte[] t2 = HuffmanTree.compactTable(t1);
        int[] t3 = HuffmanTree.expandTable(t2);
        if (t1.length != t3.length) {
            return false;
        }
        int i = 0;
        while (i < t1.length) {
            if (t1[i] != t3[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static byte[] compactTable(int[] table) {
        byte[] ret = new byte[4 * table.length];
        int i = 0;
        int off = 0;
        while (i < table.length) {
            BinConverter.intToByteArray(table[i], ret, off);
            ++i;
            off += 4;
        }
        return RLL.compress((byte)0, ret);
    }

    private static int[] expandTable(byte[] source) {
        byte[] t = RLL.expand(source);
        int[] ret = new int[t.length >> 2];
        int i = 0;
        int off = 0;
        while (i < ret.length) {
            ret[i] = BinConverter.byteArrayToInt(t, off);
            ++i;
            off += 4;
        }
        return ret;
    }

    class Node
    implements Comparable {
        Node left;
        Node right;
        byte[] ch;
        int lfreq;

        Node(byte x, int f) {
            this.ch = new byte[]{x};
            this.lfreq = f;
        }

        Node(byte[] x, int f) {
            this.ch = x;
            this.lfreq = f;
        }

        public int compareTo(Object arg0) {
            Node other = (Node)arg0;
            if (this.lfreq > other.lfreq) {
                return 1;
            }
            if (this.lfreq > other.lfreq) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node other = (Node)o;
                if (StringTool.compare(this.ch, other.ch) && this.lfreq == other.lfreq) {
                    return true;
                }
            }
            return false;
        }
    }
}

