/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.HuffmanTree;
import ch.rgw.io.BitInputStream;
import ch.rgw.io.BitOutputStream;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IntTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.prefs.Preferences;

public class Huff {
    public static final byte escape = 7;
    public static final int eof = 255;

    public static String Version() {
        return "0.6.4";
    }

    public static byte[] encode(HuffmanTree tree, byte[] source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BitOutputStream bos = new BitOutputStream(baos);
        baos.write(source.length & 0xFF);
        baos.write(source.length >> 8 & 0xFF);
        baos.write(source.length >> 16 & 0xFF);
        baos.write(source.length >> 24 & 0xFF);
        if (tree == null) {
            tree = new HuffmanTree();
            tree.build(HuffmanTree.constructTable(source));
            tree.saveTable(baos);
        }
        try {
            int i = 0;
            while (i < source.length) {
                Huff.writeByte(tree.getRootNode(), bos, source[i]);
                ++i;
            }
            bos.flush();
            bos.close();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
        return baos.toByteArray();
    }

    public static byte[] decode(HuffmanTree tree, byte[] source) {
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        int size = bais.read() | bais.read() << 8 | bais.read() << 16 | bais.read() << 24;
        BitInputStream bis = new BitInputStream(bais);
        byte[] out = new byte[size];
        try {
            HuffmanTree.Node root = tree == null ? new HuffmanTree().build(HuffmanTree.loadTable(bais)) : tree.getRootNode();
            int i = 0;
            while (i < out.length) {
                out[i] = (byte)Huff.readByte(root, bis);
                ++i;
            }
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
        return out;
    }

    public static byte[] encodeString(HuffmanTree tree, String i) {
        byte[] b = i.getBytes();
        return Huff.encode(tree, b);
    }

    public static String decodeString(HuffmanTree tree, byte[] in) {
        byte[] out = Huff.decode(tree, in);
        String res = new String(out);
        return res;
    }

    static boolean writeByte(HuffmanTree.Node act, BitOutputStream out, int c) throws IOException {
        if (Arrays.binarySearch(act.ch, (byte)c) < 0) {
            Huff.writeBits(act, out, 7);
            out.write(c);
            return false;
        }
        if (c == 7) {
            Huff.writeBits(act, out, c);
            out.write(c);
            return true;
        }
        return Huff.writeBits(act, out, c);
    }

    public static void writeEOF(HuffmanTree.Node act, BitOutputStream out) throws IOException {
        Huff.writeBits(act, out, 7);
        out.write(255);
    }

    private static boolean writeBits(HuffmanTree.Node act, BitOutputStream out, int c) throws IOException {
        while (true) {
            if (act.ch.length == 1) {
                return true;
            }
            if (act.left != null && Arrays.binarySearch(act.left.ch, (byte)c) >= 0) {
                out.write(false);
                act = act.left;
                continue;
            }
            if (act.right == null || Arrays.binarySearch(act.right.ch, (byte)c) < 0) break;
            out.write(true);
            act = act.right;
        }
        throw new IOException("Bad Huffman code");
    }

    static int readByte(HuffmanTree.Node act, BitInputStream in) throws IOException {
        while (true) {
            if (act == null) {
                throw new IOException("Bad Huffman code");
            }
            if (act.ch.length == 1) {
                int c = IntTool.ByteToInt(act.ch[0]);
                if (c == 7) {
                    int f = in.read();
                    if (f == 255) {
                        return -1;
                    }
                    return f;
                }
                return c;
            }
            if (in.readBit()) {
                act = act.right;
                continue;
            }
            act = act.left;
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv[0].equals("create")) {
                FileInputStream in = new FileInputStream(argv[2]);
                HuffmanTree.CreateStandardTableFromStream(argv[1], in);
            } else if (argv[0].equals("list")) {
                Preferences pr = Preferences.userNodeForPackage(Huff.class);
                Preferences node = pr.node("StandardTables");
                String[] tables = node.keys();
                int i = 0;
                while (i < tables.length) {
                    System.out.println(tables[i]);
                    ++i;
                }
            } else if (argv[0].equals("export")) {
                Preferences pr = Preferences.userNodeForPackage(Huff.class);
                Preferences node = pr.node("StandardTables");
                FileOutputStream exbin = new FileOutputStream(argv[2] + ".bin");
                FileOutputStream exasc = new FileOutputStream(argv[2] + ".asc");
                byte[] cmpt = node.getByteArray(argv[1], null);
                if (cmpt == null) {
                    System.out.println("Table " + argv[1] + " not found");
                } else {
                    int k = 0;
                    int i = 0;
                    while (i < cmpt.length) {
                        exbin.write(cmpt[i]);
                        if (k++ == 20) {
                            exasc.write(10);
                            k = 0;
                        }
                        exasc.write((Byte.toString(cmpt[i]) + ",").getBytes());
                        ++i;
                    }
                }
            } else {
                System.out.println("Usage: Huff create <name> <file>\nor Huff export <name> <file>nor Huff list");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

