/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.text;

import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.List;
import java.util.Optional;

public interface ITextPlaceholderResolver {
    public String getSupportedType();

    default public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        return Optional.empty();
    }

    public List<PlaceholderAttribute> getSupportedAttributes();

    public Optional<String> replaceByTypeAndAttribute(IContext var1, String var2);

    default public <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        String searchEnumName = search.replace('-', '_');
        Enum[] enumArray = (Enum[])enumeration.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Optional<String> found;
            Enum each = enumArray[n2];
            if (each.name().compareToIgnoreCase(searchEnumName) == 0) {
                return (T)each;
            }
            if (each instanceof IPlaceholderAttributeEnum && (found = ((IPlaceholderAttributeEnum)((Object)each)).getAlternativeNames().stream().filter(an -> an.compareToIgnoreCase(searchEnumName) == 0).findFirst()).isPresent()) {
                return (T)each;
            }
            ++n2;
        }
        return null;
    }

    public static interface IPlaceholderAttributeEnum {
        public List<String> getAlternativeNames();
    }
}

