/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.issue;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import ch.elexis.core.model.issue.ProcessStatus;
import java.util.ResourceBundle;
import org.slf4j.LoggerFactory;

public enum Visibility implements INumericEnum,
ILocalizedEnum
{
    ON_PATIENT_SELECTION(0),
    ALWAYS(1),
    POPUP_ON_PATIENT_SELECTION(2),
    POPUP_ON_LOGIN(3);

    private final int numeric;

    private Visibility(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(Visibility.class.getSimpleName() + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static Visibility byNumericSafe(String visibilityIn) {
        try {
            int numeric = Integer.parseInt(visibilityIn);
            Visibility[] visibilityArray = Visibility.values();
            int n = visibilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Visibility visibility = visibilityArray[n2];
                if (visibility.numericValue() == numeric) {
                    return visibility;
                }
                ++n2;
            }
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(ProcessStatus.class).warn("Visibility [" + visibilityIn + "] is not a number", (Throwable)e);
        }
        return ALWAYS;
    }
}

