/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.format;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.prescription.EntryType;
import java.util.Collections;
import java.util.List;

public class PatientFormatUtil {
    public static String getNarrativeText(IPatient patient) {
        return (String)(patient.getTitel() != null ? patient.getTitel() + " " : "") + patient.getFirstName() + " " + patient.getLastName() + " (" + PersonFormatUtil.getGenderCharLocalized(patient) + "), " + PersonFormatUtil.getDateOfBirth(patient) + " (" + patient.getAgeInYears() + ") - [" + patient.getPatientNr() + "]";
    }

    public static String getMedicationText(IPatient patient, @Nullable EntryType filterType) {
        List<IPrescription> prescriptions = patient.getMedication(Collections.singletonList(filterType));
        StringBuilder sb = new StringBuilder();
        prescriptions.stream().forEach(p -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(p.getLabel());
        });
        return sb.toString();
    }
}

