/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IVaccination;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;

public class IVaccinationBuilder
extends AbstractBuilder<IVaccination> {
    public IVaccinationBuilder(IModelService modelService, IContextService context, IArticle article, IPatient patient) {
        super(modelService);
        this.object = modelService.create(IVaccination.class);
        ((IVaccination)this.object).setDateOfAdministration(LocalDate.now());
        ((IVaccination)this.object).setPatient(patient);
        ((IVaccination)this.object).setArticle(article);
        ((IVaccination)this.object).setArticleName(article.getName());
        ((IVaccination)this.object).setArticleGtin(article.getGtin());
        ((IVaccination)this.object).setArticleAtc(article.getAtcCode());
        if (context != null) {
            ((IVaccination)this.object).setPerformer(context.getActiveUserContact().orElse(null));
        }
    }

    public IVaccinationBuilder(IModelService modelService, IContextService context, String articleName, String articleGtin, String articleAtc, IPatient patient) {
        super(modelService);
        this.object = modelService.create(IVaccination.class);
        ((IVaccination)this.object).setDateOfAdministration(LocalDate.now());
        ((IVaccination)this.object).setPatient(patient);
        ((IVaccination)this.object).setArticleName(articleName);
        ((IVaccination)this.object).setArticleGtin(articleGtin);
        ((IVaccination)this.object).setArticleAtc(articleAtc);
        if (context != null) {
            ((IVaccination)this.object).setPerformer(context.getActiveUserContact().orElse(null));
        }
    }

    public IVaccinationBuilder ingredientsAtc(String ingredientsAtc) {
        ((IVaccination)this.object).setIngredientsAtc(ingredientsAtc);
        return this;
    }

    public IVaccinationBuilder dateOfAdministration(LocalDate dateOfAdministration) {
        ((IVaccination)this.object).setDateOfAdministration(dateOfAdministration);
        return this;
    }
}

