/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.IAddress;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import java.time.LocalDate;

public class IContactBuilder {
    private IContactBuilder() {
    }

    public static class LaboratoryBuilder
    extends AbstractBuilder<ILaboratory> {
        public LaboratoryBuilder(IModelService modelService, String name) {
            super(modelService);
            this.object = modelService.create(ILaboratory.class);
            ((ILaboratory)this.object).setDescription1(name);
        }
    }

    public static class MandatorBuilder
    extends AbstractBuilder<IMandator> {
        public MandatorBuilder(IModelService modelService, String firstName, String lastName) {
            super(modelService);
            this.object = modelService.create(IMandator.class);
            ((IMandator)this.object).setDescription1(lastName);
            ((IMandator)this.object).setDescription2(firstName);
        }
    }

    public static class OrganizationBuilder
    extends AbstractBuilder<IOrganization> {
        public OrganizationBuilder(IModelService modelService, String name) {
            super(modelService);
            this.object = modelService.create(IOrganization.class);
            ((IOrganization)this.object).setDescription1(name);
        }

        public OrganizationBuilder defaultAddress(String street, String zip, String city, Country country) {
            IAddress defaultAddress = this.modelService.create(IAddress.class);
            ((IOrganization)this.object).setStreet(street);
            ((IOrganization)this.object).setZip(zip);
            ((IOrganization)this.object).setCity(city);
            ((IOrganization)this.object).setCountry(country);
            defaultAddress.setStreet1(street);
            defaultAddress.setZip(zip);
            defaultAddress.setCity(city);
            defaultAddress.setCountry(country);
            defaultAddress.setContact((IContact)this.object);
            ((IOrganization)this.object).addChanged(defaultAddress);
            return this;
        }
    }

    public static class PatientBuilder
    extends AbstractBuilder<IPatient> {
        public PatientBuilder(IModelService modelService, String firstName, String lastName, LocalDate dateOfBirth, Gender sex) {
            super(modelService);
            this.object = modelService.create(IPatient.class);
            ((IPatient)this.object).setDescription1(lastName);
            ((IPatient)this.object).setDescription2(firstName);
            ((IPatient)this.object).setDateOfBirth(dateOfBirth.atStartOfDay());
            ((IPatient)this.object).setGender(sex);
        }
    }

    public static class PersonBuilder
    extends AbstractBuilder<IPerson> {
        public PersonBuilder(IModelService modelService, String firstName, String lastName, LocalDate dateOfBirth, Gender sex) {
            super(modelService);
            this.object = modelService.create(IPerson.class);
            ((IPerson)this.object).setDescription1(lastName);
            ((IPerson)this.object).setDescription2(firstName);
            ((IPerson)this.object).setDateOfBirth(dateOfBirth.atStartOfDay());
            ((IPerson)this.object).setGender(sex);
        }

        public PersonBuilder(IModelService modelService, String firstName, String lastName, Gender sex) {
            super(modelService);
            this.object = modelService.create(IPerson.class);
            ((IPerson)this.object).setDescription1(lastName);
            ((IPerson)this.object).setDescription2(firstName);
            ((IPerson)this.object).setGender(sex);
        }

        public PersonBuilder mandator() {
            ((IPerson)this.object).setMandator(true);
            return this;
        }
    }
}

