/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.wizards;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.wizards.DBConnectNewOrEditConnectionWizardPage;
import ch.elexis.core.ui.wizards.DBConnectSelectionConnectionWizardPage;
import ch.elexis.core.ui.wizards.DBConnectWizardPage;
import ch.elexis.core.ui.wizards.Messages;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PlatformUI;

public class DBConnectWizard
extends Wizard {
    private List<DBConnection> storedConnectionList;
    private DBConnection targetedConnection;
    private boolean restartAfterChange = false;
    private DBConnectWizardPage dbConnSelectionPage;
    private DBConnectWizardPage dbConnNewConnPage;
    private final PersistentObject.IClassResolver ccResolver = new PersistentObject.IClassResolver(){

        public Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            if (desc.getName().equals("ch.elexis.core.data.util.DBConnection")) {
                return Thread.currentThread().getContextClassLoader().loadClass("ch.elexis.core.common.DBConnection");
            }
            if (desc.getName().equals("ch.elexis.core.data.util.DBConnection$DBType")) {
                return Thread.currentThread().getContextClassLoader().loadClass("ch.elexis.core.common.DBConnection$DBType");
            }
            return null;
        }
    };

    public DBConnectWizard() {
        this.setWindowTitle(Messages.Core_Create_Connection_to_database);
        this.dbConnSelectionPage = new DBConnectSelectionConnectionWizardPage(Messages.Core_Database_Type);
        this.dbConnNewConnPage = new DBConnectNewOrEditConnectionWizardPage();
        this.initStoredJDBCConnections();
        this.targetedConnection = this.getCurrentConnection();
        this.targetedConnection = this.targetedConnection == null && !this.storedConnectionList.isEmpty() ? this.storedConnectionList.get(0) : new DBConnection();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.dbConnSelectionPage);
        this.addPage((IWizardPage)this.dbConnNewConnPage);
    }

    public List<DBConnection> getStoredConnectionList() {
        ArrayList<DBConnection> arrayList = new ArrayList<DBConnection>(this.storedConnectionList);
        arrayList.add(0, new DBConnection());
        return arrayList;
    }

    public boolean performFinish() {
        if (!this.testDatabaseConnection()) {
            return false;
        }
        if (!this.storedConnectionList.contains(this.targetedConnection)) {
            this.storedConnectionList.add(this.targetedConnection);
        }
        this.storeJDBCConnections();
        this.setUsedConnection();
        if (this.restartAfterChange) {
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().restart();
                }
            });
        }
        return true;
    }

    public boolean canFinish() {
        return this.targetedConnection.allValuesSet();
    }

    public void setTargetedConnection(DBConnection targetedConnection) {
        this.targetedConnection = targetedConnection;
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public DBConnection getTargetedConnection() {
        return this.targetedConnection;
    }

    public void setRestartAfterConnectionChange(boolean restartAfterChange) {
        this.restartAfterChange = restartAfterChange;
    }

    public boolean getRestartAfterConnectionChange() {
        return this.restartAfterChange;
    }

    private void initStoredJDBCConnections() {
        String storage = CoreHub.localCfg.get("verbindung/storedJDBCConnections/connection", null);
        if (storage != null) {
            this.storedConnectionList = (List)PersistentObject.foldObject((byte[])StringTool.dePrintable((String)storage), (PersistentObject.IClassResolver)this.ccResolver);
        } else {
            Hashtable hConn;
            this.storedConnectionList = new ArrayList<DBConnection>();
            String cnt = CoreHub.localCfg.get("verbindung/folded_string", null);
            if (cnt != null && (hConn = PersistentObject.fold((byte[])StringTool.dePrintable((String)cnt), (PersistentObject.IClassResolver)this.ccResolver)) != null) {
                String connectionString = PersistentObject.checkNull(hConn.get("connectionstring"));
                String user = PersistentObject.checkNull(hConn.get("user"));
                String pwd = PersistentObject.checkNull(hConn.get("pwd"));
                DBConnection dbc = new DBConnection();
                dbc.connectionString = connectionString;
                dbc.rdbmsType = this.parseDBTyp(connectionString);
                dbc.hostName = this.parseHostname(connectionString);
                dbc.username = user;
                dbc.password = pwd;
                this.storedConnectionList.add(dbc);
                this.storeJDBCConnections();
            }
        }
    }

    private String parseHostname(String connectionString) {
        int i = connectionString.indexOf("//") + 2;
        if (i == -1) {
            return "";
        }
        String woHeader = connectionString.substring(i);
        int ij = woHeader.indexOf(":");
        if (ij == -1) {
            return "";
        }
        return woHeader.substring(0, ij);
    }

    @Nullable
    private DBConnection.DBType parseDBTyp(String connectionString) {
        if (connectionString.contains(":h2:")) {
            return DBConnection.DBType.H2;
        }
        if (connectionString.contains(":mysql:")) {
            return DBConnection.DBType.MySQL;
        }
        if (connectionString.contains(":postgresql:")) {
            return DBConnection.DBType.PostgreSQL;
        }
        return null;
    }

    void storeJDBCConnections() {
        Assert.isNotNull(this.storedConnectionList);
        byte[] flatten = PersistentObject.flattenObject(this.storedConnectionList);
        String enPrintable = StringTool.enPrintable((byte[])flatten);
        CoreHub.localCfg.set("verbindung/storedJDBCConnections/connection", enPrintable);
        CoreHub.localCfg.flush();
    }

    @Nullable
    public DBConnection getCurrentConnection() {
        Hashtable hConn;
        String cnt = CoreHub.localCfg.get("verbindung/folded_string", null);
        if (cnt != null && (hConn = PersistentObject.fold((byte[])StringTool.dePrintable((String)cnt), (PersistentObject.IClassResolver)this.ccResolver)) != null) {
            String currConnString = PersistentObject.checkNull(hConn.get("connectionstring"));
            String user = PersistentObject.checkNull(hConn.get("user"));
            String combined = user + "@" + currConnString;
            for (DBConnection dbConnection : this.storedConnectionList) {
                if (!combined.equalsIgnoreCase(dbConnection.username + "@" + dbConnection.connectionString)) continue;
                return dbConnection;
            }
        }
        return null;
    }

    private boolean setUsedConnection() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("driver", this.targetedConnection.rdbmsType.driverName);
        h.put("connectionstring", this.targetedConnection.connectionString);
        h.put("user", this.targetedConnection.username);
        h.put("pwd", this.targetedConnection.password);
        h.put("typ", this.targetedConnection.rdbmsType.dbType);
        String conn = StringTool.enPrintable((byte[])PersistentObject.flatten(h));
        CoreHub.localCfg.set("verbindung/folded_string", conn);
        CoreHub.localCfg.flush();
        return true;
    }

    public void removeConnection(DBConnection connection) {
        this.storedConnectionList.remove(connection);
        this.storeJDBCConnections();
    }

    private boolean testDatabaseConnection() {
        boolean error = true;
        JdbcLink j = null;
        Object text = null;
        try {
            String hostname;
            String string = hostname = this.targetedConnection.port != null ? this.targetedConnection.hostName + ":" + this.targetedConnection.port : this.targetedConnection.hostName;
            if (this.targetedConnection.databaseName == null || this.targetedConnection.databaseName.isEmpty()) {
                throw new IllegalArgumentException("No database name provided.");
            }
            switch (this.targetedConnection.rdbmsType) {
                case H2: {
                    j = JdbcLink.createH2Link((String)this.targetedConnection.databaseName);
                    break;
                }
                case MySQL: {
                    j = JdbcLink.createMySqlLink((String)hostname, (String)this.targetedConnection.databaseName);
                    break;
                }
                case PostgreSQL: {
                    j = JdbcLink.createPostgreSQLLink((String)hostname, (String)this.targetedConnection.databaseName);
                    break;
                }
                default: {
                    j = null;
                }
            }
            Assert.isNotNull(j);
            j.connect(this.targetedConnection.username, this.targetedConnection.password);
            text = "Verbindung hergestellt";
            error = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            text = "Exception " + e.getMessage();
        }
        this.dbConnNewConnPage.getTdbg().setTestResult(error, (String)text);
        if (j == null) {
            return true;
        }
        if (!error) {
            this.targetedConnection.connectionString = j.getConnectString();
        }
        return !error;
    }
}

