/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class DaysOrDateSelectionComposite
extends Composite
implements ISelectionProvider {
    private ListenerList selectionListeners = new ListenerList();
    private Spinner days;
    private DateTime date;
    private LocalDate dateValue;
    private int daysValue;

    public DaysOrDateSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label((Composite)this, 0);
        label.setText("Tage");
        this.days = new Spinner((Composite)this, 2048);
        this.days.setMaximum(999);
        this.days.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DaysOrDateSelectionComposite.this.updateDays();
                DaysOrDateSelectionComposite.this.callSelectionListeners();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText("Datum");
        this.date = new DateTime((Composite)this, 0);
        this.date.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DaysOrDateSelectionComposite.this.updateDate();
                DaysOrDateSelectionComposite.this.callSelectionListeners();
            }
        });
        this.setDate(LocalDate.now());
    }

    private void updateDays() {
        this.daysValue = this.days.getSelection();
        this.dateValue = LocalDate.now().minusDays(this.days.getSelection());
        this.date.setDate(this.dateValue.getYear(), this.dateValue.getMonthValue() - 1, this.dateValue.getDayOfMonth());
    }

    private void updateDate() {
        this.dateValue = LocalDate.of(this.date.getYear(), this.date.getMonth() + 1, this.date.getDay());
        this.daysValue = (int)ChronoUnit.DAYS.between(this.dateValue, LocalDate.now());
        this.days.setSelection(this.daysValue);
    }

    public void setDate(LocalDate newDate) {
        if (newDate != null) {
            this.dateValue = newDate;
            this.date.setDate(this.dateValue.getYear(), this.dateValue.getMonthValue() - 1, this.dateValue.getDayOfMonth());
            this.daysValue = (int)ChronoUnit.DAYS.between(this.dateValue, LocalDate.now());
            this.days.setSelection(this.daysValue);
        }
    }

    private void callSelectionListeners() {
        Object[] listeners = this.selectionListeners.getListeners();
        if (listeners != null && listeners.length > 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((ISelectionChangedListener)object).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.dateValue != null) {
            return new StructuredSelection((Object)this.dateValue);
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            if (!selection.isEmpty()) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof LocalDate) {
                    this.setDate((LocalDate)element);
                }
            } else {
                this.setDate(null);
            }
        }
    }
}

