/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.AddBuchungDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.controls.ClientCustomTextTokenEditDialog;
import ch.elexis.data.Patient;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ClientCustomTextComposite
extends Composite {
    private StyledText txtClientCustomText;
    private Button btnEditCustomText;
    private DropTarget txtClientCustomTextdropTarget;
    private List<TokenMap> tokenMap = new ArrayList<TokenMap>();
    private List<StyleRange> styleList = new ArrayList<StyleRange>();
    private ScrolledForm scrldfrm;

    public ClientCustomTextComposite(Composite parent, int style, FormToolkit toolkit, ScrolledForm scrldfrm) {
        super(parent, style);
        this.scrldfrm = scrldfrm;
        this.setLayoutData(new TableWrapData(256, 16, 1, 1));
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        this.setLayout((Layout)twl);
        this.txtClientCustomText = new StyledText((Composite)this, 66);
        TableWrapData twd_txtClientCustomText = new TableWrapData(2, 16, 1, 1);
        twd_txtClientCustomText.valign = 32;
        twd_txtClientCustomText.grabHorizontal = true;
        this.txtClientCustomText.setLayoutData((Object)twd_txtClientCustomText);
        this.txtClientCustomText.setEditable(false);
        this.txtClientCustomText.setDoubleClickEnabled(false);
        this.txtClientCustomText.addListener(24, (Listener)new StyledTextMultiLineAutoGrowListener());
        this.txtClientCustomText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StyledText st = (StyledText)e.widget;
                TokenMap token = ClientCustomTextComposite.this.getTokenFromCarePosition(st.getCaretOffset());
                if (token == null) {
                    return;
                }
                String tokenAttribute = token.token.split("\\.")[1];
                if (tokenAttribute.equals("E-Mail")) {
                    try {
                        URI uriMailTo = new URI("mailto", token.value, null);
                        Desktop.getDesktop().mail(uriMailTo);
                    }
                    catch (Exception uriMailTo) {}
                } else if (tokenAttribute.equals("Balance")) {
                    Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
                    if (new AddBuchungDialog(ClientCustomTextComposite.this.getShell(), actPatient).open() == 0) {
                        ClientCustomTextComposite.this.updateClientCustomArea();
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                StyledText st = (StyledText)e.widget;
                String token = ClientCustomTextComposite.this.getTokenFromCarePosition((int)st.getCaretOffset()).token;
                if (token != null) {
                    ClientCustomTextTokenEditDialog cctted = new ClientCustomTextTokenEditDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), token);
                    cctted.open();
                    ClientCustomTextComposite.this.updateClientCustomArea();
                }
            }
        });
        this.txtClientCustomTextdropTarget = new DropTarget((Control)this.txtClientCustomText, 1);
        this.txtClientCustomTextdropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.txtClientCustomTextdropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = ClientCustomTextComposite.this.btnEditCustomText.getSelection() ? 1 : 0;
            }

            public void drop(DropTargetEvent event) {
                ClientCustomTextComposite.this.txtClientCustomText.setText(ClientCustomTextComposite.this.txtClientCustomText.getText() + String.valueOf(event.data));
            }
        });
        this.btnEditCustomText = toolkit.createButton((Composite)this, "", 2);
        TableWrapData twd_btnEditCustomText = new TableWrapData(2, 16, 1, 1);
        twd_btnEditCustomText.valign = 32;
        this.btnEditCustomText.setLayoutData((Object)twd_btnEditCustomText);
        this.btnEditCustomText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientCustomTextComposite.this.btnEditCustomText.getSelection()) {
                    ClientCustomTextComposite.this.txtClientCustomText.setBackground(UiDesk.getDisplay().getSystemColor(29));
                } else {
                    ClientCustomTextComposite.this.txtClientCustomText.setBackground(null);
                }
                ClientCustomTextComposite.this.txtClientCustomText.setEditable(ClientCustomTextComposite.this.btnEditCustomText.getSelection());
                ClientCustomTextComposite.this.setClientCustomAreaContent(ClientCustomTextComposite.this.btnEditCustomText.getSelection());
            }
        });
        this.btnEditCustomText.setImage(Images.IMG_PENCIL_8PX.getImage());
        GridData gd_btnEditCustomText = new GridData(16384, 128, false, false, 1, 1);
        gd_btnEditCustomText.heightHint = 10;
        gd_btnEditCustomText.widthHint = 10;
        if (toolkit != null) {
            toolkit.adapt((Composite)this);
            toolkit.adapt((Control)this.txtClientCustomText, true, true);
            toolkit.adapt((Control)this.btnEditCustomText, false, false);
        }
    }

    private void setClientCustomAreaContent(boolean editMode) {
        if (editMode) {
            this.txtClientCustomText.setText(ConfigServiceHolder.getGlobal((String)ClientCustomTextComposite.class.getName(), (String)""));
        } else {
            ConfigServiceHolder.setGlobal((String)ClientCustomTextComposite.class.getName(), (String)this.txtClientCustomText.getText());
            this.updateClientCustomArea();
        }
    }

    public void updateClientCustomArea() {
        this.tokenMap.clear();
        this.styleList.clear();
        String outputParsed = this.findAndReplaceTemplates(ConfigServiceHolder.getGlobal((String)ClientCustomTextComposite.class.getName(), (String)""));
        String output = this.initializeStyleRanges(outputParsed);
        this.txtClientCustomText.setText(output);
        this.txtClientCustomText.setStyleRanges(this.styleList.toArray(new StyleRange[0]));
    }

    private String initializeStyleRanges(String output) {
        for (TokenMap tm : this.tokenMap) {
            String tokenAttribute = tm.token.split("\\.")[1];
            if (!tokenAttribute.equals("E-Mail") && !tokenAttribute.equals("Balance")) continue;
            StyleRange sr = new StyleRange();
            sr.start = tm.start;
            sr.length = tm.end - tm.start;
            sr.foreground = PlatformUI.getWorkbench().getDisplay().getSystemColor(9);
            this.styleList.add(sr);
        }
        return output;
    }

    private String findAndReplaceTemplates(String replaceString) {
        StringBuilder sb = new StringBuilder();
        char[] rs = replaceString.toCharArray();
        StringBuilder replace = new StringBuilder();
        TokenMap tempTM = new TokenMap();
        boolean variable = false;
        int i = 0;
        while (i < rs.length) {
            switch (rs[i]) {
                case '[': {
                    tempTM = new TokenMap();
                    tempTM.start = sb.length();
                    replace = new StringBuilder();
                    variable = true;
                    break;
                }
                case ']': {
                    variable = false;
                    tempTM.token = replace.toString();
                    tempTM.value = this.replaceValue(replace.toString());
                    sb.append(this.replaceValue(replace.toString()));
                    tempTM.end = sb.length();
                    this.tokenMap.add(tempTM);
                    tempTM = new TokenMap();
                    break;
                }
                default: {
                    if (variable) {
                        replace.append(rs[i]);
                        break;
                    }
                    sb.append(rs[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String replaceValue(String replace) {
        String[] arr = replace.split("\\.");
        if (arr == null || arr.length < 2) {
            return "ERR";
        }
        if (arr[0].equalsIgnoreCase("Patient")) {
            if (arr[1] == null) {
                return "";
            }
            Patient pat = ElexisEventDispatcher.getSelectedPatient();
            if (pat == null) {
                return "";
            }
            String result = pat.get(arr[1]);
            return result != null ? result : "";
        }
        return "ERR";
    }

    private TokenMap getTokenFromCarePosition(int caretPosition) {
        for (TokenMap tm : this.tokenMap) {
            if (tm.start > caretPosition || tm.end < caretPosition) continue;
            return tm;
        }
        return null;
    }

    public StyledText getTxtClientCustomText() {
        return this.txtClientCustomText;
    }

    private final class StyledTextMultiLineAutoGrowListener
    implements Listener {
        protected int lines = 0;

        private StyledTextMultiLineAutoGrowListener() {
        }

        public void handleEvent(Event event) {
            if (event.type != 24) {
                return;
            }
            if (ClientCustomTextComposite.this.txtClientCustomText.getLineCount() != this.lines) {
                this.lines = ClientCustomTextComposite.this.txtClientCustomText.getLineCount();
                ClientCustomTextComposite.this.txtClientCustomText.setSize(ClientCustomTextComposite.this.txtClientCustomText.getSize().x, this.lines * (int)ClientCustomTextComposite.this.txtClientCustomText.getFont().getFontData()[0].height);
            }
            ClientCustomTextComposite.this.scrldfrm.reflow(true);
        }
    }

    private class TokenMap {
        public int start;
        public int end;
        public String token;
        public String value;

        private TokenMap() {
        }
    }
}

