/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.AbstractDataLoaderJob;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class PatHeuteView
extends ViewPart
implements IRefreshable,
BackgroundJob.BackgroundJobListener {
    public static final String ID = "ch.elexis.PatHeuteView";
    static final String LEISTUNG_HINZU = Messages.Core_Add_Caption;
    static final String STAT_LEEREN = Messages.PatHeuteView_empty;
    private IAction printAction;
    private IAction reloadAction;
    private IAction filterAction;
    private IAction statAction;
    CommonViewer cv;
    ViewerConfigurer vc;
    FormToolkit tk = UiDesk.getToolkit();
    Form form;
    Text tPat;
    Text tTime;
    Text tMoney;
    Text tTime2;
    Text tMoney2;
    TimeTool datVon;
    TimeTool datBis;
    boolean bOpen = true;
    boolean bClosed = true;
    private String accountSys;
    private Konsultation[] kons;
    private final KonsLoader kload;
    private int numPat;
    private double sumTime;
    private double sumAll;
    GenericObjectDropTarget dropTarget;
    ListDisplay<IBillable> ldFilter;
    private final Query<Konsultation> qbe;
    Composite parent;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);

    @Inject
    void activeEncounter(@Optional IEncounter encounter) {
        Display.getDefault().syncExec(() -> CoreUiUtil.runIfActive(() -> this.selection((Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)encounter)), (Object)this.cv));
    }

    @Inject
    void activeMandator(@Optional IMandator mandator) {
        Display.getDefault().syncExec(() -> CoreUiUtil.runIfActive(() -> {
            if (this.kload != null) {
                this.kload.schedule();
            }
        }, (Object)this.cv));
    }

    public PatHeuteView() {
        this.datVon = new TimeTool();
        this.datBis = new TimeTool();
        this.qbe = new Query(Konsultation.class);
        this.kload = new KonsLoader(this.qbe);
        this.kload.addListener(this);
    }

    public void createPartControl(final Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.parent = parent;
        this.makeActions();
        this.ldFilter = new ListDisplay(parent, 0, new ListDisplay.LDListener(){

            @Override
            public String getLabel(Object o) {
                return ((IBillable)o).getLabel();
            }

            @Override
            public void hyperlinkActivated(String l) {
                if (l.equals(LEISTUNG_HINZU)) {
                    try {
                        if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                            SWTHelper.alert(Messages.Core_Error, "LeistungenView.ID");
                        }
                        PatHeuteView.this.getViewSite().getPage().showView("ch.elexis.LeistungenView");
                        CodeSelectorHandler.getInstance().setCodeSelectorTarget(PatHeuteView.this.dropTarget);
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                } else if (l.equals(STAT_LEEREN)) {
                    PatHeuteView.this.ldFilter.clear();
                    parent.layout(true);
                }
            }
        });
        this.ldFilter.addHyperlinks(LEISTUNG_HINZU, STAT_LEEREN);
        this.ldFilter.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        ((GridData)this.ldFilter.getLayoutData()).heightHint = 0;
        this.dropTarget = new GenericObjectDropTarget("Statfilter", (Control)this.ldFilter, new DropReceiver());
        Composite top = new Composite(parent, 2048);
        top.setLayout((Layout)new RowLayout());
        final DatePickerCombo dpc = new DatePickerCombo(top, 2048);
        dpc.setDate(this.datVon.getTime());
        dpc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.datVon.setTimeInMillis(dpc.getDate().getTime());
            }
        });
        final DatePickerCombo dpb = new DatePickerCombo(top, 2048);
        dpb.setDate(this.datBis.getTime());
        dpb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.datBis.setTimeInMillis(dpb.getDate().getTime());
            }
        });
        final Button bOpenKons = new Button(top, 32);
        bOpenKons.setText(Messages.PatHeuteView_open);
        bOpenKons.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.bOpen = bOpenKons.getSelection();
            }
        });
        final Button bClosedKons = new Button(top, 32);
        bClosedKons.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.bClosed = bClosedKons.getSelection();
            }
        });
        ComboViewer cAccountingSys = new ComboViewer(top, 8);
        cAccountingSys.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        cAccountingSys.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String allCases = Messages.Core_All;
        List<String> faelle = Arrays.asList(BillingSystem.getAbrechnungsSysteme());
        ArrayList<String> accountingSys = new ArrayList<String>();
        accountingSys.add(allCases);
        accountingSys.addAll(faelle);
        cAccountingSys.setInput(accountingSys);
        cAccountingSys.setSelection((ISelection)new StructuredSelection((Object)allCases));
        cAccountingSys.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PatHeuteView.this.accountSys = (String)selection.getFirstElement();
                if (PatHeuteView.this.kons != null) {
                    PatHeuteView.this.kload.schedule();
                }
            }
        });
        bClosedKons.setText(Messages.PatHeuteView_billed);
        bOpenKons.setSelection(this.bOpen);
        bClosedKons.setSelection(this.bClosed);
        this.cv = new CommonViewer();
        this.vc = new ViewerConfigurer(new DefaultContentProvider(this.cv, Patient.class){

            @Override
            public Object[] getElements(Object inputElement) {
                if (!AccessControlServiceHolder.get().evaluate(EvACEs.ACCOUNTING_STATS)) {
                    return new Konsultation[0];
                }
                if (PatHeuteView.this.kons == null) {
                    PatHeuteView.this.kons = new Konsultation[0];
                    PatHeuteView.this.kload.schedule();
                }
                return PatHeuteView.this.kons;
            }
        }, new DefaultLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof Konsultation) {
                    Fall fall = ((Konsultation)element).getFall();
                    if (fall == null) {
                        return Messages.PatHeuteView_noCase + ((Konsultation)element).getLabel();
                    }
                    Patient pat = fall.getPatient();
                    return pat.getLabel();
                }
                return super.getText(element);
            }
        }, null, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(1, 512, this.cv)).setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Konsultation selectedKons;
                if (event.getStructuredSelection() != null && !event.getStructuredSelection().isEmpty() && event.getStructuredSelection().getFirstElement() instanceof Konsultation && (selectedKons = (Konsultation)event.getStructuredSelection().getFirstElement()).getFall() != null && selectedKons.getFall().getPatient() != null) {
                    Patient pat = selectedKons.getFall().getPatient();
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)pat, pat.getClass(), 16, 1)});
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)selectedKons);
                }
            }
        });
        this.cv.create(this.vc, parent, 0, this.getViewSite());
        this.form = this.tk.createForm(parent);
        this.form.setText(Messages.Core_All);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Composite bottom = this.form.getBody();
        bottom.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(bottom, Messages.Core_Consultations);
        this.tPat = this.tk.createText(bottom, "", 2048);
        this.tPat.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tPat.setEditable(false);
        this.tk.createLabel(bottom, Messages.PatHeuteView_accTime);
        this.tTime = this.tk.createText(bottom, "", 2048);
        this.tTime.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tTime.setEditable(false);
        this.tk.createLabel(bottom, Messages.PatHeuteView_accAmount);
        this.tMoney = this.tk.createText(bottom, "", 2048);
        this.tMoney.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tMoney.setEditable(false);
        Form fSel = this.tk.createForm(parent);
        fSel.setText(Messages.PatHeuteView_marked);
        fSel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Composite cSel = fSel.getBody();
        cSel.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(cSel, Messages.PatHeuteView_accTime);
        this.tTime2 = this.tk.createText(cSel, "", 2048);
        this.tTime2.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(cSel, Messages.PatHeuteView_accAmount);
        this.tMoney2 = this.tk.createText(cSel, "", 2048);
        this.tMoney2.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tTime2.setEditable(false);
        this.tMoney2.setEditable(false);
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createMenu(this.printAction, this.reloadAction, this.statAction);
        menus.createToolbar(this.reloadAction, this.filterAction);
        this.cv.getConfigurer().getContentProvider().startListening();
        this.kload.schedule();
        this.cv.addDoubleClickListener(new CommonViewer.PoDoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                Konsultation k = (Konsultation)obj;
                Patient pat = k.getFall().getPatient();
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)pat, pat.getClass(), 16, 1)});
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.Konsdetail");
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        this.cv.getConfigurer().getContentProvider().stopListening();
        this.kload.removeListener(this);
    }

    public void setFocus() {
        this.cv.notify(CommonViewer.Message.update);
    }

    private void selection(Konsultation k) {
        if (k == null) {
            this.tTime2.setText("");
            this.tMoney2.setText("");
        } else {
            try {
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                this.tTime2.setText(Integer.toString(this.getMinutes(encounter)));
                Money mon = new Money();
                for (IBilled billed : encounter.getBilled()) {
                    mon = mon.addMoney(billed.getTotal());
                }
                this.tMoney2.setText(mon.getAmountAsString());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private int getMinutes(IEncounter encounter) {
        return encounter.getBilled().stream().mapToInt(b -> {
            if (b.getBillable() instanceof IService) {
                return (int)((double)((IService)b.getBillable()).getMinutes() * b.getAmount());
            }
            return 0;
        }).sum();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        if (j.isValid()) {
            this.kons = (Konsultation[])j.getData();
            if (!AccessControlServiceHolder.get().evaluate(EvACEs.ACCOUNTING_STATS)) {
                this.tPat.setText("Sie haben keine Rechte f\u00fcr diese View");
            } else {
                this.tPat.setText(Integer.toString(this.numPat));
                this.tTime.setText(Double.toString(this.sumTime));
                DecimalFormat df = new DecimalFormat("0.00");
                this.tMoney.setText(df.format(this.sumAll));
                if (this.kons.length >= 1) {
                    this.selection(this.kons[this.kons.length - 1]);
                }
                this.cv.notify(CommonViewer.Message.update);
            }
        } else {
            this.kons = new Konsultation[0];
        }
    }

    private void makeActions() {
        this.statAction = new Action(Messages.PatHeuteView_statisticsAction){
            {
                this.setToolTipText(Messages.PatHeuteView_statisticsToolTip);
            }

            public void run() {
                StatLoader loader = new StatLoader();
                loader.schedule();
            }
        };
        this.printAction = new Action(Messages.Core_Print_List){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.PatHeuteView_printListToolTip);
            }

            public void run() {
                TerminListeDialog tld = new TerminListeDialog(PatHeuteView.this.getViewSite().getShell());
                tld.open();
            }
        };
        this.reloadAction = new Action(Messages.Core_Reload){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText(Messages.Core_Reread_List);
            }

            public void run() {
                PatHeuteView.this.kons = null;
                PatHeuteView.this.kload.schedule();
            }
        };
        this.filterAction = new Action(Messages.Core_Filter, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.PatHeuteView_filterToolTip);
            }

            public void run() {
                GridData gd = (GridData)PatHeuteView.this.ldFilter.getLayoutData();
                gd.heightHint = PatHeuteView.this.filterAction.isChecked() ? -1 : 0;
                PatHeuteView.this.parent.layout(true);
            }
        };
    }

    @Override
    public void refresh() {
        this.selection((Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)ContextServiceHolder.get().getTyped(IEncounter.class).orElse(null)));
    }

    private final class DropReceiver
    implements GenericObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        @Override
        public void dropped(List<Object> list, DropTargetEvent e) {
            for (Object o : list) {
                if (!(o instanceof IBillable)) continue;
                PatHeuteView.this.ldFilter.add((IBillable)o);
            }
            PatHeuteView.this.ldFilter.getDisplay().asyncExec(() -> PatHeuteView.this.parent.layout(true));
        }

        @Override
        public boolean accept(List<Object> list) {
            for (Object o : list) {
                if (o instanceof IBillable) continue;
                return false;
            }
            return true;
        }
    }

    class KonsLoader
    extends AbstractDataLoaderJob {
        IBillable[] lfiltered;
        Set<Konsultation> corruptKons;
        Set<Konsultation> missingCaseKons;

        KonsLoader(Query<Konsultation> qbe) {
            super(Messages.Core_Load_Consultations, qbe, new String[]{Messages.Core_Date});
            this.setPriority(30);
            this.setUser(true);
        }

        @Override
        public IStatus execute(IProgressMonitor monitor) {
            if (CoreHub.getLoggedInContact() == null) {
                return Status.CANCEL_STATUS;
            }
            this.corruptKons = new HashSet<Konsultation>();
            this.missingCaseKons = new HashSet<Konsultation>();
            monitor.beginTask(Messages.Core_Load_Consultations, 1000);
            this.qbe.clear();
            this.qbe.add("Datum", ">=", PatHeuteView.this.datVon.toString(9));
            this.qbe.add("Datum", "<=", PatHeuteView.this.datBis.toString(9));
            if (ContextServiceHolder.getActiveMandatorOrNull() == null) {
                monitor.done();
                return Status.OK_STATUS;
            }
            ContextServiceHolder.get().getActiveMandator().ifPresent(m -> this.qbe.add("MandantID", "=", m.getId()));
            if (PatHeuteView.this.bOpen && !PatHeuteView.this.bClosed) {
                this.qbe.add("RechnungsID", "", null);
            }
            if (PatHeuteView.this.bClosed && !PatHeuteView.this.bOpen) {
                this.qbe.add("RechnungsID", "NOT", null);
            }
            if (!PatHeuteView.this.bClosed && !PatHeuteView.this.bOpen) {
                this.qbe.insertFalse();
            }
            this.qbe.orderBy(false, new String[]{"Datum", "Zeit"});
            this.qbe.addPostQueryFilter(new IFilter(){

                public boolean select(Object toTest) {
                    if (((KonsLoader)KonsLoader.this).PatHeuteView.this.filterAction.isChecked()) {
                        List<IBillable> lFilt = ((KonsLoader)KonsLoader.this).PatHeuteView.this.ldFilter.getAll();
                        if (lFilt != null && !lFilt.isEmpty()) {
                            IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)((Konsultation)toTest), IEncounter.class).get();
                            for (IBilled b : encounter.getBilled()) {
                                if (!lFilt.contains(b.getBillable())) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
            ArrayList<Konsultation> list = this.qbe.execute();
            monitor.worked(100);
            PatHeuteView.this.numPat = 0;
            PatHeuteView.this.sumAll = 0.0;
            PatHeuteView.this.sumTime = 0.0;
            if (list == null) {
                this.result = new Konsultation[0];
            } else {
                if (PatHeuteView.this.accountSys != null && !PatHeuteView.this.accountSys.isEmpty() && !PatHeuteView.this.accountSys.equals(Messages.Core_All)) {
                    ArrayList<Konsultation> konsRet = new ArrayList<Konsultation>();
                    for (Konsultation kons : list) {
                        if (!kons.getFall().getAbrechnungsSystem().equals(PatHeuteView.this.accountSys)) continue;
                        konsRet.add(kons);
                    }
                    list = konsRet;
                }
                Konsultation[] ret = new Konsultation[list.size()];
                if (PatHeuteView.this.filterAction.isChecked()) {
                    this.lfiltered = PatHeuteView.this.ldFilter.getAll().toArray(new IBillable[0]);
                    if (this.lfiltered.length == 0) {
                        this.lfiltered = null;
                    }
                } else {
                    this.lfiltered = null;
                }
                int i = 0;
                for (PersistentObject persistentObject : list) {
                    if (((Konsultation)persistentObject).getFall() == null) {
                        this.missingCaseKons.add((Konsultation)persistentObject);
                    }
                    try {
                        ret[i++] = (Konsultation)persistentObject;
                        IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)((Konsultation)persistentObject), IEncounter.class).get();
                        if (this.lfiltered != null) {
                            for (IBilled b : encounter.getBilled()) {
                                double num = b.getAmount();
                                Money preis = b.getTotal();
                                int j = 0;
                                while (j < this.lfiltered.length) {
                                    if (this.lfiltered[j].equals(b.getBillable())) {
                                        PatHeuteView.this.sumAll += (double)preis.getCents();
                                        if (b.getBillable() instanceof IService) {
                                            PatHeuteView.this.sumTime += (double)((IService)b.getBillable()).getMinutes() * b.getAmount();
                                        }
                                    }
                                    ++j;
                                }
                            }
                        } else {
                            for (IBilled b : encounter.getBilled()) {
                                PatHeuteView.this.sumAll += b.getTotal().doubleValue();
                            }
                            PatHeuteView.this.sumTime += (double)PatHeuteView.this.getMinutes(encounter);
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        monitor.done();
                        this.result = new Konsultation[0];
                        return Status.CANCEL_STATUS;
                    }
                    catch (NullPointerException np) {
                        this.corruptKons.add((Konsultation)persistentObject);
                    }
                }
                PatHeuteView.this.numPat = ret.length;
                this.result = ret;
                monitor.done();
            }
            StringBuilder sb = new StringBuilder();
            if (!this.corruptKons.isEmpty()) {
                sb.append("Folgende Konsultationen enthalten ung\u00fcltige Leistungen: \n");
                for (Konsultation k : this.corruptKons) {
                    sb.append(k.getLabel() + ", " + k.getFall().getPatient().getLabel());
                    sb.append("\n");
                }
                sb.append("\n");
            }
            if (!this.missingCaseKons.isEmpty()) {
                sb.append("Folgende Konsultationen sind keinem Fall zugewiesen: \n");
                for (Konsultation k : this.missingCaseKons) {
                    sb.append(k.getLabel());
                    sb.append("\n");
                }
            }
            if (sb.length() > 0) {
                SWTHelper.showError("Achtung", "Fehlerhafte Konsultation(en) vorhanden!\n" + sb.toString());
                log.log("The following consultations contain invalid values...\n" + sb.toString(), 2);
            }
            return Status.OK_STATUS;
        }

        @Override
        public int getSize() {
            return 100;
        }
    }

    private static class StatCounter
    implements Comparable<StatCounter> {
        IBillable v;
        Money sum;
        Money cost;
        double num;

        StatCounter(IBillable iBillable) {
            this.v = iBillable;
            this.sum = new Money();
            this.cost = new Money();
            this.num = 0.0;
        }

        void add(double num, Money total, Money cost) {
            Money totalCost = cost.multiply(num);
            this.num += num;
            this.sum.addMoney(total);
            this.cost.addMoney(totalCost);
        }

        @Override
        public int compareTo(StatCounter o) {
            int vgroup;
            IBillable iv;
            String v1 = null;
            String v2 = null;
            String vc1 = null;
            String vc2 = null;
            if (this.v != null) {
                v1 = this.v.getCodeSystemName();
                vc1 = this.v.getCode();
            }
            if ((iv = o.v) != null) {
                v2 = iv.getCodeSystemName();
                vc2 = iv.getCode();
            }
            if ((vgroup = StringTool.compareWithNull((String)v1, (String)v2)) != 0) {
                return vgroup;
            }
            int vCode = StringTool.compareWithNull((String)vc1, (String)vc2);
            if (vCode != 0) {
                return vCode;
            }
            return this.sum.getCents() - o.sum.getCents();
        }

        public Money getGewinn() {
            Money ret = new Money(this.sum);
            ret.subtractMoney(this.cost);
            return ret;
        }
    }

    class StatLoader
    extends Job {
        StatLoader() {
            super(Messages.PatHeuteView_calculateStats);
            this.setPriority(30);
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            HashMap<IBillable, StatCounter> counter = new HashMap<IBillable, StatCounter>();
            monitor.beginTask(Messages.PatHeuteView_calculateStats, PatHeuteView.this.kons.length + 20);
            System.out.println(Messages.PatHeuteView_consElexis + PatHeuteView.this.kons.length);
            int serviceCounter = 0;
            Konsultation[] konsultationArray = PatHeuteView.this.kons;
            int n = PatHeuteView.this.kons.length;
            int n2 = 0;
            while (n2 < n) {
                Konsultation k = konsultationArray[n2];
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                List list = encounter.getBilled();
                serviceCounter += list.size();
                for (IBilled billed : list) {
                    StatCounter sc = (StatCounter)counter.get(billed.getBillable());
                    if (sc == null) {
                        sc = new StatCounter(billed.getBillable());
                        counter.put(billed.getBillable(), sc);
                    }
                    sc.add(billed.getAmount(), billed.getTotal(), billed.getNetPrice());
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ++n2;
            }
            System.out.println(Messages.PatHeuteView_servicesElexis + serviceCounter);
            final LinkedList sums = new LinkedList(counter.values());
            Collections.sort(sums);
            monitor.worked(20);
            monitor.done();
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileDialog fd = new FileDialog(PatHeuteView.this.getSite().getShell(), 8192);
                    fd.setFilterExtensions(new String[]{"*.csv", "*.*"});
                    fd.setFilterNames(new String[]{"CSV", Messages.Core_All_Files});
                    fd.setFileName("elexis-stat.csv");
                    String fname = fd.open();
                    if (fname != null) {
                        try {
                            FileWriter fw = new FileWriter(fname);
                            fw.write(Messages.PatHeuteView_csvHeader);
                            for (StatCounter st : sums) {
                                StringBuilder sb = new StringBuilder();
                                String code = "unknown";
                                String text = "unknown";
                                if (st.v != null) {
                                    code = st.v.getCode();
                                    text = st.v.getText();
                                }
                                text = text == null ? "" : text.replaceAll(";", ",");
                                if (st.v != null && st.v.getCodeSystemName() != null) {
                                    sb.append(st.v.getCodeSystemName());
                                } else {
                                    sb.append("Codesystem?");
                                }
                                sb.append("; ").append(code == null ? "" : code).append("; ").append(text).append(";").append(st.num).append(";").append(st.cost.getAmountAsString()).append(";").append(st.sum.getAmountAsString()).append(";").append(st.getGewinn().getAmountAsString()).append("\r\n");
                                fw.write(sb.toString());
                            }
                            fw.close();
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            SWTHelper.showError(Messages.Core_Error_While_writing, ex.getMessage());
                        }
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    class TerminListeDialog
    extends TitleAreaDialog
    implements ITextPlugin.ICallback {
        IBillable[] lfiltered;
        int[] numLeistung;
        Money[] perLeistung;
        private TextContainer text;

        public TerminListeDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            this.text = new TextContainer(this.getShell());
            ret.setLayout((Layout)new FillLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.text.getPlugin().createContainer(ret, this);
            this.text.getPlugin().showMenu(false);
            this.text.getPlugin().showToolbar(false);
            int add = 2;
            if (PatHeuteView.this.filterAction.isChecked()) {
                this.lfiltered = PatHeuteView.this.ldFilter.getAll().toArray(new IBillable[0]);
                this.numLeistung = new int[this.lfiltered.length];
                add += this.lfiltered.length;
                this.perLeistung = new Money[this.lfiltered.length];
                int i = 0;
                while (i < this.lfiltered.length) {
                    this.perLeistung[i] = new Money();
                    ++i;
                }
            }
            this.text.createFromTemplateName(null, "Abrechnungsliste", "Allg.", (Kontakt)CoreHub.getLoggedInContact(), Messages.PatHeuteView_billing);
            String[][] table = new String[PatHeuteView.this.kons.length + add][];
            table[0] = new String[2];
            table[0][0] = Messages.Core_Consultation;
            table[0][1] = Messages.Invoice_amount_billed;
            Money total = new Money();
            int i = 0;
            while (i < PatHeuteView.this.kons.length) {
                table[i + 1] = new String[2];
                Konsultation k = PatHeuteView.this.kons[i];
                table[i + 1][0] = k.getFall().getPatient().getLabel() + "\n" + k.getLabel();
                StringBuilder sb = new StringBuilder();
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                Money subsum = new Money();
                for (IBilled b : encounter.getBilled()) {
                    Money preis = b.getTotal();
                    if (this.lfiltered != null) {
                        int j = 0;
                        while (j < this.lfiltered.length) {
                            if (this.lfiltered[j].equals(b.getBillable())) {
                                int n = j;
                                this.numLeistung[n] = (int)((double)this.numLeistung[n] + b.getAmount());
                                this.perLeistung[j].addMoney(preis);
                            }
                            ++j;
                        }
                    }
                    subsum.addMoney(preis);
                    sb.append(b.getAmount()).append(" ").append(b.getLabel()).append(" ").append(preis.getAmountAsString()).append("\n");
                }
                sb.append(Messages.BillSummary_total).append(subsum.getAmountAsString());
                total.addMoney(subsum);
                table[i + 1][1] = sb.toString();
                ++i;
            }
            table[PatHeuteView.this.kons.length + 1] = new String[2];
            table[PatHeuteView.this.kons.length + 1][0] = Messages.PatHeuteView_sum;
            table[PatHeuteView.this.kons.length + 1][1] = total.getAmountAsString();
            if (this.lfiltered != null) {
                i = 0;
                while (i < this.lfiltered.length) {
                    table[PatHeuteView.this.kons.length + 2 + i] = new String[2];
                    table[PatHeuteView.this.kons.length + 2 + i][0] = this.lfiltered[i].getCode();
                    StringBuilder sb = new StringBuilder();
                    sb.append(Messages.Invoice_billed).append(this.numLeistung[i]).append(Messages.PatHeuteView_times).append(this.perLeistung[i].getAmountAsString());
                    table[PatHeuteView.this.kons.length + 2 + i][1] = sb.toString();
                    ++i;
                }
            }
            this.text.getPlugin().setFont("Helvetica", 0, 9.0f);
            this.text.getPlugin().insertTable("[Liste]", 1, table, new int[]{30, 70});
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.PatHeuteView_billingList);
            this.setTitle(Messages.PatHeuteView_printBillingList);
            this.setMessage(Messages.PatHeuteView_printBillingExpl);
            this.getShell().setSize(900, 700);
            SWTHelper.center(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
        }

        protected void okPressed() {
            super.okPressed();
        }

        @Override
        public void save() {
        }

        @Override
        public boolean saveAs() {
            return false;
        }
    }
}

