/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.model.OrderHistoryAction;
import ch.elexis.core.model.OrderHistoryEntry;
import ch.elexis.core.serial.Connection;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.constants.OrderConstants;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.OrderEntryComparators;
import ch.elexis.core.ui.util.OrderManagementActionFactory;
import ch.elexis.core.ui.util.OrderManagementHelper;
import ch.elexis.core.ui.util.OrderManagementUtil;
import ch.elexis.core.ui.util.TableSortController;
import ch.elexis.core.ui.util.dnd.OrderDropReceiver;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.CompletedOrderTableLabelProvider;
import ch.elexis.core.ui.views.provider.EntryTableLabelProvider;
import ch.elexis.core.ui.views.provider.GenericOrderEditingSupport;
import ch.elexis.core.ui.views.provider.OrderTableLabelProvider;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderManagementView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.OrderManagementView";
    private Composite topComposite;
    private Composite middleComposite;
    private Composite leftComposite;
    private Composite createdComposite;
    private Label cartIcon;
    private Label titleLabel;
    private Label createdLabel;
    private TableViewerColumn[] mainColumns;
    private Label statusLabel;
    private Label statusValue;
    public TableViewer tableViewer;
    private TableViewer orderTable;
    private Action checkInAction;
    private IOrder actOrder;
    private OrderManagementActionFactory actionFactory;
    public Button orderButton;
    private boolean showDeliveredColumn = false;
    private Composite dispatchedComposite;
    private Label dispatchedLabelTitle;
    private Label dispatchedLabelIcon;
    private Label dispatchedLabelState;
    private Composite bookedComposite;
    private Label bookedLabelTitle;
    private Label bookedLabelIcon;
    private Label bookedLabelState;
    private Label createdLabelState;
    private Composite completedContainer;
    private boolean isUIUpdating = false;
    private boolean mouseListenersRegistered = false;
    private final List<TableViewer> completedYearViewers = new ArrayList<TableViewer>();
    public Button selectAllChk;
    private TableViewer plainViewer;
    public CheckboxTableViewer checkboxViewer;
    private Composite tableArea;
    private StackLayout tableStack;
    private Composite mainComposite;
    private Composite headerBar;
    private TableSortController plainSorter;
    private TableSortController checkboxSorter;
    private Button addArticleButton;
    private Composite rightListComposite;
    private ScrolledComposite scrolledComposite;
    private ScrolledComposite rightScrollComposite;
    private boolean hasFocus = false;
    private boolean showAllYears = false;
    private static final Logger logger = LoggerFactory.getLogger(OrderManagementView.class);
    private static final String BARCODE_CONSUMER_KEY = "barcodeInputConsumer";
    public static final String BarcodeScanner_COMPORT = "barcode/Symbol/port";
    private static final GridData FILL_HORIZONTAL = new GridData(4, 0x1000000, true, false);
    private static final GridData FILL_BOTH = new GridData(4, 4, true, true);
    private static final GridData FIXED_WIDTH_50 = new GridData(50, -1);
    private static final GridData FIXED_WIDTH_75 = new GridData(75, -1);
    private Map<Integer, Boolean> expandedStates = new HashMap<Integer, Boolean>();
    private final Map<IOrderEntry, Integer> pendingDeliveredValues = new HashMap<IOrderEntry, Integer>();
    private static boolean barcodeScannerActivated = false;
    private boolean isDeliveryEditMode = false;
    private Image orderButtonCustomImage;
    private GenericObjectDropTarget plainDropTarget;
    private GenericObjectDropTarget checkboxDropTarget;
    public GenericObjectDropTarget dropTarget;
    private final Gson gson = new Gson();
    @Inject
    private IOrderService orderService;
    private RefreshingPartListener focusListener = new RefreshingPartListener(this){

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                OrderManagementView.this.hasFocus = true;
                String valueToSet = OrderManagementView.class.getName();
                ContextServiceHolder.get().getRootContext().setNamed(OrderManagementView.BARCODE_CONSUMER_KEY, (Object)valueToSet);
                CodeSelectorHandler.getInstance().setCodeSelectorTarget(OrderManagementView.this.dropTarget);
            }
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                OrderManagementView.this.hasFocus = false;
                ContextServiceHolder.get().getRootContext().setNamed(OrderManagementView.BARCODE_CONSUMER_KEY, null);
                OrderManagementUtil.deactivateBarcodeScanner();
            }
        }

        @Override
        public void partHidden(IWorkbenchPartReference partRef) {
            CodeSelectorHandler handler;
            if (this.isMatchingPart(partRef) && (handler = CodeSelectorHandler.getInstance()).getCodeSelectorTarget() == OrderManagementView.this.dropTarget) {
                handler.removeCodeSelectorTarget();
            }
        }

        @Override
        public void partClosed(IWorkbenchPartReference partRef) {
            CodeSelectorHandler handler;
            if (this.isMatchingPart(partRef) && (handler = CodeSelectorHandler.getInstance()).getCodeSelectorTarget() == OrderManagementView.this.dropTarget) {
                handler.removeCodeSelectorTarget();
            }
        }
    };
    private final Map<String, OrderHistorySummary> historyCache = new HashMap<String, OrderHistorySummary>();

    public Composite getCompletedContainer() {
        return this.completedContainer;
    }

    public void setCompletedContainer(Composite completedContainer) {
        this.completedContainer = completedContainer;
    }

    public boolean isDeliveryEditMode() {
        return this.isDeliveryEditMode;
    }

    public void setDeliveryEditMode(boolean enabled) {
        this.isDeliveryEditMode = enabled;
    }

    public static void setBarcodeScannerActivated(boolean enabled) {
        barcodeScannerActivated = enabled;
    }

    @Optional
    @Inject
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IStock.class.equals(clazz) || IOrder.class.equals(clazz) || IArticle.class.equals(clazz)) {
            if (this.actOrder != null) {
                this.refresh();
                this.loadOpenOrders();
            }
            if (this.orderTable != null) {
                this.loadOpenOrders();
            }
        }
    }

    @Inject
    @Optional
    public void barcodeEvent(@UIEventTopic(value="info/elexis/event/barcodeinput") Object event, IContextService contextService) {
        if (!this.hasFocus) {
            return;
        }
        if (event instanceof IArticle) {
            IArticle scannedArticle = (IArticle)event;
            if (OrderManagementView.class.getName().equals(contextService.getNamed(BARCODE_CONSUMER_KEY).orElse(null))) {
                if (this.actOrder == null) {
                    return;
                }
                boolean activateDeliveryMode = false;
                java.util.Optional<IOrderEntry> matchingEntry = this.actOrder.getEntries().stream().filter(entry -> entry.getArticle() != null && entry.getArticle().getCode().equals(scannedArticle.getCode())).findFirst();
                if (matchingEntry.isPresent()) {
                    IOrderEntry entry2 = matchingEntry.get();
                    if (entry2.getState() == OrderEntryState.OPEN) {
                        int oldAmount = entry2.getAmount();
                        int newAmount = oldAmount + 1;
                        this.updateOrderEntry(entry2, newAmount);
                    } else {
                        activateDeliveryMode = true;
                        int currentPending = this.pendingDeliveredValues.getOrDefault(entry2, 0);
                        int newPending = currentPending + 1;
                        int ordered = entry2.getAmount();
                        int delivered = entry2.getDelivered();
                        int sumDelivered = delivered + newPending;
                        if (sumDelivered > ordered) {
                            String articleName = entry2.getArticle() != null ? entry2.getArticle().getLabel() : "Unbekannter Artikel";
                            boolean confirm = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.OrderManagement_Overdelivery_Title, (String)MessageFormat.format(Messages.OrderManagement_Overdelivery_Message, delivered, newPending, sumDelivered, ordered, articleName));
                            if (!confirm) {
                                return;
                            }
                        }
                        this.pendingDeliveredValues.put(entry2, newPending);
                    }
                } else {
                    boolean isOrderOpen = this.actOrder.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.OPEN);
                    if (isOrderOpen) {
                        IStock stock = StockServiceHolder.get().getMandatorDefaultStock(((IMandator)ContextServiceHolder.get().getActiveMandator().get()).getId());
                        IOrderEntry newEntry = this.actOrder.addEntry(scannedArticle, stock, null, 1);
                        newEntry.setOrder(this.actOrder);
                        newEntry.setArticle(scannedArticle);
                        newEntry.setAmount(1);
                        newEntry.setState(OrderEntryState.OPEN);
                        this.actOrder.getEntries().add(newEntry);
                        CoreModelServiceHolder.get().save((Identifiable)newEntry);
                        this.orderService.getHistoryService().logEdit(this.actOrder, newEntry, 0, 1);
                    }
                }
                this.loadOrderDetails(this.actOrder);
                this.updateOrderDetails(this.actOrder);
                if (this.orderTable != null && !this.orderTable.getControl().isDisposed()) {
                    this.orderTable.refresh();
                }
                OrderManagementHelper.updateSelectAllCheckbox(this, this.pendingDeliveredValues);
                if (activateDeliveryMode) {
                    this.setDeliveryEditMode(true);
                    OrderManagementUtil.setCheckboxColumnVisible(this, true);
                }
            }
        }
    }

    @Optional
    @Inject
    void activeOrder(IOrder order) {
        if (order != null) {
            this.actOrder = order;
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.getSite().getPage().addPartListener((IPartListener2)this.focusListener);
        this.createHeaderUI(parent);
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTableUI((Composite)sashForm);
        this.createRightUI((Composite)sashForm);
        this.registerTableListeners(null);
        this.registerButtonListeners();
        this.registerMouseWheelListeners(null);
        this.loadOpenOrders();
        this.makeActions();
        this.loadCompletedOrders(this.completedContainer);
        this.actionFactory.createContextMenu(this.tableViewer, this.orderTable);
        this.updateUI();
        sashForm.setWeights(new int[]{2, 1});
    }

    public boolean isShowDeliveredColumn() {
        return this.showDeliveredColumn;
    }

    public void setShowDeliveredColumn(boolean showDeliveredColumn) {
        this.showDeliveredColumn = showDeliveredColumn;
    }

    public boolean isBarcodePortAvailable() {
        String port = LocalConfigService.get((String)BarcodeScanner_COMPORT, (String)"");
        if (StringUtils.isBlank((CharSequence)port)) {
            return false;
        }
        String[] available = Connection.getComPorts();
        return Arrays.asList(available).contains(port);
    }

    public void refreshTables() {
        this.loadOpenOrders();
        this.loadCompletedOrders(this.completedContainer);
        this.refresh();
    }

    public int determineEditableColumn(IOrderEntry entry) {
        if (entry.getState() == OrderEntryState.OPEN) {
            return 2;
        }
        if (entry.getState() == OrderEntryState.ORDERED || entry.getState() == OrderEntryState.PARTIAL_DELIVER) {
            return 3;
        }
        return -1;
    }

    public void updateOrderEntry(IOrderEntry entry, int newValue) {
        if (entry.getState() == OrderEntryState.OPEN) {
            int oldValue = entry.getAmount();
            entry.setAmount(newValue);
            this.orderService.getHistoryService().logEdit(this.actOrder, entry, oldValue, newValue);
        } else {
            OrderManagementUtil.saveSingleDelivery(entry, newValue, this.orderService);
        }
        CoreModelServiceHolder.get().save((Identifiable)entry);
        if (this.actOrder != null && this.actOrder.getId() != null) {
            this.historyCache.remove(this.actOrder.getId());
        }
        this.tableViewer.refresh((Object)entry);
    }

    private void createHeaderUI(Composite parent) {
        this.topComposite = new Composite(parent, 2048);
        this.topComposite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.topComposite.setLayout((Layout)new GridLayout(4, false));
        this.createImageComposite(this.topComposite);
        this.createLeftComposite(this.topComposite);
        this.createMiddleComposite(this.topComposite);
        this.createRightComposite(this.topComposite);
    }

    private void createImageComposite(Composite parent) {
        Composite imageComposite = new Composite(this.topComposite, 0);
        GridData imageCompositeData = new GridData(1, 4, false, true);
        imageComposite.setLayoutData((Object)imageCompositeData);
        imageComposite.setLayout((Layout)new GridLayout(1, false));
        this.cartIcon = new Label(imageComposite, 0);
        GridData cartIconData = new GridData(0x1000000, 0x1000000, true, true);
        this.cartIcon.setLayoutData((Object)cartIconData);
        this.cartIcon.setLayoutData((Object)new GridData(80, 70));
    }

    private void createLeftComposite(Composite parent) {
        this.leftComposite = new Composite(this.topComposite, 0);
        this.leftComposite.setLayoutData((Object)FILL_BOTH);
        GridLayout leftLayout = new GridLayout(1, false);
        leftLayout.marginHeight = 0;
        leftLayout.marginTop = 0;
        leftLayout.marginBottom = 0;
        leftLayout.verticalSpacing = -5;
        this.leftComposite.setLayout((Layout)leftLayout);
        Composite upperLeftComposite = new Composite(this.leftComposite, 0);
        upperLeftComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        upperLeftComposite.setLayout((Layout)new GridLayout(1, false));
        this.titleLabel = new Label(upperLeftComposite, 0);
        this.titleLabel.setLayoutData((Object)new GridData(180, 25));
        this.titleLabel.setText("");
        this.titleLabel.setFont(this.createBoldFont((Control)this.titleLabel));
        Composite lowerLeftComposite = new Composite(this.leftComposite, 0);
        lowerLeftComposite.setLayoutData((Object)FILL_BOTH);
        lowerLeftComposite.setLayout((Layout)new GridLayout(2, false));
        this.statusLabel = new Label(lowerLeftComposite, 0);
        this.statusLabel.setText(Messages.OrderManagement_StatusLabel);
        this.statusLabel.setLayoutData((Object)FIXED_WIDTH_50);
        this.statusValue = new Label(lowerLeftComposite, 0);
        this.statusValue.setText("");
        this.statusValue.setForeground(parent.getDisplay().getSystemColor(3));
        this.statusValue.setFont(this.createBoldFont((Control)this.statusValue));
        GridData statusValueData = new GridData(4, 0x1000000, true, false);
        this.statusValue.setLayoutData((Object)statusValueData);
    }

    private void createMiddleComposite(Composite parent) {
        this.middleComposite = new Composite(this.topComposite, 0);
        this.middleComposite.setLayoutData((Object)FILL_HORIZONTAL);
        GridLayout middleLayout = new GridLayout(1, false);
        middleLayout.marginHeight = 0;
        middleLayout.marginTop = 0;
        middleLayout.marginBottom = 0;
        middleLayout.verticalSpacing = -5;
        this.middleComposite.setLayout((Layout)middleLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.createdComposite = new Composite(this.middleComposite, 0);
        this.createdComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createdComposite.setLayout((Layout)new GridLayout(2, false));
        this.createdLabel = new Label(this.createdComposite, 0);
        this.createdLabel.setText(Messages.OrderManagement_CreatedLabel);
        this.createdLabel.setLayoutData((Object)FIXED_WIDTH_75);
        this.createdLabelState = new Label(this.createdComposite, 0);
        this.createdLabelState.setText("");
        this.createdLabelState.setLayoutData((Object)gridData);
        this.dispatchedComposite = new Composite(this.middleComposite, 0);
        this.dispatchedComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.dispatchedComposite.setLayout((Layout)new GridLayout(3, false));
        this.dispatchedLabelTitle = new Label(this.dispatchedComposite, 0);
        this.dispatchedLabelTitle.setText(Messages.OrderManagement_DispatchedLabel);
        this.dispatchedLabelTitle.setLayoutData((Object)FIXED_WIDTH_75);
        this.dispatchedLabelIcon = new Label(this.dispatchedComposite, 0);
        this.dispatchedLabelIcon.setLayoutData((Object)new GridData(20, 20));
        this.dispatchedLabelState = new Label(this.dispatchedComposite, 0);
        this.dispatchedLabelState.setText("");
        this.dispatchedLabelState.setLayoutData((Object)gridData);
        this.bookedComposite = new Composite(this.middleComposite, 0);
        this.bookedComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.bookedComposite.setLayout((Layout)new GridLayout(3, false));
        this.bookedLabelTitle = new Label(this.bookedComposite, 0);
        this.bookedLabelTitle.setText(Messages.OrderManagement_BookedLabel);
        this.bookedLabelTitle.setLayoutData((Object)FIXED_WIDTH_75);
        this.bookedLabelIcon = new Label(this.bookedComposite, 0);
        this.bookedLabelIcon.setLayoutData((Object)new GridData(20, 20));
        this.bookedLabelState = new Label(this.bookedComposite, 0);
        this.bookedLabelState.setText("");
        this.bookedLabelState.setLayoutData((Object)gridData);
    }

    private void createRightComposite(Composite parent) {
        Composite rightComposite = new Composite(this.topComposite, 0);
        rightComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        rightComposite.setLayout((Layout)new GridLayout());
        this.orderButton = new Button(rightComposite, 8);
        this.orderButton.setText(Messages.OrderManagement_Button_Order);
        this.orderButton.setLayoutData((Object)new GridData(140, 64));
        this.orderButton.setEnabled(false);
    }

    private void createTableUI(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.headerBar = new Composite(this.mainComposite, 0);
        GridData headerGD = new GridData(4, 128, true, false);
        headerGD.heightHint = 30;
        headerGD.verticalIndent = 2;
        this.headerBar.setLayoutData((Object)headerGD);
        this.headerBar.setLayout((Layout)new FormLayout());
        this.selectAllChk = new Button(this.headerBar, 32);
        this.selectAllChk.setText(Messages.OrderManagement_FullyDelivered);
        this.selectAllChk.addListener(13, e -> OrderManagementHelper.applySelectAll(this, this.selectAllChk.getSelection(), this.pendingDeliveredValues));
        FormData fdChk = new FormData();
        fdChk.left = new FormAttachment(0, 5);
        int chkHeight = this.selectAllChk.computeSize((int)-1, (int)-1).y;
        fdChk.top = new FormAttachment(50, -chkHeight / 2);
        this.selectAllChk.setLayoutData((Object)fdChk);
        this.addArticleButton = new Button(this.headerBar, 0);
        Image plusImg = Images.IMG_NEW.getImage();
        this.addArticleButton.setImage(plusImg);
        this.addArticleButton.setToolTipText(Messages.OrderManagement_AddItem);
        FormData fdPlus = new FormData();
        fdPlus.right = new FormAttachment(100, -5);
        fdPlus.top = new FormAttachment(30, -plusImg.getBounds().height / 2);
        this.addArticleButton.setLayoutData((Object)fdPlus);
        this.addArticleButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && OrderManagementView.this.actionFactory != null && OrderManagementView.this.actOrder != null) {
                    OrderManagementView.this.actionFactory.handleAddItem();
                }
            }
        });
        this.addArticleButton.setVisible(false);
        this.tableArea = new Composite(this.mainComposite, 0);
        this.tableArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableStack = new StackLayout();
        this.tableArea.setLayout((Layout)this.tableStack);
        this.createPlainTable();
        this.createCheckboxTable();
        this.tableViewer = this.plainViewer;
        this.tableStack.topControl = this.plainViewer.getControl();
        this.tableArea.layout(true, true);
    }

    private void createPlainTable() {
        int style = 98306;
        this.plainViewer = new TableViewer(this.tableArea, style);
        this.plainViewer.setUseHashlookup(true);
        Table tableControl = this.plainViewer.getTable();
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        String[] columnHeaders = new String[]{"", Messages.OrderManagement_Column_Status, Messages.OrderManagement_Column_Ordered, Messages.OrderManagement_Column_Delivered, Messages.Core_Add, Messages.OrderManagement_Column_Article, Messages.OrderManagement_Column_Supplier, Messages.OrderManagement_Column_Stock};
        int[] nArray = new int[8];
        nArray[2] = 50;
        nArray[3] = 60;
        nArray[5] = 190;
        nArray[6] = 160;
        nArray[7] = 50;
        int[] columnWidths = nArray;
        this.createTableColumns(this.plainViewer, columnHeaders, columnWidths, this.showDeliveredColumn);
        OrderManagementUtil.enableLastColumnFill(tableControl);
        this.plainSorter = new TableSortController(this.plainViewer);
        this.plainSorter.setDefaultSort(5, 128);
        TableColumn addCol = this.plainViewer.getTable().getColumn(4);
        addCol.setResizable(false);
        addCol.setMoveable(false);
        addCol.setWidth(0);
        this.addEditingSupportForSupplierColumn(this.plainViewer);
        this.addEditingSupportForDeliveredColumn(this.plainViewer);
        this.addEditingSupportForOrderColumn(this.plainViewer);
        this.plainDropTarget = new GenericObjectDropTarget("ArtikelDropTarget", this.plainViewer.getControl(), new OrderDropReceiver(this, this.orderService), false);
        this.plainDropTarget.registered(false);
        this.dropTarget = this.plainDropTarget;
        CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.dropTarget);
    }

    private void createCheckboxTable() {
        int style = 65570;
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)this.tableArea, (int)style);
        this.checkboxViewer.setUseHashlookup(true);
        Table tableControl = this.checkboxViewer.getTable();
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        tableControl.setHeaderVisible(true);
        tableControl.setLinesVisible(true);
        String[] columnHeaders = new String[]{"", Messages.OrderManagement_Column_Status, Messages.OrderManagement_Column_Ordered, Messages.OrderManagement_Column_Delivered, Messages.Core_Add, Messages.OrderManagement_Column_Article, Messages.OrderManagement_Column_Supplier, Messages.OrderManagement_Column_Stock};
        int[] nArray = new int[8];
        nArray[0] = 30;
        nArray[1] = 50;
        nArray[2] = 50;
        nArray[3] = 60;
        nArray[5] = 190;
        nArray[6] = 160;
        nArray[7] = 50;
        int[] columnWidths = nArray;
        this.createTableColumns((TableViewer)this.checkboxViewer, columnHeaders, columnWidths, this.showDeliveredColumn);
        OrderManagementUtil.enableLastColumnFill(tableControl);
        this.checkboxSorter = new TableSortController((TableViewer)this.checkboxViewer);
        this.checkboxSorter.setDefaultSort(5, 128);
        TableColumn addCol = this.checkboxViewer.getTable().getColumn(4);
        addCol.setResizable(false);
        addCol.setMoveable(false);
        addCol.setWidth(0);
        this.addEditingSupportForSupplierColumn((TableViewer)this.checkboxViewer);
        this.addEditingSupportForDeliveredColumn((TableViewer)this.checkboxViewer);
        this.addEditingSupportForOrderColumn((TableViewer)this.checkboxViewer);
        this.checkboxDropTarget = new GenericObjectDropTarget("ArtikelDropTarget", this.checkboxViewer.getControl(), new OrderDropReceiver(this, this.orderService), false);
        this.checkboxDropTarget.registered(false);
        this.checkboxViewer.addCheckStateListener(e -> {
            IOrderEntry entry = (IOrderEntry)e.getElement();
            if (!this.isDeliveryEditMode) {
                boolean shouldBeChecked;
                boolean bl = shouldBeChecked = this.pendingDeliveredValues.getOrDefault(entry, 0) > 0;
                if (this.checkboxViewer.getChecked((Object)entry) != shouldBeChecked) {
                    this.checkboxViewer.setChecked((Object)entry, shouldBeChecked);
                }
                return;
            }
            if (!this.isEligibleForBooking(entry)) {
                this.checkboxViewer.setChecked((Object)entry, false);
                return;
            }
            if (e.getChecked()) {
                int rest = Math.max(0, entry.getAmount() - entry.getDelivered());
                if (rest > 0) {
                    this.pendingDeliveredValues.put(entry, rest);
                }
            } else {
                this.pendingDeliveredValues.remove(entry);
            }
            this.checkboxViewer.update((Object)entry, null);
            if (!Messages.MedicationComposite_btnConfirm.equals(this.orderButton.getText())) {
                this.updateOrderStatus(this.actOrder);
            }
            OrderManagementHelper.updateSelectAllCheckbox(this, this.pendingDeliveredValues);
        });
        this.checkboxViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                IOrderEntry e = (IOrderEntry)element;
                return OrderManagementView.this.pendingDeliveredValues.getOrDefault(e, 0) > 0;
            }

            public boolean isGrayed(Object element) {
                IOrderEntry e = (IOrderEntry)element;
                return !OrderManagementView.this.isEligibleForBooking(e);
            }
        });
        OrderManagementUtil.setCheckboxColumnVisible(this, false);
    }

    private void createRightUI(Composite parent) {
        this.rightScrollComposite = new ScrolledComposite(parent, 768);
        this.rightScrollComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.rightScrollComposite.setExpandHorizontal(true);
        this.rightScrollComposite.setExpandVertical(true);
        this.rightListComposite = new Composite((Composite)this.rightScrollComposite, 0);
        this.rightListComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rightListComposite.setLayout((Layout)new GridLayout(1, false));
        this.rightScrollComposite.setContent((Control)this.rightListComposite);
        Label rightTitle = new Label(this.rightListComposite, 0);
        rightTitle.setText(Messages.OrderManagement_RightTitle);
        this.orderTable = new TableViewer(this.rightListComposite, 100864);
        this.orderTable.setUseHashlookup(true);
        Table orderTableControl = this.orderTable.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 200;
        orderTableControl.setLayoutData((Object)gridData);
        orderTableControl.setHeaderVisible(true);
        orderTableControl.setLinesVisible(true);
        orderTableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
        orderTableControl.setBackground(Display.getDefault().getSystemColor(22));
        String[] columnOrderHeaders = new String[]{"", Messages.Core_Date, Messages.Core_Title};
        int[] columnOrderWidths = new int[]{40, 90, 210};
        this.createTableColumns(this.orderTable, columnOrderHeaders, columnOrderWidths, this.showDeliveredColumn);
        this.orderTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.orderTable.setLabelProvider((IBaseLabelProvider)new OrderTableLabelProvider());
        Label completedTitle = new Label(this.rightListComposite, 0);
        completedTitle.setText(Messages.OrderManagement_CompletedTitle);
        this.scrolledComposite = new ScrolledComposite(this.rightListComposite, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite scrollContent = new Composite((Composite)this.scrolledComposite, 0);
        scrollContent.setLayout((Layout)new GridLayout(1, false));
        this.scrolledComposite.setContent((Control)scrollContent);
        this.completedContainer = scrollContent;
        this.completedContainer.setLayout((Layout)new GridLayout(1, false));
        this.completedContainer.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private Font createBoldFont(Control control) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = control.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(1);
            ++n2;
        }
        Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.addDisposeListener(e -> newFont.dispose());
        return newFont;
    }

    private void createTableColumns(TableViewer viewer, String[] titles, int[] widths, boolean showDelivered) {
        this.mainColumns = new TableViewerColumn[titles.length];
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn col;
            this.mainColumns[i] = col = new TableViewerColumn(viewer, 0);
            TableColumn column = col.getColumn();
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            column.setResizable(true);
            column.setMoveable(true);
            if (i == 1) {
                col.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

                    protected void measure(Event event, Object element) {
                        event.height = 25;
                    }

                    protected void paint(Event event, Object element) {
                        IOrderEntry entry;
                        Image img;
                        if (element instanceof IOrderEntry && (img = OrderManagementUtil.getEntryStatusIcon(entry = (IOrderEntry)element)) != null && !img.isDisposed()) {
                            int imgWidth = img.getBounds().width;
                            int imgHeight = img.getBounds().height;
                            int cellWidth = event.width;
                            int style = event.widget.getStyle();
                            int offset = (style & 0x20) != 0 ? 20 : 0;
                            int x = event.x + offset + (cellWidth - imgWidth) / 2;
                            int y = event.y + (event.height - imgHeight) / 2;
                            event.gc.drawImage(img, x, y);
                        }
                    }
                });
            } else {
                col.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(i, showDelivered, this));
            }
            ++i;
        }
    }

    @Override
    public void refresh() {
        if (this.actOrder != null) {
            this.loadOrderDetails(this.actOrder);
            this.updateOrderDetails(this.actOrder);
        }
        this.updateCheckIn();
        this.updateUI();
    }

    public void reload() {
        this.loadOpenOrders();
        if (this.actOrder != null) {
            this.refresh();
        }
        if (this.completedContainer != null) {
            this.loadCompletedOrders();
            this.refresh();
        }
    }

    public void clearOrderDetailsView() {
        if (this.tableViewer != null && this.tableViewer.getContentProvider() != null && this.tableViewer.getControl() != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.setInput(Collections.emptyList());
            this.tableViewer.refresh();
        }
        this.titleLabel.setText("");
        this.createdLabelState.setText("");
        this.statusValue.setText("");
        this.cartIcon.setImage(null);
        this.dispatchedLabelIcon.setImage(null);
        this.dispatchedLabelState.setText("");
        this.bookedLabelIcon.setImage(null);
        this.bookedLabelState.setText("");
        this.orderButton.setImage(null);
        this.orderButton.setText("");
        this.orderButton.setEnabled(false);
    }

    public void selectOrderInHistory(IOrder order) {
        List openOrders;
        if (order == null) {
            return;
        }
        String id = order.getId();
        if (this.orderTable != null && !this.orderTable.getTable().isDisposed() && (openOrders = (List)this.orderTable.getInput()) != null) {
            for (IOrder o : openOrders) {
                if (!id.equals(o.getId())) continue;
                this.orderTable.setSelection((ISelection)new StructuredSelection((Object)o), true);
                this.orderTable.reveal((Object)o);
                this.clearOtherSelections(this.orderTable);
                return;
            }
        }
        for (TableViewer tv : this.completedYearViewers) {
            List yearOrders;
            if (tv == null || tv.getTable().isDisposed() || (yearOrders = (List)tv.getInput()) == null) continue;
            for (IOrder o : yearOrders) {
                if (!id.equals(o.getId())) continue;
                tv.setSelection((ISelection)new StructuredSelection((Object)o), true);
                tv.reveal((Object)o);
                this.clearOtherSelections(tv);
                return;
            }
        }
    }

    public void setFocus() {
        Composite controlToFocus;
        Object object = controlToFocus = this.tableViewer != null ? this.tableViewer.getControl() : this.topComposite;
        if (controlToFocus != null && !controlToFocus.isDisposed()) {
            controlToFocus.setFocus();
        }
    }

    public void updateCheckIn() {
        if (this.checkInAction == null) {
            return;
        }
        if (this.actOrder == null) {
            this.checkInAction.setEnabled(false);
            this.selectAllChk.setVisible(false);
            this.checkInAction.setToolTipText(Messages.OrderManagement_CheckIn_NoOrder);
        } else if (this.actOrder.isDone()) {
            this.checkInAction.setEnabled(false);
            this.selectAllChk.setVisible(false);
            this.checkInAction.setToolTipText(Messages.OrderManagement_CheckIn_Done);
        } else {
            this.checkInAction.setEnabled(true);
            this.selectAllChk.setVisible(true);
            this.checkInAction.setToolTipText(Messages.OrderManagement_CheckIn_Confirm);
        }
    }

    private void registerTableListeners(List<TableViewer> tableViewers) {
        if (this.orderTable != null && !this.orderTable.getTable().isDisposed()) {
            this.orderTable.addSelectionChangedListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IOrder selectedOrder = (IOrder)selection.getFirstElement();
                if (selectedOrder != null) {
                    this.resetEditMode();
                    this.setActOrder(selectedOrder);
                    this.refresh();
                    this.clearOtherSelections(this.orderTable);
                }
            });
        }
        if (tableViewers != null) {
            for (TableViewer yearTableViewer : tableViewers) {
                yearTableViewer.addSelectionChangedListener(event -> {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IOrder selectedOrder = (IOrder)selection.getFirstElement();
                    if (selectedOrder != null) {
                        this.actionFactory.handleCompletedOrderSelection(selectedOrder);
                    }
                });
            }
        }
    }

    private void registerButtonListeners() {
        this.orderButton.addListener(13, event -> this.handleOrderButtonClick());
    }

    public void handleOrderButtonClick() {
        OrderManagementUtil.handleOrderButtonClick(this, this.orderService, this.pendingDeliveredValues, this.actOrder);
    }

    private void registerMouseWheelListeners(Table tblYear) {
        if (!this.mouseListenersRegistered) {
            this.completedContainer.addListener(37, e -> this.actionFactory.handleMouseWheelScroll(e, this.rightScrollComposite));
            this.scrolledComposite.addListener(37, e -> this.actionFactory.handleMouseWheelScroll(e, this.scrolledComposite));
            if (this.orderTable != null) {
                this.orderTable.getTable().addListener(37, e -> this.actionFactory.handleMouseWheelScroll(e, this.rightScrollComposite));
            }
            this.mouseListenersRegistered = true;
        }
        if (tblYear != null) {
            tblYear.addListener(37, e -> this.actionFactory.handleMouseWheelScroll(e, this.rightScrollComposite));
        }
    }

    public void loadOpenOrders() {
        List<IOrder> orders = OrderManagementUtil.getOpenOrders();
        this.orderTable.setInput(orders);
        if (this.actOrder != null && orders.contains(this.actOrder)) {
            this.orderTable.setSelection((ISelection)new StructuredSelection((Object)this.actOrder), true);
            this.orderTable.reveal((Object)this.actOrder);
            this.clearOtherSelections(this.orderTable);
        }
        this.registerMouseWheelListeners(null);
    }

    private void loadCompletedOrders() {
        this.loadCompletedOrders(this.completedContainer);
    }

    public void loadCompletedOrders(final Composite completedContainer) {
        Control child;
        this.completedYearViewers.clear();
        Control[] controlArray = completedContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandableComposite oldSection;
            Object yearObj;
            child = controlArray[n2];
            if (child instanceof ExpandableComposite && (yearObj = (oldSection = (ExpandableComposite)child).getData("year")) instanceof Integer) {
                Integer oldYear = (Integer)yearObj;
                this.expandedStates.put(oldYear, oldSection.isExpanded());
            }
            ++n2;
        }
        controlArray = completedContainer.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        List<IOrder> orders = OrderManagementUtil.getCompletedOrders(this.showAllYears);
        if (orders.isEmpty()) {
            return;
        }
        Map<Integer, List<IOrder>> ordersByYear = orders.stream().collect(Collectors.groupingBy(o -> o.getTimestamp().getYear()));
        List<Integer> sortedYears = new ArrayList<Integer>(ordersByYear.keySet());
        sortedYears.sort(Collections.reverseOrder());
        if (!this.showAllYears && sortedYears.size() > 2) {
            sortedYears = sortedYears.subList(0, 2);
        }
        for (final Integer year : sortedYears) {
            final ExpandableComposite completedSection = new ExpandableComposite(completedContainer, 0, 44);
            completedSection.setLayoutData((Object)new GridData(4, 128, true, false));
            completedSection.setFont(this.createBoldFont((Control)this.titleLabel));
            completedSection.setText(Messages.OrderManagement_YearSection + String.valueOf(year));
            completedSection.setData("year", (Object)year);
            completedSection.setExpanded(false);
            Composite client = new Composite((Composite)completedSection, 0);
            client.setLayout((Layout)new GridLayout(1, false));
            TableViewer completedTableViewer = new TableViewer(client, 67584);
            completedTableViewer.setUseHashlookup(true);
            Table tableControl = completedTableViewer.getTable();
            tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
            tableControl.setHeaderVisible(true);
            tableControl.setLinesVisible(true);
            tableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
            tableControl.setBackground(Display.getDefault().getSystemColor(22));
            this.createTableColumns(completedTableViewer, new String[]{Messages.Core_Date, Messages.Core_Title}, new int[]{90, 210}, this.showDeliveredColumn);
            completedTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            completedTableViewer.setLabelProvider((IBaseLabelProvider)new CompletedOrderTableLabelProvider());
            completedTableViewer.setInput(ordersByYear.get(year));
            completedTableViewer.addSelectionChangedListener(event -> {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IOrder selectedOrder = (IOrder)selection.getFirstElement();
                if (selectedOrder != null) {
                    this.resetEditMode();
                    this.setActOrder(selectedOrder);
                    this.refresh();
                    this.clearOtherSelections(completedTableViewer);
                }
            });
            completedSection.setClient((Control)client);
            Boolean wasExpanded = this.expandedStates.get(year);
            if (wasExpanded != null) {
                completedSection.setExpanded(wasExpanded.booleanValue());
            }
            completedSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    OrderManagementView.this.expandedStates.put(year, completedSection.isExpanded());
                    completedContainer.layout(true, true);
                    OrderManagementView.this.updateUI();
                }
            });
            this.registerMouseWheelListeners(tableControl);
            this.actionFactory.createOrderHistoryMenu(completedTableViewer);
            this.completedYearViewers.add(completedTableViewer);
        }
        if (ordersByYear.size() > 2) {
            Button toggleButton = new Button(completedContainer, 8);
            toggleButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            toggleButton.setText(this.showAllYears ? Messages.OrderManagement_Toggle_Less : Messages.OrderManagement_Toggle_More);
            toggleButton.addListener(13, e -> {
                this.showAllYears = !this.showAllYears;
                this.loadCompletedOrders(completedContainer);
                completedContainer.layout(true, true);
                this.scrolledComposite.setMinSize(completedContainer.computeSize(-1, -1));
            });
        }
    }

    private void loadOrderDetails(IOrder order) {
        if (order == null) {
            this.actOrder = null;
            if (this.tableViewer != null) {
                this.tableViewer.setInput(Collections.emptyList());
            }
            return;
        }
        boolean allOpen = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.OPEN);
        this.showDeliveredColumn = !allOpen;
        this.actOrder = order;
        this.switchViewerFor(order);
        Table table = this.tableViewer.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        table.setRedraw(false);
        try {
            boolean hasEntries = !order.getEntries().isEmpty();
            boolean anyOrdered = order.getEntries().stream().anyMatch(e -> e.getState() != OrderEntryState.OPEN);
            this.updateAddArticleButtonVisibility(hasEntries, anyOrdered);
            List alleEintraege = order.getEntries();
            int sortColumn = 5;
            int sortDirection = 128;
            if (table.getSortColumn() != null) {
                TableSortController controller = this.tableViewer == this.plainViewer ? this.plainSorter : this.checkboxSorter;
                sortColumn = controller.getCurrentColumn();
                sortDirection = controller.getCurrentDirection();
            }
            ArrayList<IOrderEntry> initial = new ArrayList<IOrderEntry>(alleEintraege.size());
            initial.addAll(alleEintraege);
            initial.sort(OrderEntryComparators.forColumn(sortColumn, sortDirection));
            if (this.tableViewer.getContentProvider() == null) {
                this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            }
            this.tableViewer.setInput(initial);
            if (sortColumn >= 0 && sortColumn < table.getColumnCount()) {
                table.setSortColumn(table.getColumn(sortColumn));
            }
            OrderManagementHelper.updateSelectAllCheckbox(this, this.pendingDeliveredValues);
            this.updateTableBackground(order);
            this.pendingDeliveredValues.keySet().removeIf(e -> !this.isEligibleForBooking((IOrderEntry)e));
        }
        finally {
            table.setRedraw(true);
        }
    }

    private boolean isEligibleForBooking(IOrderEntry e) {
        return e.getState() != OrderEntryState.OPEN && e.getDelivered() < e.getAmount();
    }

    public void updateTableBackground(IOrder order) {
        boolean isBestellt;
        if (this.tableViewer == null || this.tableViewer.getTable().isDisposed()) {
            return;
        }
        Table tableControl = this.tableViewer.getTable();
        boolean bl = isBestellt = order != null && order.getEntries().stream().anyMatch(e -> e.getState() != OrderEntryState.OPEN);
        if (isBestellt) {
            tableControl.setHeaderBackground(Display.getDefault().getSystemColor(22));
            tableControl.setBackground(Display.getDefault().getSystemColor(22));
        } else {
            tableControl.setHeaderBackground(Display.getDefault().getSystemColor(1));
            tableControl.setBackground(Display.getDefault().getSystemColor(1));
        }
    }

    private void addEditingSupportForSupplierColumn(TableViewer v) {
        TableColumn col = v.getTable().getColumn(6);
        TableViewerColumn tvc = new TableViewerColumn(v, col);
        tvc.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(6, this.showDeliveredColumn, this));
        tvc.setEditingSupport((EditingSupport)new GenericOrderEditingSupport(this, v, GenericOrderEditingSupport.EditingColumnType.SUPPLIER, this.actOrder, 6, this.orderService));
    }

    private void addEditingSupportForDeliveredColumn(TableViewer v) {
        TableColumn col = v.getTable().getColumn(3);
        TableViewerColumn tvc = new TableViewerColumn(v, col);
        tvc.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(3, this.showDeliveredColumn, this));
        tvc.setEditingSupport((EditingSupport)new GenericOrderEditingSupport(this, v, GenericOrderEditingSupport.EditingColumnType.DELIVERED, this.actOrder, 3, this.orderService));
    }

    private void addEditingSupportForOrderColumn(TableViewer v) {
        TableColumn col = v.getTable().getColumn(2);
        TableViewerColumn tvc = new TableViewerColumn(v, col);
        tvc.setLabelProvider((CellLabelProvider)new EntryTableLabelProvider(2, this.showDeliveredColumn, this));
        tvc.setEditingSupport((EditingSupport)new GenericOrderEditingSupport(this, v, GenericOrderEditingSupport.EditingColumnType.ORDERED, this.actOrder, 2, this.orderService));
    }

    private void switchViewerFor(IOrder order) {
        CheckboxTableViewer targetViewer;
        boolean anyOrdered = order != null && order.getEntries().stream().anyMatch(e -> e.getState() != OrderEntryState.OPEN);
        Object object = targetViewer = anyOrdered ? this.checkboxViewer : this.plainViewer;
        if (this.tableViewer == targetViewer && this.tableStack.topControl == targetViewer.getControl()) {
            return;
        }
        this.tableViewer = targetViewer;
        this.tableStack.topControl = targetViewer.getControl();
        if (anyOrdered && this.checkboxDropTarget != null) {
            this.dropTarget = this.checkboxDropTarget;
            CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.dropTarget);
        } else if (!anyOrdered && this.plainDropTarget != null) {
            this.dropTarget = this.plainDropTarget;
            CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.dropTarget);
        }
        this.tableArea.layout(true, true);
        if (this.headerBar != null && !this.headerBar.isDisposed()) {
            this.headerBar.layout(true, true);
        }
        if (this.mainComposite != null && !this.mainComposite.isDisposed()) {
            this.mainComposite.layout(true, true);
        }
    }

    public void updateOrderDetails(IOrder order) {
        if (order == null) {
            return;
        }
        String createdStr = OrderManagementUtil.formatDate(order.getTimestamp());
        IOutputLog usierID = OrderManagementUtil.getOrderLogEntry(order);
        Image statusImage = OrderManagementUtil.getStatusIcon(order, false);
        this.cartIcon.setImage(statusImage);
        this.titleLabel.setText(order.getName());
        String creatorId = usierID != null && usierID.getCreatorId() != null ? usierID.getCreatorId() : Messages.UNKNOWN;
        this.createdLabelState.setText(createdStr + ", (" + creatorId + ")");
        this.statusValue.setText(OrderManagementUtil.getStatusText(order));
        this.updateOrderStatus(order);
        this.actionFactory.setOrder(this.actOrder);
        this.updateUI();
    }

    private OrderHistorySummary getHistorySummary(IOrder order) {
        OrderHistoryEntry[] historyEntries;
        if (order == null || order.getId() == null) {
            return new OrderHistorySummary(null, null, null, null);
        }
        String id = order.getId();
        OrderHistorySummary cached = this.historyCache.get(id);
        if (cached != null) {
            return cached;
        }
        IOutputLog logEntry = OrderManagementUtil.getOrderLogEntry(order);
        String jsonLog = logEntry != null ? logEntry.getOutputterStatus() : "[]";
        try {
            historyEntries = (OrderHistoryEntry[])this.gson.fromJson(jsonLog, OrderHistoryEntry[].class);
        }
        catch (Exception e) {
            historyEntries = new OrderHistoryEntry[]{};
        }
        if (historyEntries == null) {
            historyEntries = new OrderHistoryEntry[]{};
        }
        String orderedUser = null;
        String orderedDate = null;
        String completedUser = null;
        String completedDate = null;
        DateTimeFormatter dateOnlyFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        int i = historyEntries.length - 1;
        while (i >= 0) {
            OrderHistoryEntry entry = historyEntries[i];
            if (entry.getAction() == OrderHistoryAction.ORDERED && orderedUser == null) {
                orderedUser = StringUtils.isNotBlank((CharSequence)entry.getUserId()) ? entry.getUserId() : Messages.UNKNOWN;
                orderedDate = this.parseDate(entry.getTimestamp(), dateOnlyFormat);
            }
            if (entry.getAction() == OrderHistoryAction.COMPLETEDELIVERY && completedUser == null) {
                completedUser = StringUtils.isNotBlank((CharSequence)entry.getUserId()) ? entry.getUserId() : Messages.UNKNOWN;
                completedDate = this.parseDate(entry.getTimestamp(), dateOnlyFormat);
            }
            --i;
        }
        OrderHistorySummary summary = new OrderHistorySummary(orderedUser, orderedDate, completedUser, completedDate);
        this.historyCache.put(id, summary);
        return summary;
    }

    public void updateOrderStatus(IOrder order) {
        if (order == null) {
            return;
        }
        Table table = this.tableViewer.getTable();
        OrderHistorySummary history = this.getHistorySummary(order);
        String orderedUser = history.orderedUser;
        String orderedDate = history.orderedDate;
        String completedUser = history.completedUser;
        String completedDate = history.completedDate;
        boolean hasEntries = !order.getEntries().isEmpty();
        boolean allDone = hasEntries && order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE);
        boolean anyOrdered = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.ORDERED || e.getState() == OrderEntryState.PARTIAL_DELIVER);
        boolean allEntriesHaveSupplier = order.getEntries().stream().allMatch(e -> e.getProvider() != null);
        boolean hasOpenEntries = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.OPEN);
        this.dispatchedLabelIcon.setImage(allDone || anyOrdered ? OrderConstants.OrderImages.TICK : OrderConstants.OrderImages.CLEAR);
        this.dispatchedLabelState.setText((String)(allDone || anyOrdered ? this.defaultString(orderedDate) + ", (" + this.defaultString(orderedUser) + ")" : Messages.Corr_No));
        this.bookedLabelIcon.setImage(allDone ? OrderConstants.OrderImages.TICK : OrderConstants.OrderImages.CLEAR);
        this.bookedLabelState.setText((String)(allDone ? this.defaultString(completedDate) + ", (" + this.defaultString(completedUser) + ")" : Messages.Corr_No));
        if (this.orderButtonCustomImage != null && !this.orderButtonCustomImage.isDisposed()) {
            this.orderButtonCustomImage.dispose();
            this.orderButtonCustomImage = null;
        }
        if (order.getEntries().isEmpty()) {
            this.orderButton.setText("");
            this.orderButton.setImage(OrderConstants.OrderImages.TICK);
            this.orderButton.setEnabled(false);
        } else {
            this.orderButton.setEnabled(true);
            if (!hasOpenEntries && anyOrdered) {
                this.orderButton.setText(Messages.OrderManagement_Button_Book);
                this.orderButton.setImage(OrderConstants.OrderImages.IMPORT);
                OrderManagementUtil.adjustLastColumnWidth(table);
            } else if (allDone) {
                this.orderButton.setText(Messages.OmnivoreView_editActionCaption);
                this.orderButton.setImage(OrderConstants.OrderImages.EDIT);
            } else if (allEntriesHaveSupplier) {
                this.orderButton.setText(Messages.OrderManagement_Button_Order);
                this.orderButton.setImage(OrderConstants.OrderImages.DELIVERY_TRUCK_64x64);
            } else {
                this.orderButton.setText(Messages.OrderManagement_Button_MissingSupplier);
                this.orderButton.setImage(OrderConstants.OrderImages.WARNING);
            }
        }
        this.updateCheckIn();
        if (!this.pendingDeliveredValues.isEmpty()) {
            this.orderButton.setText(Messages.MedicationComposite_btnConfirm);
            this.orderButton.setImage(Images.IMG_TICK.getImage());
        }
    }

    private String parseDate(String isoDateString, DateTimeFormatter formatter) {
        try {
            LocalDateTime dateTime = LocalDateTime.parse(isoDateString);
            return dateTime.format(formatter);
        }
        catch (Exception e) {
            return Messages.UNKNOWN;
        }
    }

    private String defaultString(String str) {
        return StringUtils.isNotBlank((CharSequence)str) ? str : Messages.UNKNOWN;
    }

    private void updateAddArticleButtonVisibility(boolean hasEntries, boolean anyOrdered) {
        if (this.addArticleButton == null || this.addArticleButton.isDisposed()) {
            return;
        }
        boolean show = !anyOrdered;
        this.addArticleButton.setVisible(show);
        if (this.headerBar != null && !this.headerBar.isDisposed()) {
            this.headerBar.layout();
        }
    }

    public void updateUI() {
        if (this.isUIUpdating) {
            return;
        }
        this.isUIUpdating = true;
        Display.getDefault().asyncExec(() -> {
            try {
                this.topComposite.layout(true, true);
                this.rightListComposite.layout(true, true);
                this.scrolledComposite.setMinSize(this.completedContainer.computeSize(-1, -1));
                this.rightScrollComposite.setMinSize(this.rightListComposite.computeSize(-1, -1));
            }
            finally {
                this.isUIUpdating = false;
            }
        });
    }

    public IOrder getOrder() {
        return this.actOrder;
    }

    public void setActOrder(IOrder selectedOrder) {
        this.actOrder = selectedOrder;
        Display.getDefault().asyncExec(() -> {
            boolean isOpenOrder;
            this.restBarCode();
            if (this.tableViewer == null || this.tableViewer.getControl().isDisposed()) {
                return;
            }
            boolean isDelivered = this.actOrder != null && OrderManagementUtil.isOrderCompletelyDelivered(this.actOrder);
            boolean bl = isOpenOrder = this.actOrder != null && !isDelivered;
            if (isOpenOrder) {
                this.setFocus();
                if (!barcodeScannerActivated) {
                    OrderManagementUtil.activateBarcodeScannerAndFocus();
                }
            } else if (barcodeScannerActivated) {
                OrderManagementUtil.deactivateBarcodeScanner();
            }
        });
    }

    public void resetEditMode() {
        this.setDeliveryEditMode(false);
        OrderManagementUtil.setCheckboxColumnVisible(this, false);
        this.pendingDeliveredValues.clear();
        OrderManagementHelper.updateSelectAllCheckbox(this, this.pendingDeliveredValues);
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    public void restBarCode() {
        String COMMAND_ID = "ch.elexis.base.barcode.scanner.ListenerProcess";
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command scannerCommand = commandService.getCommand(COMMAND_ID);
            if (scannerCommand == null) {
                return;
            }
            State state = scannerCommand.getState("org.eclipse.jface.commands.ToggleState");
            if (state == null) {
                state = scannerCommand.getState("STYLE");
            }
            if (state != null) {
                barcodeScannerActivated = (Boolean)state.getValue();
            }
        }
        catch (Exception e) {
            logger.error("Error when deactivating the barcode scanner", (Throwable)e);
        }
    }

    void makeActions() {
        this.actionFactory = new OrderManagementActionFactory(this, this.actOrder, this.orderService);
        this.actionFactory.initActions();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        if (tbm != null) {
            tbm.add((IAction)this.actionFactory.getNewAction());
            tbm.add((IAction)this.actionFactory.getDailyWizardAction());
            tbm.add((IAction)this.actionFactory.getWizardAction());
            tbm.add((IAction)this.actionFactory.getPrintAction());
            tbm.add((IAction)this.actionFactory.getExportClipboardAction());
            actionBars.updateActionBars();
        }
    }

    public OrderManagementActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void dispose() {
        if (this.orderButtonCustomImage != null && !this.orderButtonCustomImage.isDisposed()) {
            this.orderButtonCustomImage.dispose();
        }
        this.getSite().getPage().removePartListener((IPartListener2)this.focusListener);
        super.dispose();
    }

    public Map<IOrderEntry, Integer> getPendingDeliveredValues() {
        return this.pendingDeliveredValues;
    }

    private void clearOtherSelections(TableViewer ... except) {
        HashSet<TableViewer> skip = new HashSet<TableViewer>(Arrays.asList(except));
        if (this.tableViewer != null && !skip.contains(this.tableViewer) && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.tableViewer.getTable().deselectAll();
        }
        if (this.orderTable != null && !skip.contains(this.orderTable) && !this.orderTable.getTable().isDisposed()) {
            this.orderTable.setSelection((ISelection)StructuredSelection.EMPTY);
            this.orderTable.getTable().deselectAll();
        }
        for (TableViewer tv : this.completedYearViewers) {
            if (tv == null || skip.contains(tv) || tv.getTable().isDisposed()) continue;
            tv.setSelection((ISelection)StructuredSelection.EMPTY);
            tv.getTable().deselectAll();
        }
    }

    public IOrderEntry findFirstEditableInViewerOrder() {
        Object top;
        Table t = this.tableViewer.getTable();
        int i = 0;
        while (i < t.getItemCount()) {
            IOrderEntry e;
            Object o = t.getItem(i).getData();
            if (o instanceof IOrderEntry && this.isEligibleForBooking(e = (IOrderEntry)o)) {
                return e;
            }
            ++i;
        }
        if (t.getItemCount() > 0 && (top = t.getItem(0).getData()) instanceof IOrderEntry) {
            IOrderEntry e = (IOrderEntry)top;
            return e;
        }
        return null;
    }

    public IOrderService getOrderService() {
        return this.orderService;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private static final class OrderHistorySummary {
        final String orderedUser;
        final String orderedDate;
        final String completedUser;
        final String completedDate;

        OrderHistorySummary(String orderedUser, String orderedDate, String completedUser, String completedDate) {
            this.orderedUser = orderedUser;
            this.orderedDate = orderedDate;
            this.completedUser = completedUser;
            this.completedDate = completedDate;
        }
    }
}

