/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Tree;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ViewerConfigurer {
    private ICommonViewerContentProvider contentProvider;
    private LabelProvider labelProvider;
    protected ControlFieldProvider controlFieldProvider;
    private ButtonProvider buttonProvider;
    private WidgetProvider widgetProvider;
    private IDoubleClickListener doubleClickListener;
    private ISelectionChangedListener selectionChangedListener;
    protected PersistentObjectDragSource.ISelectionRenderer poSelectionRenderer;
    protected GenericObjectDragSource.ISelectionRenderer goSelectionRenderer;
    private ContentType contentType = ContentType.PERSISTENTOBJECT;

    public ViewerConfigurer(ICommonViewerContentProvider cnp, LabelProvider lp, ControlFieldProvider cfp, ButtonProvider bp, WidgetProvider wp) {
        this.contentProvider = cnp;
        this.labelProvider = lp == null ? new DefaultLabelProvider() : lp;
        this.controlFieldProvider = cfp;
        this.buttonProvider = bp;
        this.widgetProvider = wp;
    }

    public ViewerConfigurer(ICommonViewerContentProvider cnp, LabelProvider lp, WidgetProvider wp) {
        this(cnp, lp, null, new DefaultButtonProvider(), wp);
    }

    public ViewerConfigurer setContentType(ContentType type) {
        this.contentType = type;
        return this;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public ViewerConfigurer setDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListener = listener;
        return this;
    }

    public ViewerConfigurer setSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListener = listener;
        return this;
    }

    public ButtonProvider getButtonProvider() {
        return this.buttonProvider;
    }

    public void setButtonProvider(ButtonProvider buttonProvider) {
        this.buttonProvider = buttonProvider;
    }

    public WidgetProvider getWidgetProvider() {
        return this.widgetProvider;
    }

    public void setWidgetProvider(WidgetProvider widgetProvider) {
        this.widgetProvider = widgetProvider;
    }

    public ICommonViewerContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ICommonViewerContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public ControlFieldProvider getControlFieldProvider() {
        return this.controlFieldProvider;
    }

    public void setControlFieldProvider(ControlFieldProvider controlFieldProvider) {
        this.controlFieldProvider = controlFieldProvider;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    public ISelectionChangedListener getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    public void addDragSourceSelectionRenderer(PersistentObjectDragSource.ISelectionRenderer iSelectionRenderer) {
        this.poSelectionRenderer = iSelectionRenderer;
    }

    public void addDragSourceSelectionRenderer(GenericObjectDragSource.ISelectionRenderer iSelectionRenderer) {
        this.goSelectionRenderer = iSelectionRenderer;
    }

    public static interface ButtonProvider {
        public Button createButton(Composite var1);

        public boolean isAlwaysEnabled();
    }

    public static enum ContentType {
        PERSISTENTOBJECT,
        GENERICOBJECT;

    }

    public static interface ControlFieldListener {
        public void changed(HashMap<String, String> var1);

        public void reorder(String var1);

        public void selected();
    }

    public static interface ControlFieldProvider {
        public Composite createControl(Composite var1);

        public void addChangeListener(ControlFieldListener var1);

        public void removeChangeListener(ControlFieldListener var1);

        public String[] getValues();

        public void clearValues();

        public boolean isEmpty();

        public void setQuery(Query<? extends PersistentObject> var1);

        public void setQuery(IQuery<?> var1);

        public IFilter createFilter();

        public void fireChangedEvent();

        public void fireSortEvent(String var1);

        public void setFocus();
    }

    public static class DefaultButtonProvider
    implements ButtonProvider {
        Class clazz;
        CommonViewer vcf;
        Dialog dlg;
        private String text = Messages.ViewerConfigurer_createNew;

        public DefaultButtonProvider() {
        }

        public DefaultButtonProvider(CommonViewer cv, Class cl) {
            this.clazz = cl;
            this.vcf = cv;
        }

        public DefaultButtonProvider(CommonViewer cv, Class cl, String t) {
            this.clazz = cl;
            this.vcf = cv;
            this.text = t;
        }

        public DefaultButtonProvider(CommonViewer cv, String t, Dialog dlg) {
            this.vcf = cv;
            this.text = t;
            this.dlg = dlg;
        }

        @Override
        public Button createButton(Composite parent) {
            if (this.vcf == null) {
                return null;
            }
            Button ret = new Button(parent, 8);
            ret.setText(this.text);
            ret.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (dlg != null) {
                        dlg.open();
                    } else {
                        CoreHub.poFactory.create(clazz, ((DefaultControlFieldProvider)vcf.getConfigurer().getControlFieldProvider()).getDBFields(), vcf.getConfigurer().getControlFieldProvider().getValues());
                    }
                    vcf.getViewerWidget().getControl().redraw();
                    vcf.getViewerWidget().getControl().update();
                    vcf.getConfigurer().getControlFieldProvider().clearValues();
                }
            });
            return ret;
        }

        @Override
        public boolean isAlwaysEnabled() {
            return false;
        }
    }

    public static interface ICommonViewerContentProvider
    extends IStructuredContentProvider,
    ControlFieldListener {
        public void init();

        public void startListening();

        public void stopListening();
    }

    public static interface IWorker {
        public IStatus work(IProgressMonitor var1, HashMap<String, Object> var2);
    }

    public static class TreeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof Tree) {
                Tree tree = (Tree)element;
                return ((PersistentObject)tree.contents).getLabel();
            }
            return element.toString();
        }
    }

    public static interface WidgetProvider {
        public StructuredViewer createViewer(Composite var1);
    }
}

