/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.dnd;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.Identifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public class IdentifiableDropTarget
implements DropTargetListener {
    IReceiver receiver;
    String name = "";

    public IdentifiableDropTarget(Control target, IReceiver receiver) {
        this.receiver = receiver;
        DropTarget dtarget = new DropTarget(target, 1);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        dtarget.setTransfer(types);
        dtarget.addDropListener((DropTargetListener)this);
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = this.receiver.accept(this.getIdentifiables(event)) ? 1 : 0;
    }

    public void drop(DropTargetEvent event) {
        this.receiver.dropped(this.getIdentifiables(event));
    }

    private List<Identifiable> getIdentifiables(DropTargetEvent event) {
        ArrayList<Identifiable> ret = new ArrayList<Identifiable>();
        if (event.data instanceof String) {
            String[] parts;
            String[] stringArray = parts = ((String)event.data).split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                Optional loaded = StoreToStringServiceHolder.get().loadFromString(part);
                loaded.ifPresent(i -> {
                    boolean bl = ret.add((Identifiable)i);
                });
                ++n2;
            }
        }
        return ret;
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.receiver.accept(this.getIdentifiables(event))) {
            event.detail = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public static interface IReceiver {
        public void dropped(List<Identifiable> var1);

        public boolean accept(List<Identifiable> var1);
    }
}

