/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.actions.RestrictedAction;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;

public class ViewMenus {
    IViewSite site;
    MenuManager contextMenu = null;

    public ViewMenus(IViewSite s) {
        this.site = s;
    }

    public void createMenu(IAction ... actions) {
        List<IContributionItem> contributionItems = ViewMenus.convertActionsToContributionItems(actions);
        this.createMenu(contributionItems);
    }

    public void createMenu(final List<IContributionItem> contributionItems) {
        final IMenuManager menuMgr = this.site.getActionBars().getMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ViewMenus.this.fillContextMenu(menuMgr, contributionItems);
            }
        });
        menuMgr.add((IContributionItem)new Separator());
    }

    public void createToolbar(IAction ... actions) {
        IToolBarManager tmg = this.site.getActionBars().getToolBarManager();
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction ac = iActionArray[n2];
            if (ac == null) {
                tmg.add((IContributionItem)new Separator());
            } else {
                tmg.add(ac);
            }
            ++n2;
        }
    }

    public void createViewerContextMenu(StructuredViewer viewer, final List<IContributionItem> contributionItems) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ViewMenus.this.fillContextMenu(manager, contributionItems);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void createViewerContextMenu(StructuredViewer viewer, IAction ... actions) {
        List<IContributionItem> contributionItems = ViewMenus.convertActionsToContributionItems(actions);
        this.createViewerContextMenu(viewer, contributionItems);
    }

    public void createControlContextMenu(Control control, final IAction ... actions) {
        final List<IContributionItem> contributionItems = ViewMenus.convertActionsToContributionItems(actions);
        this.contextMenu = new MenuManager();
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IAction[] iActionArray = actions;
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction iAction = iActionArray[n2];
                    if (iAction instanceof RestrictedAction) {
                        ((RestrictedAction)iAction).reflectRight();
                    }
                    ++n2;
                }
                ViewMenus.this.fillContextMenu(manager, contributionItems);
            }
        });
        Menu menu = this.contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    public MenuManager getContextMenu() {
        return this.contextMenu;
    }

    public void createControlContextMenu(Control control, final IMenuPopulator populator) {
        this.contextMenu = new MenuManager();
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IAction[] iActionArray = populator.fillMenu();
                int n = iActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction ac = iActionArray[n2];
                    if (ac == null) {
                        ViewMenus.this.contextMenu.add((IContributionItem)new Separator());
                    } else {
                        if (ac instanceof RestrictedAction) {
                            ((RestrictedAction)ac).reflectRight();
                        }
                        ViewMenus.this.contextMenu.add(ac);
                    }
                    ++n2;
                }
            }
        });
        Menu menu = this.contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    public static List<IContributionItem> convertActionsToContributionItems(IAction[] actions) {
        return Arrays.asList(actions).stream().map(s -> s != null ? new ActionContributionItem(s) : new Separator()).collect(Collectors.toList());
    }

    private void fillContextMenu(IMenuManager manager, List<IContributionItem> contributionItems) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        for (IContributionItem contributionItem : contributionItems) {
            ActionContributionItem ac;
            if (contributionItem == null) {
                manager.add((IContributionItem)new Separator());
                continue;
            }
            if (contributionItem instanceof ActionContributionItem && (ac = (ActionContributionItem)contributionItem).getAction() instanceof RestrictedAction) {
                ((RestrictedAction)ac.getAction()).reflectRight();
            }
            contributionItem.update();
            manager.add(contributionItem);
        }
    }

    public static interface IMenuPopulator {
        public IAction[] fillMenu();
    }
}

