/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.jdt.NonNull;
import java.util.Arrays;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSorter {
    private final TableViewer tableViewer;

    public TableViewerSorter(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.addColumnSelectionListeners(tableViewer);
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return TableViewerSorter.this.compareElements(e1, e2);
            }
        });
    }

    private void addColumnSelectionListeners(TableViewer tableViewer) {
        TableColumn[] columns = tableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            this.addColumnSelectionListener(columns[i]);
            ++i;
        }
    }

    private void addColumnSelectionListener(TableColumn column) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerSorter.this.tableColumnClicked((TableColumn)e.widget);
            }
        });
    }

    private void tableColumnClicked(TableColumn column) {
        Table table = column.getParent();
        if (column.equals(table.getSortColumn())) {
            table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
        } else {
            table.setSortColumn(column);
            table.setSortDirection(128);
        }
        this.tableViewer.refresh();
    }

    private int compareElements(Object e1, Object e2) {
        IColumnContentProvider columnValueProvider = (IColumnContentProvider)this.tableViewer.getContentProvider();
        Table table = this.tableViewer.getTable();
        int index = Arrays.asList(table.getColumns()).indexOf(table.getSortColumn());
        int result = 0;
        if (index != -1) {
            Comparable<?> c1 = columnValueProvider.getValue(e1, index);
            Comparable<?> c2 = columnValueProvider.getValue(e2, index);
            if (c1 instanceof String && c2 instanceof String) {
                String _c1 = (String)((Object)c1);
                String _c2 = (String)((Object)c2);
                result = _c1.compareToIgnoreCase(_c2);
            } else {
                result = c1.compareTo(c2);
            }
        }
        return table.getSortDirection() == 128 ? result : -result;
    }

    public static interface IColumnContentProvider {
        @NonNull
        public Comparable<?> getValue(Object var1, int var2);
    }
}

