/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.util.SortedList;
import ch.elexis.core.ui.util.OrderEntryComparators;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableSortController {
    private final TableViewer viewer;
    private int currentColumn = -1;
    private int currentDirection = 128;

    public TableSortController(TableViewer viewer) {
        this.viewer = viewer;
        viewer.getTable().setSortColumn(null);
        viewer.getTable().setSortDirection(0);
        this.hookColumns();
    }

    public void setDefaultSort(int columnIndex, int direction) {
        this.currentColumn = columnIndex;
        this.currentDirection = direction;
        this.applySort();
    }

    private void hookColumns() {
        Table table = this.viewer.getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            final int colIndex = i;
            TableColumn col = table.getColumn(i);
            col.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TableSortController.this.currentColumn == colIndex) {
                        TableSortController.this.currentDirection = TableSortController.this.currentDirection == 128 ? 1024 : 128;
                    } else {
                        TableSortController.this.currentColumn = colIndex;
                        TableSortController.this.currentDirection = 128;
                    }
                    TableSortController.this.applySort();
                }
            });
            ++i;
        }
    }

    private void applySort() {
        if (this.currentColumn < 0) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input instanceof List) {
            List list;
            List src = list = (List)input;
            SortedList sorted = new SortedList((Collection)src, OrderEntryComparators.forColumn(this.currentColumn, this.currentDirection));
            this.viewer.setInput((Object)sorted);
        }
        Table table = this.viewer.getTable();
        if (this.currentColumn >= 0 && this.currentColumn < table.getColumnCount()) {
            table.setSortColumn(table.getColumn(this.currentColumn));
        }
        this.viewer.refresh();
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public int getCurrentDirection() {
        return this.currentDirection;
    }
}

