/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.ui.constants.OrderConstants;
import ch.elexis.core.ui.dialogs.ContactSelectionDialog;
import ch.elexis.core.ui.dialogs.NeueBestellungDialog;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.views.OrderManagementView;
import ch.elexis.data.Bestellung;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderManagementUtil {
    private static final Logger logger = LoggerFactory.getLogger(OrderManagementUtil.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    public static final String BarcodeScanner_COMPORT = "barcode/Symbol/port";

    public static List<IOrder> getOpenOrders() {
        return OrderManagementUtil.getOrders(false, true);
    }

    public static List<IOrder> getCompletedOrders(boolean showAllYears) {
        return OrderManagementUtil.getOrders(true, showAllYears);
    }

    private static List<IOrder> getOrders(boolean completed, boolean showAllYears) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IOrder.class);
        List orders = query.execute();
        if (!showAllYears) {
            LocalDateTime twoYearsAgo = LocalDateTime.now().minusYears(2L);
            orders = orders.stream().filter(order -> {
                LocalDateTime orderTimestamp = order.getTimestamp();
                return orderTimestamp != null && orderTimestamp.isAfter(twoYearsAgo);
            }).collect(Collectors.toList());
        }
        return orders.stream().filter(order -> completed && order.isDone() && !order.getEntries().isEmpty() || !completed && (!order.isDone() || order.getEntries().isEmpty())).sorted((o1, o2) -> o2.getTimestamp().compareTo(o1.getTimestamp())).collect(Collectors.toList());
    }

    public static IOrder createOrder(String name, IOrderService orderService) {
        IOrder order = (IOrder)CoreModelServiceHolder.get().create(IOrder.class);
        order.setTimestamp(LocalDateTime.now());
        order.setName(name);
        CoreModelServiceHolder.get().save((Identifiable)order);
        orderService.getHistoryService().logCreateOrder(order);
        return order;
    }

    public static Image getStatusIcon(IOrder order, boolean forTable) {
        boolean isDone = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE);
        boolean isPartial = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.PARTIAL_DELIVER);
        boolean allOrdered = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.ORDERED);
        boolean isShoping = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE && e.getOrder().getEntries().isEmpty());
        boolean anyDelivered = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.DONE);
        if (isShoping) {
            return forTable ? OrderConstants.OrderImages.SHOPPING : OrderConstants.OrderImages.SHOPPING_64x64;
        }
        if (isDone) {
            return OrderConstants.OrderImages.THICK_CHECK;
        }
        if (anyDelivered) {
            return forTable ? OrderConstants.OrderImages.DELIVERY_TRUCK : OrderConstants.OrderImages.DELIVERY_TRUCK_64x64;
        }
        if (isPartial || allOrdered) {
            return forTable ? OrderConstants.OrderImages.DELIVERY_TRUCK : OrderConstants.OrderImages.DELIVERY_TRUCK_64x64;
        }
        return forTable ? OrderConstants.OrderImages.SHOPPING_CART : OrderConstants.OrderImages.SHOPPING_CART_64x64;
    }

    public static String getStatusText(IOrder order) {
        if (order == null || order.getEntries().isEmpty()) {
            return Messages.OrderManagement_NoItems;
        }
        boolean allOrdered = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.ORDERED);
        boolean allDelivered = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE);
        boolean anyDelivered = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.DONE);
        boolean isPartial = order.getEntries().stream().anyMatch(e -> e.getState() == OrderEntryState.PARTIAL_DELIVER);
        if (allDelivered) {
            return Messages.OrderManagement_FullyDelivered;
        }
        if (anyDelivered) {
            return Messages.OrderManagement_PartiallyDelivered;
        }
        if (isPartial) {
            return Messages.OrderManagement_PartiallyDelivered;
        }
        if (allOrdered) {
            return Messages.OrderManagement_Ordered;
        }
        return Messages.OrderManagement_NotOrdered;
    }

    public static void saveSingleDelivery(IOrderEntry entry, int partialDelivery, IOrderService orderService) {
        if (entry == null || partialDelivery == 0) {
            return;
        }
        try {
            IStock stock;
            int orderAmount = entry.getAmount();
            int currentDelivered = entry.getDelivered();
            int newDelivered = currentDelivered + partialDelivery;
            if (newDelivered < 0) {
                newDelivered = 0;
            }
            if ((stock = entry.getStock()) != null) {
                OrderManagementUtil.updateStockEntry(stock, entry, partialDelivery);
            }
            orderService.getHistoryService().logDelivery(entry.getOrder(), entry, newDelivered, orderAmount);
            entry.setDelivered(newDelivered);
            if (newDelivered >= entry.getAmount()) {
                entry.setState(OrderEntryState.DONE);
            } else if (newDelivered > 0) {
                entry.setState(OrderEntryState.PARTIAL_DELIVER);
            } else {
                entry.setState(OrderEntryState.ORDERED);
            }
            CoreModelServiceHolder.get().save((Identifiable)entry);
            IOrder order = entry.getOrder();
            boolean allDelivered = order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE);
            if (allDelivered) {
                orderService.getHistoryService().logCompleteDelivery(order);
            }
        }
        catch (NumberFormatException e2) {
            logger.error("Error: Invalid partialDelivery value: " + partialDelivery, (Throwable)e2);
        }
    }

    public static void saveAllDeliveries(List<IOrderEntry> entries, IOrderService orderService) {
        for (IOrderEntry entry : entries) {
            int partialDelivery = entry.getAmount() - entry.getDelivered();
            if (partialDelivery <= 0) continue;
            OrderManagementUtil.saveSingleDelivery(entry, partialDelivery, orderService);
        }
    }

    public static IOrder addItemsToOrder(IOrder actOrder, List<IArticle> articlesToOrder, Shell shell, IOrderService orderService) {
        if (actOrder == null) {
            NeueBestellungDialog nbDlg = new NeueBestellungDialog(shell, ch.elexis.core.ui.views.Messages.BestellView_CreateNewOrder, ch.elexis.core.ui.views.Messages.BestellView_EnterOrderTitle);
            if (nbDlg.open() == 0) {
                actOrder = OrderManagementUtil.createOrder(nbDlg.getTitle(), orderService);
            } else {
                return null;
            }
        }
        for (IArticle article : articlesToOrder) {
            int quantity = 1;
            Optional<IOrderEntry> existingEntry = actOrder.getEntries().stream().filter(e -> e.getArticle().equals(article)).findFirst();
            if (existingEntry.isPresent()) {
                IOrderEntry orderEntry = existingEntry.get();
                int oldQuantity = orderEntry.getAmount();
                int newQuantity = oldQuantity + quantity;
                orderEntry.setAmount(newQuantity);
                CoreModelServiceHolder.get().save((Identifiable)orderEntry);
                orderService.getHistoryService().logEdit(actOrder, orderEntry, oldQuantity, newQuantity);
                continue;
            }
            String mandatorId = ContextServiceHolder.get().getActiveMandator().map(Identifiable::getId).orElse(null);
            IStock stock = StockServiceHolder.get().getMandatorDefaultStock(mandatorId);
            IOrderEntry newOrderEntry = actOrder.addEntry(article, stock, null, quantity);
            orderService.getHistoryService().logChangedAmount(actOrder, newOrderEntry, 0, quantity);
            CoreModelServiceHolder.get().save((Identifiable)newOrderEntry);
        }
        return actOrder;
    }

    public static String formatDate(LocalDateTime dateTime) {
        return dateTime.format(FORMATTER);
    }

    public static IOrder getSelectedOrder(String orderId, boolean isCompleted) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IOrder.class);
        return query.execute().stream().filter(o -> o.getId().equals(orderId) && (o.isDone() == isCompleted || o.getEntries().isEmpty())).findFirst().orElse(null);
    }

    public static Image getEntryStatusIcon(IOrderEntry entry) {
        if (entry == null) {
            return null;
        }
        int delivered = entry.getDelivered();
        int ordered = entry.getAmount();
        if (delivered == 0) {
            return Images.IMG_BULLET_RED.getImage();
        }
        if (delivered < ordered) {
            return Images.IMG_BULLET_YELLOW.getImage();
        }
        return Images.IMG_BULLET_GREEN.getImage();
    }

    public static IOutputLog getOrderLogEntry(IOrder order) {
        if (order == null) {
            return null;
        }
        IQuery query = CoreModelServiceHolder.get().getQuery(IOutputLog.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IOUTPUT_LOG__OBJECT_ID, IQuery.COMPARATOR.EQUALS, (Object)order.getId());
        return query.execute().isEmpty() ? null : (IOutputLog)query.execute().get(0);
    }

    public static void updateStockEntry(IStock stock, IOrderEntry entry, int amountToAdd) {
        if (stock == null || entry == null || entry.getArticle() == null) {
            logger.error("Error: Invalid parameters in updateStockEntry()");
            return;
        }
        Optional<IStockEntry> existingStockEntry = stock.getStockEntries().stream().filter(se -> se.getArticle().equals(entry.getArticle())).findFirst();
        if (existingStockEntry.isPresent()) {
            IStockEntry se2 = existingStockEntry.get();
            int current = se2.getCurrentStock();
            int newStock = current + amountToAdd;
            if (newStock < 0) {
                newStock = 0;
            }
            se2.setCurrentStock(newStock);
            CoreModelServiceHolder.get().save((Identifiable)se2);
        } else {
            int startStock = Math.max(0, amountToAdd);
            IStockEntry newStockEntry = (IStockEntry)CoreModelServiceHolder.get().create(IStockEntry.class);
            newStockEntry.setArticle(entry.getArticle());
            newStockEntry.setStock(stock);
            newStockEntry.setCurrentStock(startStock);
            CoreModelServiceHolder.get().save((Identifiable)newStockEntry);
        }
    }

    public static void activateBarcodeScannerAndFocus() {
        String COMMAND_ID = "ch.elexis.base.barcode.scanner.ListenerProcess";
        try {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command scannerCommand = commandService.getCommand(COMMAND_ID);
            Boolean isActive = false;
            if (scannerCommand.getState("org.eclipse.jface.commands.ToggleState") != null) {
                isActive = (Boolean)scannerCommand.getState("org.eclipse.jface.commands.ToggleState").getValue();
            }
            if (!isActive.booleanValue()) {
                if (scannerCommand.isEnabled()) {
                    try {
                        handlerService.executeCommand(COMMAND_ID, null);
                    }
                    catch (Exception e) {
                        logger.warn("Scanner could not be activated (possibly changed too quickly): " + e.getMessage());
                    }
                } else {
                    logger.debug("Scanner Command ist disabled (busy). Skip activation.");
                }
            }
            OrderManagementView.setBarcodeScannerActivated(true);
            ContextServiceHolder.get().getRootContext().setNamed("barcodeInputConsumer", (Object)OrderManagementView.class.getName());
        }
        catch (Exception e) {
            logger.error("General error in barcode setup", (Throwable)e);
        }
    }

    public static void deactivateBarcodeScanner() {
        String COMMAND_ID = "ch.elexis.base.barcode.scanner.ListenerProcess";
        try {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command scannerCommand = commandService.getCommand(COMMAND_ID);
            if (scannerCommand == null) {
                return;
            }
            State state = scannerCommand.getState("org.eclipse.jface.commands.ToggleState");
            if (state == null) {
                state = scannerCommand.getState("STYLE");
            }
            Boolean isActive = false;
            if (state != null) {
                isActive = (Boolean)state.getValue();
            }
            if (Boolean.TRUE.equals(isActive)) {
                handlerService.executeCommand(COMMAND_ID, null);
            }
            OrderManagementView.setBarcodeScannerActivated(false);
            ContextServiceHolder.get().getRootContext().setNamed("barcodeInputConsumer", null);
        }
        catch (Exception e) {
            logger.error("Error when deactivating the barcode scanner", (Throwable)e);
        }
    }

    public static void handleOrderButtonClick(OrderManagementView view, IOrderService orderService, Map<IOrderEntry, Integer> pendingDeliveredValues, IOrder actOrder) {
        Button orderButton = view.orderButton;
        String buttonText = orderButton.getText();
        if (buttonText.equals(ch.elexis.core.ui.views.Messages.OrderManagement_Button_Order)) {
            boolean confirm = MessageDialog.openQuestion((Shell)view.getSite().getShell(), (String)ch.elexis.core.ui.dialogs.Messages.OrderMethodDialog_Title, (String)ch.elexis.core.ui.dialogs.Messages.OrderMethodDialog_Message);
            if (confirm) {
                view.getActionFactory().sendOrder();
                view.loadOpenOrders();
            }
            view.refresh();
            return;
        }
        if (buttonText.equals(ch.elexis.core.ui.views.Messages.OrderManagement_Button_MissingSupplier)) {
            IContact selectedProvider;
            List<IContact> allowedSuppliers = OrderManagementUtil.loadConfiguredSuppliers();
            ContactSelectionDialog dialog = new ContactSelectionDialog(view.getSite().getShell(), IContact.class, ch.elexis.core.ui.views.Messages.OrderManagement_SelectSupplier_Title, ch.elexis.core.ui.views.Messages.OrderManagement_SelectSupplier_Message, new String[0]);
            if (dialog.open() == 0 && (selectedProvider = (IContact)dialog.getSelection()) != null && actOrder != null) {
                for (IOrderEntry entry : actOrder.getEntries()) {
                    if (entry.getProvider() != null) continue;
                    entry.setProvider(selectedProvider);
                    orderService.getHistoryService().logSupplierAdded(actOrder, entry, selectedProvider.getLabel());
                    CoreModelServiceHolder.get().save((Identifiable)entry);
                }
                view.refreshTables();
            }
            return;
        }
        if (buttonText.equals(ch.elexis.core.ui.views.Messages.OrderManagement_Button_Book) || buttonText.equals(ch.elexis.core.ui.views.Messages.OmnivoreView_editActionCaption)) {
            view.setDeliveryEditMode(true);
            OrderManagementUtil.setCheckboxColumnVisible(view, true);
            view.tableViewer.refresh();
            IOrderEntry first = view.findFirstEditableInViewerOrder();
            if (first != null) {
                view.tableViewer.setSelection((ISelection)new StructuredSelection((Object)first), true);
                view.tableViewer.reveal((Object)first);
                view.tableViewer.editElement((Object)first, 3);
                orderButton.setText(ch.elexis.core.ui.views.Messages.MedicationComposite_btnConfirm);
                orderButton.setImage(Images.IMG_TICK.getImage());
            }
            OrderManagementUtil.enableLastColumnFill(view.tableViewer.getTable());
            return;
        }
        if (buttonText.equals(ch.elexis.core.ui.views.Messages.MedicationComposite_btnConfirm)) {
            for (Map.Entry<IOrderEntry, Integer> entry : pendingDeliveredValues.entrySet()) {
                IOrderEntry orderEntry = entry.getKey();
                int currentDelivered = orderEntry.getDelivered();
                int ordered = orderEntry.getAmount();
                int part = entry.getValue();
                int newTotal = currentDelivered + part;
                if (newTotal > ordered) {
                    String articleName = orderEntry.getArticle() != null ? orderEntry.getArticle().getLabel() : "Unbekannter Artikel";
                    boolean confirm = MessageDialog.openQuestion((Shell)view.getSite().getShell(), (String)ch.elexis.core.ui.views.Messages.OrderManagement_Overdelivery_Title, (String)MessageFormat.format(ch.elexis.core.ui.views.Messages.OrderManagement_Overdelivery_Message, currentDelivered, part, newTotal, ordered, articleName));
                    if (!confirm) continue;
                }
                if (newTotal < 0) {
                    MessageDialog.openError((Shell)view.getSite().getShell(), (String)ch.elexis.core.ui.views.Messages.Cst_Text_ungueltiger_Wert, (String)ch.elexis.core.ui.views.Messages.OrderManagement_Error_NegativeDeliveredAmount);
                    continue;
                }
                orderService.getHistoryService().logDelivery(orderEntry.getOrder(), orderEntry, part, ordered);
                OrderManagementUtil.saveSingleDelivery(orderEntry, part, orderService);
            }
            pendingDeliveredValues.clear();
            view.setDeliveryEditMode(false);
            OrderManagementUtil.setCheckboxColumnVisible(view, false);
            view.selectAllChk.setVisible(false);
            view.selectAllChk.getParent().layout(true, true);
            view.tableViewer.refresh();
            boolean isCompletelyDelivered = OrderManagementUtil.isOrderCompletelyDelivered(actOrder);
            String finishedOrderId = actOrder != null ? actOrder.getId() : null;
            Display.getDefault().asyncExec(() -> {
                IOrder reloaded;
                view.loadOpenOrders();
                view.loadCompletedOrders(view.getCompletedContainer());
                if (finishedOrderId != null && (reloaded = OrderManagementUtil.getSelectedOrder(finishedOrderId, isCompletelyDelivered)) != null) {
                    view.setActOrder(reloaded);
                    view.selectOrderInHistory(reloaded);
                    view.refresh();
                }
                view.updateUI();
            });
            return;
        }
    }

    public static List<IContact> loadConfiguredSuppliers() {
        LinkedHashSet<IContact> result = new LinkedHashSet<IContact>();
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Transporter");
        for (IConfigurationElement ic : list) {
            String handlerType = ic.getAttribute("type");
            if (handlerType == null || !handlerType.contains(Bestellung.class.getName())) continue;
            try {
                IDataSender sender;
                List<IContact> suppliers;
                Object executable = ic.createExecutableExtension("ExporterClass");
                if (!(executable instanceof IDataSender) || (suppliers = (sender = (IDataSender)executable).getSupplier()) == null) continue;
                result.addAll(suppliers);
            }
            catch (CoreException e) {
                LoggerFactory.getLogger(OrderManagementUtil.class).error("Error loading supplier from plugin: " + ic.getContributor().getName(), (Throwable)e);
            }
        }
        return new ArrayList<IContact>(result);
    }

    public static void setCheckboxColumnVisible(OrderManagementView view, boolean visible) {
        Table table = view.checkboxViewer.getTable();
        if (table.isDisposed() || table.getColumnCount() == 0) {
            return;
        }
        view.selectAllChk.setVisible(visible);
        TableColumn checkboxCol = table.getColumn(0);
        checkboxCol.setResizable(visible);
        checkboxCol.setMoveable(visible);
        checkboxCol.setWidth(visible ? 30 : 0);
    }

    public static boolean isOrderCompletelyDelivered(IOrder order) {
        if (order == null || order.getEntries().isEmpty()) {
            return false;
        }
        return order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.DONE);
    }

    public static void enableLastColumnFill(Table table) {
        table.addListener(11, e -> {
            Table t = (Table)e.widget;
            OrderManagementUtil.adjustLastColumnWidth(t);
        });
    }

    public static void adjustLastColumnWidth(Table table) {
        if (table == null || table.isDisposed() || table.getColumnCount() == 0) {
            return;
        }
        int clientWidth = table.getClientArea().width;
        if (clientWidth <= 0) {
            return;
        }
        int totalFixedWidth = 0;
        int i = 0;
        while (i < table.getColumnCount() - 1) {
            totalFixedWidth += table.getColumn(i).getWidth();
            ++i;
        }
        int newLastWidth = clientWidth - totalFixedWidth;
        int minLastWidth = 50;
        if (newLastWidth < minLastWidth) {
            newLastWidth = minLastWidth;
        }
        table.getColumn(table.getColumnCount() - 1).setWidth(newLastWidth);
    }
}

