/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.dialogs.ContactSelectionDialog;
import ch.elexis.core.ui.dialogs.DailyConsumptionOrderDialog;
import ch.elexis.core.ui.dialogs.HistoryDialog;
import ch.elexis.core.ui.dialogs.NeueBestellungDialog;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.OrderManagementUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.dnd.OrderDropReceiver;
import ch.elexis.core.ui.views.BestellBlatt;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.OrderManagementView;
import ch.elexis.data.Bestellung;
import ch.rgw.tools.ExHandler;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderManagementActionFactory {
    private static final Logger logger = LoggerFactory.getLogger(OrderManagementActionFactory.class);
    private final OrderManagementView view;
    private Action dailyWizardAction;
    private Action wizardAction;
    private Action newAction;
    private Action printAction;
    private Action exportClipboardAction;
    private IOrderService orderService;
    private IOrder actOrder;

    public OrderManagementActionFactory(OrderManagementView view, IOrder actOrder, IOrderService orderService) {
        this.view = Objects.requireNonNull(view);
        this.actOrder = actOrder;
        this.orderService = orderService;
    }

    public void initActions() {
        this.dailyWizardAction = this.createAction(Messages.BestellView_AutomaticDailyOrder, Images.IMG_WIZ_DAY.getImageDescriptor(), Messages.BestellView_CreateAutomaticDailyOrder, 1, () -> this.handleDailyOrder());
        this.wizardAction = this.createAction(Messages.BestellView_AutomaticOrder, Images.IMG_WIZARD.getImageDescriptor(), Messages.BestellView_CreateAutomaticOrder, 1, () -> this.handleAutomaticOrder());
        this.newAction = this.createAction(Messages.BestellView_CreateNewOrder, Images.IMG_NEW.getImageDescriptor(), Messages.BestellView_CreateNewOrder, 1, () -> this.createNewOrder());
        this.printAction = this.createAction(Messages.BestellView_PrintOrder, Images.IMG_PRINTER.getImageDescriptor(), Messages.BestellView_PrintOrder, 1, () -> this.printOrder());
        this.exportClipboardAction = this.createAction(Messages.BestellView_copyToClipboard, Images.IMG_CLIPBOARD.getImageDescriptor(), Messages.BestellView_copyToClipBioardForGalexis, 1, () -> this.copyOrderToClipboard());
    }

    private Action createAction(String text, ImageDescriptor imageDescriptor, String toolTipText, int style, final Runnable runMethod) {
        Action action = new Action(text, style){

            public void run() {
                runMethod.run();
            }
        };
        if (imageDescriptor != null) {
            action.setImageDescriptor(imageDescriptor);
        }
        action.setToolTipText(toolTipText);
        return action;
    }

    public Action getDailyWizardAction() {
        return this.dailyWizardAction;
    }

    public Action getWizardAction() {
        return this.wizardAction;
    }

    public Action getNewAction() {
        return this.newAction;
    }

    public Action getPrintAction() {
        return this.printAction;
    }

    public Action getExportClipboardAction() {
        return this.exportClipboardAction;
    }

    private void handleDailyOrder() {
        IOrder orderToUse;
        boolean reuseExistingOrder;
        boolean bl = reuseExistingOrder = this.isDailyOrder(this.actOrder) && this.isUnsent(this.actOrder) && this.actOrder.getTimestamp().toLocalDate().equals(LocalDate.now());
        if (reuseExistingOrder) {
            orderToUse = this.actOrder;
        } else {
            orderToUse = (IOrder)CoreModelServiceHolder.get().create(IOrder.class);
            orderToUse.setTimestamp(LocalDateTime.now());
            orderToUse.setName(Messages.BestellView_AutomaticDaily);
        }
        DailyConsumptionOrderDialog doDlg = new DailyConsumptionOrderDialog(this.view.getSite().getShell(), orderToUse);
        int result = doDlg.open();
        if (result == 0) {
            this.actOrder = orderToUse;
            this.view.setActOrder(this.actOrder);
            this.view.reload();
            this.view.updateCheckIn();
        }
    }

    private boolean isDailyOrder(IOrder order) {
        return order != null && Messages.BestellView_AutomaticDaily.equals(order.getName());
    }

    private boolean isUnsent(IOrder order) {
        if (order == null) {
            return false;
        }
        return order.getEntries().stream().allMatch(e -> e.getState() == OrderEntryState.OPEN);
    }

    private boolean isStockOrder(IOrder order) {
        return order != null && Messages.OrderManagement_StockOrder_DefaultName.equals(order.getName());
    }

    private IOrder findReusableStockOrder() {
        for (IOrder o : OrderManagementUtil.getOpenOrders()) {
            if (!this.isStockOrder(o) || !this.isUnsent(o)) continue;
            return o;
        }
        return null;
    }

    private void clearOpenEntries(IOrder order) {
        if (order == null) {
            return;
        }
        ArrayList<IOrderEntry> toRemove = new ArrayList<IOrderEntry>();
        for (IOrderEntry entry : new ArrayList(order.getEntries())) {
            if (entry.getState() != OrderEntryState.OPEN) continue;
            toRemove.add(entry);
        }
        for (IOrderEntry entry : toRemove) {
            order.getEntries().remove(entry);
            CoreModelServiceHolder.get().delete((Deleteable)entry);
        }
    }

    private void handleAutomaticOrder() {
        IOrder reusableStockOrder = this.findReusableStockOrder();
        if (reusableStockOrder != null) {
            this.actOrder = reusableStockOrder;
            this.clearOpenEntries(this.actOrder);
        } else {
            this.actOrder = OrderManagementUtil.createOrder(Messages.OrderManagement_StockOrder_DefaultName, this.orderService);
        }
        int trigger = ConfigServiceHolder.get().get("inventory/order_trigger", 0);
        boolean isInventoryBelow = trigger == 0;
        boolean excludeAlreadyOrderedItems = ConfigServiceHolder.get().get("inventory/order_exclude_already_ordered_items", false);
        IQuery query = CoreModelServiceHolder.get().getQuery(IStockEntry.class);
        query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__CURRENT_STOCK, isInventoryBelow ? IQuery.COMPARATOR.LESS : IQuery.COMPARATOR.LESS_OR_EQUAL, (EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__MINIMUM_STOCK);
        List stockEntries = query.execute();
        for (IStockEntry stockEntry : stockEntries) {
            if (stockEntry.getArticle() != null) {
                IOrderEntry open;
                if (excludeAlreadyOrderedItems && (open = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(stockEntry)) != null) continue;
                OrderServiceHolder.get().addRefillForStockEntryToOrder(stockEntry, this.actOrder);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).warn("Could not resolve article " + stockEntry.getLabel() + " of stock entry " + stockEntry.getId());
        }
        if (this.actOrder != null) {
            this.view.setActOrder(this.actOrder);
            this.view.reload();
        }
        this.view.updateCheckIn();
    }

    private void createNewOrder() {
        NeueBestellungDialog nbDlg = new NeueBestellungDialog(this.view.getSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
        if (nbDlg.open() == 0) {
            this.actOrder = OrderManagementUtil.createOrder(nbDlg.getTitle(), this.orderService);
            this.view.setActOrder(this.actOrder);
            OrderManagementView.setBarcodeScannerActivated(true);
            this.view.reload();
        }
    }

    public void printOrder() {
        if (this.actOrder != null) {
            Map<IContact, List<IOrderEntry>> orderMap = this.prepareOrderMap();
            for (IContact receiver : orderMap.keySet()) {
                List<IOrderEntry> entries = orderMap.get(receiver);
                if (receiver == null) {
                    receiver = ContactSelectionDialog.showInSync(IContact.class, ch.elexis.core.ui.text.Messages.TextContainer_SelectDestinationHeader, Messages.OrderManagement_NoSupplierRecipient);
                }
                if (receiver == null) continue;
                try {
                    BestellBlatt bb = (BestellBlatt)this.view.getViewSite().getPage().showView("ch.elexis.BestellBlatt", receiver.getId(), 3);
                    bb.createOrder(receiver, entries);
                    entries.forEach(oe -> {
                        oe.setState(OrderEntryState.ORDERED);
                        CoreModelServiceHolder.get().save((Identifiable)oe);
                    });
                    this.orderService.getHistoryService().logOrderSent(this.actOrder, false);
                    this.view.reload();
                }
                catch (Exception e) {
                    logger.error("Error printing order", (Throwable)e);
                    MessageDialog.openError((Shell)this.view.getViewSite().getShell(), (String)Messages.Core_Error, (String)MessageFormat.format(Messages.OrderManagement_PrintError, receiver.getLabel()));
                }
            }
        }
    }

    private Map<IContact, List<IOrderEntry>> prepareOrderMap() {
        HashMap<IContact, List<IOrderEntry>> ret = new HashMap<IContact, List<IOrderEntry>>();
        List<Object> list = this.actOrder.getEntries();
        for (IOrderEntry iOrderEntry : list) {
            list = (List)ret.get(iOrderEntry.getProvider());
            if (list == null) {
                list = new ArrayList<IOrderEntry>();
            }
            list.add(iOrderEntry);
            ret.put(iOrderEntry.getProvider(), list);
        }
        for (List best : ret.values()) {
            best.sort((left, right) -> {
                String s1 = left.getArticle().getName();
                String s2 = right.getArticle().getName();
                return s1.compareTo(s2);
            });
        }
        return ret;
    }

    public IOrder setOrder(IOrder actOrder) {
        this.actOrder = actOrder;
        return this.actOrder;
    }

    public void sendOrder() {
        if (this.actOrder == null) {
            logger.warn("No active order to send.");
            return;
        }
        ArrayList<IOrderEntry> orderableItems = new ArrayList<IOrderEntry>();
        ArrayList<IOrderEntry> noSupplierItems = new ArrayList<IOrderEntry>();
        for (IOrderEntry orderEntry : this.actOrder.getEntries()) {
            IContact supplier = orderEntry.getProvider();
            if (supplier != null) {
                orderableItems.add(orderEntry);
                continue;
            }
            noSupplierItems.add(orderEntry);
        }
        boolean runOrder = true;
        if (!noSupplierItems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (IOrderEntry noSupItem : noSupplierItems) {
                sb.append(noSupItem.getArticle().getLabel()).append("\n");
            }
            runOrder = SWTHelper.askYesNo(Messages.BestellView_NoSupplierArticle, MessageFormat.format(Messages.BestellView_NoSupplierArticleMsg, sb.toString()));
        }
        if (runOrder) {
            List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Transporter");
            boolean handlerFound = false;
            for (IConfigurationElement ic : list) {
                String handler = ic.getAttribute("type");
                if (handler == null || !handler.contains(Bestellung.class.getName())) continue;
                handlerFound = true;
                try {
                    IDataSender sender = (IDataSender)ic.createExecutableExtension("ExporterClass");
                    if (!sender.canHandle((Identifiable)this.actOrder)) continue;
                    try {
                        sender.store(this.actOrder);
                        sender.finalizeExport();
                    }
                    catch (XChangeException xe) {
                        if ("ABORT_BY_USER".equals(xe.getMessage())) continue;
                        logger.error("Error saving or exporting the order: ", (Throwable)xe);
                        SWTHelper.showError(Messages.OrderManagement_ExportError_Title, Messages.OrderManagement_ExportError_Message);
                        continue;
                    }
                    String pluginName = ic.getAttribute("name");
                    if (pluginName == null || pluginName.isEmpty()) {
                        pluginName = sender.getClass().getSimpleName();
                    }
                    HashSet<String> added = new HashSet<String>();
                    StringJoiner contactsJoiner = new StringJoiner(", ");
                    for (IOrderEntry oe : orderableItems) {
                        String label;
                        IContact provider = oe.getProvider();
                        if (provider == null || !added.add(label = provider.getLabel())) continue;
                        contactsJoiner.add(label);
                    }
                    String joinedNames = contactsJoiner.toString();
                    String contactNames = !joinedNames.isEmpty() ? joinedNames : Messages.OrderManagement_NoSupplierRecipient;
                    String title = MessageFormat.format(Messages.BestellView_OrderSentWithPluginTitle, pluginName);
                    String body = MessageFormat.format(Messages.BestellView_OrderSentWithPluginBody, this.actOrder.getName(), contactNames);
                    SWTHelper.showInfo(title, body);
                    this.view.refresh();
                    this.orderService.getHistoryService().logOrderSent(this.actOrder, true);
                    this.view.reload();
                }
                catch (CoreException ex) {
                    ExHandler.handle((Throwable)ex);
                    logger.error("Error sending the order: ", (Throwable)ex);
                }
            }
            if (!handlerFound) {
                logger.warn("No valid supplier plugin found! Please install one or contact support.");
                SWTHelper.showError(Messages.OrderManagement_MissingSupplierPlugin_Title, Messages.OrderManagement_MissingSupplierPlugin_Message);
            }
        }
    }

    private void copyOrderToClipboard() {
        if (this.actOrder != null) {
            StringBuilder sb = new StringBuilder();
            for (IOrderEntry orderEntry : this.actOrder.getEntries()) {
                String code = orderEntry.getArticle().getCode();
                int num = orderEntry.getAmount();
                String name = orderEntry.getArticle().getName();
                sb.append(code).append(", ").append(num).append(", ").append(name).append(System.lineSeparator());
            }
            String clipboardText = sb.toString();
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{clipboardText}, new Transfer[]{textTransfer});
            clipboard.dispose();
        }
    }

    public void createContextMenu(final TableViewer table, TableViewer orderTable) {
        if (table.getTable().getMenu() != null && !table.getTable().getMenu().isDisposed()) {
            table.getTable().getMenu().dispose();
        }
        final Action removeAction = new Action(Messages.BestellView_RemoveArticle){

            public void run() {
                OrderManagementActionFactory.this.handleRemoveItem();
            }
        };
        removeAction.setImageDescriptor(Images.IMG_CLEAR.getImageDescriptor());
        final Action editAction = new Action(Messages.OrderManagement_EditItem){

            public void run() {
                OrderManagementActionFactory.this.handleEditItem();
            }
        };
        editAction.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
        final Action addAction = new Action(Messages.OrderManagement_AddItem){

            public void run() {
                OrderManagementActionFactory.this.handleAddItem();
            }
        };
        addAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean hasOrder = OrderManagementActionFactory.this.actOrder != null;
                boolean hasEntries = hasOrder && !OrderManagementActionFactory.this.actOrder.getEntries().isEmpty();
                IOrderEntry selectedEntry = null;
                IStructuredSelection sel = (IStructuredSelection)table.getSelection();
                if (sel != null && !sel.isEmpty() && sel.getFirstElement() instanceof IOrderEntry) {
                    selectedEntry = (IOrderEntry)sel.getFirstElement();
                }
                boolean enableEditRemove = hasEntries && selectedEntry != null;
                removeAction.setEnabled(enableEditRemove);
                editAction.setEnabled(enableEditRemove);
                manager.add((IAction)removeAction);
                manager.add((IAction)editAction);
                manager.add((IAction)addAction);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)table.getTable());
        table.getTable().setMenu(menu);
        Table swtTable = table.getTable();
        swtTable.addListener(35, ev -> {
            Point p = swtTable.toControl(ev.x, ev.y);
            TableItem item = swtTable.getItem(p);
            if (item == null) {
                table.setSelection((ISelection)StructuredSelection.EMPTY, true);
            }
        });
        swtTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    OrderManagementActionFactory.this.handleRemoveItem();
                }
            }
        });
        this.createOrderHistoryMenu(orderTable);
    }

    public void createOrderHistoryMenu(final TableViewer orderTableViewer) {
        final Action historyAction = new Action(Messages.OrderManagement_ShowOrderHistory){

            public void run() {
                OrderManagementActionFactory.this.handleShowOrderHistory(orderTableViewer);
            }
        };
        historyAction.setImageDescriptor(Images.IMG_INFO.getImageDescriptor());
        final Action deleteAction = new Action(Messages.OrderManagement_DeleteOrder){

            public void run() {
                OrderManagementActionFactory.this.handleDeleteOrder(orderTableViewer);
            }
        };
        deleteAction.setImageDescriptor(Images.IMG_CLEAR.getImageDescriptor());
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                deleteAction.setEnabled(false);
                IStructuredSelection selection = (IStructuredSelection)orderTableViewer.getSelection();
                Object first = selection.getFirstElement();
                if (first instanceof IOrder) {
                    IOrder selectedOrder = (IOrder)first;
                    boolean allOpen = selectedOrder.getEntries().stream().allMatch(entry -> entry.getState() == OrderEntryState.OPEN);
                    deleteAction.setEnabled(allOpen);
                }
                manager.add((IAction)historyAction);
                manager.add((IAction)deleteAction);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)orderTableViewer.getTable());
        orderTableViewer.getTable().setMenu(menu);
    }

    private void handleDeleteOrder(TableViewer orderTableViewer) {
        IStructuredSelection selection = (IStructuredSelection)orderTableViewer.getSelection();
        IOrder selectedOrder = (IOrder)selection.getFirstElement();
        if (selectedOrder == null) {
            return;
        }
        String orderName = selectedOrder.getName() != null ? selectedOrder.getName() : Messages.UNKNOWN;
        String orderDate = OrderManagementUtil.formatDate(selectedOrder.getTimestamp());
        String title = Messages.OrderManagement_DeleteOrder_Title;
        String message = MessageFormat.format(Messages.OrderManagement_DeleteOrder_Message, orderName, orderDate);
        boolean confirm = MessageDialog.openQuestion((Shell)this.view.getSite().getShell(), (String)title, (String)message);
        if (!confirm) {
            return;
        }
        ArrayList entriesToDelete = new ArrayList(selectedOrder.getEntries());
        for (IOrderEntry entry : entriesToDelete) {
            CoreModelServiceHolder.get().delete((Deleteable)entry);
        }
        selectedOrder.getEntries().clear();
        CoreModelServiceHolder.get().delete((Deleteable)selectedOrder);
        if (this.actOrder != null && this.actOrder.getId().equals(selectedOrder.getId())) {
            this.actOrder = null;
            this.view.setActOrder(null);
        }
        Display.getDefault().asyncExec(() -> {
            this.view.getTableViewer().setInput(Collections.emptyList());
            this.view.getTableViewer().refresh();
            this.view.reload();
            this.view.clearOrderDetailsView();
        });
    }

    private void handleRemoveItem() {
        IStructuredSelection selection = (IStructuredSelection)this.view.tableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        ArrayList<IOrderEntry> selectedEntries = new ArrayList<IOrderEntry>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IOrderEntry) {
                selectedEntries.add((IOrderEntry)o);
            }
            ++n2;
        }
        if (selectedEntries.isEmpty()) {
            return;
        }
        for (IOrderEntry entry : selectedEntries) {
            IOrder order;
            if (entry.getState() != OrderEntryState.OPEN || (order = entry.getOrder()) == null) continue;
            this.orderService.getHistoryService().logRemove(order, entry);
            CoreModelServiceHolder.get().delete((Deleteable)entry);
            order.getEntries().remove(entry);
        }
        if (this.actOrder != null && this.actOrder.getEntries().isEmpty()) {
            CoreModelServiceHolder.get().delete((Deleteable)this.actOrder);
            this.actOrder = null;
            this.view.setActOrder(null);
        }
        Display.getDefault().asyncExec(() -> {
            if (this.actOrder != null) {
                this.view.getTableViewer().refresh();
                this.view.updateOrderDetails(this.actOrder);
            } else {
                this.view.clearOrderDetailsView();
                this.view.getTableViewer().setInput(Collections.emptyList());
                this.view.getTableViewer().refresh();
            }
        });
        this.view.reload();
    }

    private void handleShowOrderHistory(TableViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        IOrder order = null;
        if (selectedElement instanceof IOrderEntry) {
            IOrderEntry entry = (IOrderEntry)selectedElement;
            order = entry.getOrder();
        } else if (selectedElement instanceof IOrder) {
            order = (IOrder)selectedElement;
        }
        if (order != null) {
            new HistoryDialog(UiDesk.getTopShell(), order).open();
        }
    }

    public void handleAddItem() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.LeistungenView");
            Display.getDefault().asyncExec(() -> {
                if (this.view.dropTarget == null) {
                    this.view.dropTarget = new GenericObjectDropTarget("ArtikelDropTarget", this.view.tableViewer.getControl(), new OrderDropReceiver(this.view, this.orderService));
                    CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.view.dropTarget);
                }
                this.view.dropTarget.registered(false);
            });
        }
        catch (Exception e) {
            logger.error("Error when dropping the article: ", (Throwable)e);
        }
    }

    public void handleCompletedOrderSelection(IOrder order) {
        if (order != null) {
            this.view.resetEditMode();
            this.view.setActOrder(order);
            this.view.setShowDeliveredColumn(true);
            this.view.refresh();
        }
    }

    private void handleEditItem() {
        IStructuredSelection selection = (IStructuredSelection)this.view.tableViewer.getSelection();
        IOrderEntry entry = (IOrderEntry)selection.getFirstElement();
        if (entry != null && entry.getState() == OrderEntryState.OPEN) {
            this.editOrderEntry(entry, false);
        }
    }

    private void editOrderEntry(IOrderEntry entry, boolean isDoubleClick) {
        int editableColumn = this.view.determineEditableColumn(entry);
        if (editableColumn != -1) {
            this.view.tableViewer.editElement((Object)entry, editableColumn);
        }
    }

    public void handleMouseWheelScroll(Event event, ScrolledComposite scrollComposite) {
        event.doit = false;
        int currentY = scrollComposite.getOrigin().y;
        int newY = currentY - event.count * 10;
        int maxY = Math.max(0, scrollComposite.getContent().getBounds().height - scrollComposite.getClientArea().height);
        scrollComposite.setOrigin(scrollComposite.getOrigin().x, Math.max(0, Math.min(newY, maxY)));
    }
}

