/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.OrderEntryState;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;

public final class OrderEntryComparators {
    private static final Collator COLLATOR = Collator.getInstance(Locale.getDefault());

    static {
        COLLATOR.setStrength(0);
    }

    private OrderEntryComparators() {
    }

    public static Comparator<IOrderEntry> forColumn(int columnIndex, int direction) {
        Comparator<IOrderEntry> base = switch (columnIndex) {
            case 1 -> OrderEntryComparators.byStatus();
            case 2 -> Comparator.comparingInt(IOrderEntry::getAmount);
            case 3 -> Comparator.comparingInt(IOrderEntry::getDelivered);
            case 4 -> (a, b) -> 0;
            case 5 -> OrderEntryComparators.comparingString(e -> {
                IArticle a = e.getArticle();
                return a != null ? OrderEntryComparators.nvl(a.getLabel()) : "";
            });
            case 6 -> OrderEntryComparators.comparingString(e -> {
                IContact c = e.getProvider();
                return c != null ? OrderEntryComparators.nvl(c.getLabel()) : "";
            });
            case 7 -> OrderEntryComparators.comparingString(e -> {
                IStock s = e.getStock();
                return s != null ? OrderEntryComparators.nvl(s.getLabel()) : "";
            });
            default -> (a, b) -> 0;
        };
        return direction == 1024 ? base.reversed() : base;
    }

    private static Comparator<IOrderEntry> byStatus() {
        return Comparator.comparingInt(e -> {
            OrderEntryState s = e.getState();
            if (s == null) {
                return 99;
            }
            return switch (s) {
                case OrderEntryState.OPEN -> 0;
                case OrderEntryState.ORDERED -> 1;
                case OrderEntryState.PARTIAL_DELIVER -> 2;
                case OrderEntryState.DONE -> 3;
                default -> 99;
            };
        });
    }

    private static Comparator<IOrderEntry> comparingString(Function<IOrderEntry, String> f) {
        return (a, b) -> COLLATOR.compare(OrderEntryComparators.nvl((String)f.apply((IOrderEntry)a)), OrderEntryComparators.nvl((String)f.apply((IOrderEntry)b)));
    }

    private static String nvl(String s) {
        return s == null ? "" : s;
    }
}

