/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class Importer
extends TitleAreaDialog {
    private CTabFolder ctab;
    private String ext;

    public Importer(Shell parentShell, String extension) {
        super(parentShell);
        this.ext = extension;
    }

    protected Control createDialogArea(Composite parent) {
        this.ctab = new CTabFolder(parent, 1024);
        List extensions = Extensions.getExtensions((String)this.ext, null);
        List importers = Extensions.getClasses((List)extensions, (String)"Class", (boolean)false);
        for (ImporterPage p : importers) {
            List<String> importTypes;
            boolean allImportRightsOk;
            if (p == null || !(allImportRightsOk = (importTypes = p.getObjectClass()).stream().map(type -> AccessControlServiceHolder.get().evaluate((EvaluatableACE)new ObjectEvaluatableACE(type, Right.IMPORT))).allMatch(n -> n))) continue;
            CTabItem item = new CTabItem(this.ctab, 0);
            item.setText(p.getTitle());
            item.setControl((Control)p.createPage((Composite)this.ctab));
            item.setData((Object)p);
        }
        this.ctab.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem top = Importer.this.ctab.getSelection();
                if (top != null) {
                    ImporterPage p = (ImporterPage)top.getData();
                    Importer.this.setMessage(p.getDescription());
                    top.getControl().setFocus();
                }
            }
        });
        return this.ctab;
    }

    protected void okPressed() {
        CTabItem top = this.ctab.getSelection();
        if (top != null) {
            ImporterPage page = (ImporterPage)top.getData();
            page.collect();
            page.run(false);
        }
        super.okPressed();
    }

    public void setFocusedTab(String title) {
        CTabItem[] cTabItemArray = this.ctab.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray[n2];
            if (cTabItem.getText().equals(title)) {
                this.ctab.setSelection(cTabItem);
            }
            ++n2;
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

