/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.data.Patient;
import ch.rgw.io.FileTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GenericDocument
implements IOpaqueDocument {
    String title;
    String category;
    byte[] contents;
    String date;
    Patient pat;
    String keywords;
    String mimetype;
    String guid = ElexisIdGenerator.generateId();

    public GenericDocument(Patient pat, String title, String category, File file, String date, String keywords, String mimetype) throws IOException {
        this.title = title;
        this.category = category;
        this.date = date;
        this.pat = pat;
        this.keywords = keywords;
        this.mimetype = mimetype == null ? file.getName() : mimetype;
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileTool.copyStreams((InputStream)fis, (OutputStream)baos);
        fis.close();
        this.contents = baos.toByteArray();
        baos.close();
    }

    public GenericDocument(Patient pat, String title, String category, byte[] content, String date, String keywords, String mimetype) throws IOException {
        this.title = title;
        this.category = category;
        this.date = date;
        this.pat = pat;
        this.keywords = keywords;
        this.mimetype = mimetype;
        this.contents = new byte[content.length];
        System.arraycopy(content, 0, this.contents, 0, content.length);
    }

    public String getTitle() {
        return this.title;
    }

    public String getMimeType() {
        return this.mimetype == null ? "binary/octet-stream" : this.mimetype;
    }

    public InputStream getContentsAsStream() throws ElexisException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.contents);
        return bais;
    }

    public byte[] getContentsAsBytes() throws ElexisException {
        return this.contents;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCreationDate() {
        return this.date;
    }

    public Patient getPatient() {
        return this.pat;
    }

    public String getGUID() {
        return this.guid;
    }
}

