/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.selectors;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.selectors.ActiveControlListener;
import ch.elexis.core.ui.selectors.Messages;
import ch.rgw.tools.LimitSizeStack;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class SelectorPanel
extends Composite
implements ActiveControlListener {
    boolean bCeaseFire;
    boolean bExclusive;
    private LinkedList<ActiveControlListener> listeners = new LinkedList();
    private ArrayList<ActiveControl> activeControls = new ArrayList();
    private LimitSizeStack<TraceElement> undoList = new LimitSizeStack(50);
    private Composite cFields;
    private ToolBarManager tActions;
    private ToolBar tb;
    private IAction aClr;
    private IAction autoSearchActivatedAction;
    private IAction performSearchAction;
    private boolean autoSearchActivated = true;

    public SelectorPanel(Composite parent, IAction ... actions) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
        FormLayout layout = new FormLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.setLayout((Layout)layout);
        this.tActions = new ToolBarManager(8388928);
        this.aClr = new Action(Messages.SelectorPanel_clearFields){
            {
                this.setImageDescriptor(Images.IMG_CLEAR.getImageDescriptor());
            }

            public void run() {
                SelectorPanel.this.clearValues();
            }
        };
        this.tActions.add(this.aClr);
        this.autoSearchActivatedAction = new Action(Messages.SelectorPanel_automaticSearch, 2){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                boolean bl = SelectorPanel.this.autoSearchActivated = !SelectorPanel.this.autoSearchActivated;
                if (SelectorPanel.this.autoSearchActivated) {
                    SelectorPanel.this.contentsChanged(null);
                }
                super.run();
            }
        };
        this.autoSearchActivatedAction.setToolTipText(Messages.SelectorPanel_activateAutomaticSearch);
        this.autoSearchActivatedAction.setChecked(this.autoSearchActivated);
        this.tActions.add(this.autoSearchActivatedAction);
        this.performSearchAction = new Action(Messages.SelectorPanel_performSearch){
            {
                this.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
            }

            public void run() {
                boolean oldState = SelectorPanel.this.autoSearchActivated;
                SelectorPanel.this.autoSearchActivated = true;
                SelectorPanel.this.contentsChanged(null);
                SelectorPanel.this.autoSearchActivated = oldState;
                super.run();
            }
        };
        this.performSearchAction.setToolTipText(Messages.SelectorPanel_performSearchTooltip);
        this.tActions.add(this.performSearchAction);
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction ac = iActionArray[n2];
            if (ac != null) {
                this.tActions.add(ac);
            } else {
                this.tActions.add((IContributionItem)new Separator());
            }
            ++n2;
        }
        this.tb = this.tActions.createControl((Composite)this);
        FormData fdActions = new FormData();
        fdActions.top = new FormAttachment(0, 0);
        fdActions.right = new FormAttachment(100, 0);
        this.tb.setLayoutData((Object)fdActions);
        this.cFields = new Composite((Composite)this, 0);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.cFields.setLayoutData((Object)fd);
        this.cFields.setLayout((Layout)new FillLayout());
        if (parent.getData("TEST_COMP_NAME") != null) {
            int idx = 0;
            while (idx < this.tb.getItemCount()) {
                this.tb.getItem(idx).setData("TEST_COMP_NAME", (Object)(String.valueOf(parent.getData("TEST_COMP_NAME")) + "_" + idx + "_tbi"));
                ++idx;
            }
        }
        this.pack();
    }

    public Composite getFieldParent() {
        return this.cFields;
    }

    public void setExclusive(boolean excl) {
        this.bExclusive = excl;
    }

    public void addActions(IAction ... actions) {
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction ac = iActionArray[n2];
            if (ac != null) {
                this.tActions.add(ac);
            } else {
                this.tActions.add((IContributionItem)new Separator());
            }
            ++n2;
        }
        this.tActions.update(true);
    }

    public void addField(ActiveControl ac) {
        this.activeControls.add(ac);
        ac.addListener(this);
    }

    public void addFields(ActiveControl ... newControls) {
        ActiveControl last = null;
        ActiveControl[] activeControlArray = newControls;
        int n = newControls.length;
        int n2 = 0;
        while (n2 < n) {
            ActiveControl ac = activeControlArray[n2];
            this.activeControls.add(ac);
            ac.addListener(this);
            last = ac;
            ++n2;
        }
        if (this.tb.isReparentable() && last != null) {
            Composite ctl = last.getControllerComposite();
            ctl.setLayout((Layout)new FormLayout());
            this.tb.setParent(ctl);
        }
        this.layout();
    }

    public void removeField(String field) {
        Control[] controlArray = this.cFields.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof ActiveControl && ((ActiveControl)c).getLabelText().equalsIgnoreCase(field)) {
                ((ActiveControl)c).removeSelectorListener(this);
                this.activeControls.remove(c);
                c.dispose();
            }
            ++n2;
        }
    }

    public void clearValues() {
        this.bCeaseFire = true;
        for (ActiveControl ac : this.activeControls) {
            ac.clear();
        }
        this.bCeaseFire = false;
        this.contentsChanged(null);
    }

    public HashMap<String, String> getValues() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (ActiveControl ac : this.activeControls) {
            ret.put(ac.getLabelText(), ac.getText());
            String fld = ac.getProperty("fieldName");
            if (StringTool.isNothing((Object)fld)) continue;
            ret.put(fld, ac.getText());
        }
        return ret;
    }

    public List<ActiveControl> getControls() {
        return this.activeControls;
    }

    @Override
    public void contentsChanged(ActiveControl field) {
        if (!this.autoSearchActivated) {
            return;
        }
        if (!this.bCeaseFire) {
            this.bCeaseFire = true;
            if (this.bExclusive && field != null) {
                String fieldLabel = field.getLabelText();
                for (ActiveControl ac : this.activeControls) {
                    String t;
                    if (ac.getLabelText().equals(fieldLabel) || (t = ac.getText()).length() <= 0) continue;
                    new TraceElement(ac);
                    ac.clear();
                }
            }
            int l = 0;
            if (field != null) {
                new TraceElement(field);
                l = field.getText().length();
            }
            if (l != 1) {
                for (ActiveControlListener lis : this.listeners) {
                    lis.contentsChanged(field);
                }
            }
            this.bCeaseFire = false;
        }
    }

    public void addSelectorListener(ActiveControlListener l) {
        this.listeners.add(l);
    }

    public void removeSelectorListener(ActiveControlListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void titleClicked(ActiveControl field) {
        if (!this.bCeaseFire) {
            this.bCeaseFire = true;
            for (ActiveControlListener lis : this.listeners) {
                lis.titleClicked(field);
            }
            this.bCeaseFire = true;
        }
    }

    @Override
    public void invalidContents(ActiveControl field) {
        this.aClr.setImageDescriptor(Images.IMG_ACHTUNG.getImageDescriptor());
        this.aClr.setToolTipText((String)field.getData("invalidContents"));
    }

    public void setLock(boolean bLocked) {
        for (ActiveControl ac : this.activeControls) {
            ac.setEnabled(bLocked);
        }
    }

    private class TraceElement {
        ActiveControl control;
        String value;

        TraceElement(ActiveControl ac) {
            this.control = ac;
            this.value = ac.getText();
            SelectorPanel.this.undoList.push((Object)this);
        }
    }
}

