/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.propertypage;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Country;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.propertypage.CountryComboLabelProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PatientAddressPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IUnlockable {
    private IPatient pat;
    private Text textStrasse;
    private Text textPostleitzahl;
    private Text textOrtschaft;
    private TableComboViewer countryComboViewer;

    protected Control createContents(Composite parent) {
        this.init();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(comp, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("Strasse");
        this.textStrasse = new Text(comp, 2048);
        this.textStrasse.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textStrasse.setTextLimit(80);
        Label lblPostleitzahl = new Label(comp, 0);
        lblPostleitzahl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPostleitzahl.setText("Postleitzahl");
        this.textPostleitzahl = new Text(comp, 2048);
        this.textPostleitzahl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textPostleitzahl.setTextLimit(6);
        Label lblOrtschaft = new Label(comp, 0);
        lblOrtschaft.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOrtschaft.setText("Ortschaft");
        this.textOrtschaft = new Text(comp, 2048);
        this.textOrtschaft.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textOrtschaft.setTextLimit(50);
        Label lblLand = new Label(comp, 0);
        lblLand.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLand.setText("Land");
        this.countryComboViewer = new TableComboViewer(comp);
        TableCombo tableCombo = this.countryComboViewer.getTableCombo();
        tableCombo.setTableWidthPercentage(90);
        tableCombo.setShowFontWithinSelection(false);
        tableCombo.setShowColorWithinSelection(false);
        tableCombo.setShowTableLines(false);
        tableCombo.setShowTableHeader(false);
        tableCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.countryComboViewer.setLabelProvider((IBaseLabelProvider)new CountryComboLabelProvider());
        this.countryComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Country[] items = new Country[]{Country.CH, Country.LI, Country.AT, Country.DE, Country.FR, Country.IT};
        this.countryComboViewer.setInput((Object)items);
        super.setTitle(this.pat.getLabel());
        this.textStrasse.setText(this.pat.getStreet());
        this.textPostleitzahl.setText(this.pat.getZip());
        this.textOrtschaft.setText(this.pat.getCity());
        this.countryComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.pat.getCountry()));
        this.setUnlocked(LocalLockServiceHolder.get().isLocked((Object)this.pat));
        return comp;
    }

    private void init() {
        IAdaptable adapt = this.getElement();
        this.pat = (IPatient)adapt.getAdapter(IPatient.class);
    }

    protected void performApply() {
        this.pat.setStreet(this.textStrasse.getText());
        StructuredSelection countrySel = (StructuredSelection)this.countryComboViewer.getSelection();
        if (!countrySel.isEmpty()) {
            this.pat.setCountry((Country)countrySel.getFirstElement());
        }
        this.pat.setZip(this.textPostleitzahl.getText());
        this.pat.setCity(this.textOrtschaft.getText());
        CoreModelServiceHolder.get().save((Identifiable)this.pat);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.textStrasse.setEditable(unlocked);
        this.textPostleitzahl.setEditable(unlocked);
        this.textOrtschaft.setEditable(unlocked);
        this.countryComboViewer.getControl().setEnabled(unlocked);
    }
}

