/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.ui.locks.LockResponseHelper;
import org.eclipse.jface.action.Action;

public abstract class LockRequestingAction<T>
extends Action {
    private T object;

    public LockRequestingAction(String text) {
        this(text, 0);
    }

    public LockRequestingAction(String text, int style) {
        super(text, style);
        this.setEnabled(true);
    }

    public void run() {
        this.object = this.getTargetedObject();
        if (this.object == null) {
            return;
        }
        LockResponse lr = LocalLockServiceHolder.get().acquireLock(this.object);
        if (lr.isOk()) {
            this.doRun(this.object);
            LocalLockServiceHolder.get().releaseLock(this.object);
        } else {
            LockResponseHelper.showInfo(lr, this.object, null);
        }
    }

    public abstract T getTargetedObject();

    public abstract void doRun(T var1);
}

