/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class KonsFilterDialog
extends TitleAreaDialog {
    KonsFilter filter;
    IPatient pat;
    Combo cbFaelle;
    ICoverage[] faelle;
    Text tBed;
    Button bCase;
    Button bRegex;

    public KonsFilterDialog(IPatient p, KonsFilter kf) {
        super(UiDesk.getTopShell());
        this.filter = kf;
        this.pat = p;
    }

    @Deprecated
    public KonsFilterDialog(Patient p, KonsFilter kf) {
        super(UiDesk.getTopShell());
        this.filter = kf;
        this.pat = CoreModelServiceHolder.get().load(p.getId(), IPatient.class).orElse(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        new Label(ret, 0).setText(Messages.KonsFilterDialog_onlyForCase);
        this.cbFaelle = new Combo(ret, 4);
        this.cbFaelle.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.faelle = this.pat.getCoverages().toArray(new ICoverage[0]);
        this.cbFaelle.add(Messages.KonsFilterDialog_dontMind);
        ICoverage[] iCoverageArray = this.faelle;
        int n = this.faelle.length;
        int n2 = 0;
        while (n2 < n) {
            ICoverage f = iCoverageArray[n2];
            this.cbFaelle.add(f.getLabel());
            ++n2;
        }
        new Label(ret, 258);
        new Label(ret, 64).setText(Messages.KonsFilterDialog_enterWords + Messages.KonsFilterDialog_separateFilters);
        this.tBed = SWTHelper.createText(ret, 4, 2048);
        new Label(ret, 258);
        this.bCase = new Button(ret, 32);
        this.bCase.setText(Messages.KonsFilterDialog_respectCase);
        this.bRegex = new Button(ret, 32);
        this.bRegex.setText(Messages.KonsFilterDialog_regExp);
        this.cbFaelle.select(0);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.KonsFilterDialog_konsFilter);
        this.setMessage(Messages.KonsFilterDialog_enterFilterExpressions);
        this.getShell().setText(Messages.Core_Filter);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        this.filter = new KonsFilter();
        if (this.cbFaelle.getSelectionIndex() > 0) {
            ICoverage f = this.faelle[this.cbFaelle.getSelectionIndex() - 1];
            this.filter.setFall(f);
        }
        this.filter.setCaseSensitive(this.bCase.getSelection());
        this.filter.setAsRegEx(this.bRegex.getSelection());
        String cc = this.tBed.getText();
        if (!StringTool.isNothing((Object)cc)) {
            StringTool.tokenizer tk = new StringTool.tokenizer(cc, " ", 1);
            try {
                List tokens = tk.tokenize();
                int last = 0;
                for (String t : tokens) {
                    if (t.equals("OR")) {
                        last = 2;
                        continue;
                    }
                    if (t.equals("AND")) {
                        last = 1;
                        continue;
                    }
                    if (t.equals("NOT")) {
                        last |= 4;
                        continue;
                    }
                    this.filter.addConstraint(last, t);
                }
            }
            catch (IOException e) {
                ExHandler.handle((Throwable)e);
            }
        }
        super.okPressed();
    }

    public KonsFilter getResult() {
        return this.filter;
    }

    protected boolean isResizable() {
        return true;
    }
}

