/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.Money;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EigenLeistungDialog
extends TitleAreaDialog {
    Text tTarif;
    Text tName;
    Text tKurz;
    Text tEK;
    Text tVK;
    Text tTime;
    private ICustomService result;
    private boolean create;

    public EigenLeistungDialog(Shell shell, ICustomService lstg) {
        super(shell);
        if (lstg == null) {
            this.create = true;
            this.result = (ICustomService)CoreModelServiceHolder.get().create(ICustomService.class);
        } else {
            this.create = false;
            this.result = lstg;
        }
    }

    public void create() {
        super.create();
        if (this.create) {
            this.setTitle(Messages.BlockDetailDisplay_defineServiceCaption);
            this.setMessage(Messages.BlockDetailDisplay_defineServiceBody);
        } else {
            this.setTitle(Messages.BlockDetailDisplay_editServiceCaption);
            this.setMessage(Messages.BlockDetailDisplay_editServiceBody);
        }
        this.getShell().setText(Messages.BlockDetailDisplay_SerlfDefinedService);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_ret");
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(2, false));
        new Label(ret, 0).setText(Messages.Service_Tarif);
        this.tTarif = new Text(ret, 2048);
        this.tTarif.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tTarif");
        this.tTarif.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.Core_Short_Label);
        this.tKurz = new Text(ret, 2048);
        this.tKurz.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tKurz");
        this.tKurz.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.Core_Name);
        this.tName = new Text(ret, 2048);
        this.tName.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tName");
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.BlockDetailDisplay_costInCents);
        this.tEK = new Text(ret, 2048);
        this.tEK.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tEK");
        this.tEK.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.BlockDetailDisplay_priceInCents);
        this.tVK = new Text(ret, 2048);
        this.tVK.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tVK");
        this.tVK.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.BlockDetailDisplay_timeInMinutes);
        this.tTime = new Text(ret, 2048);
        this.tTime.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tTime");
        this.tTime.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        if (!this.create) {
            this.tTarif.setText(this.result.getCodeSystemCode());
            this.tName.setText(this.result.getText());
            this.tKurz.setText(this.result.getCode());
            this.tEK.setText(this.result.getNetPrice().getCentsAsString());
            this.tVK.setText(this.result.getPrice().getCentsAsString());
            this.tTime.setText(Integer.toString(this.result.getMinutes()));
        }
        return ret;
    }

    public ICustomService getResult() {
        return this.result;
    }

    protected void okPressed() {
        if (StringUtils.isBlank((CharSequence)this.tName.getText()) && StringUtils.isBlank((CharSequence)this.tKurz.getText())) {
            this.setMessage(Messages.Inputfield_empty, 3);
            return;
        }
        Money moneyNet = new Money();
        if (StringUtils.isNotBlank((CharSequence)this.tEK.getText())) {
            try {
                int cents = Integer.parseInt(this.tEK.getText());
                moneyNet = new Money(cents);
            }
            catch (Exception cents) {
                // empty catch block
            }
        }
        Money moneyPrice = new Money();
        if (StringUtils.isNotBlank((CharSequence)this.tVK.getText())) {
            try {
                int cents = Integer.parseInt(this.tVK.getText());
                moneyPrice = new Money(cents);
            }
            catch (Exception cents) {
                // empty catch block
            }
        }
        int time = 0;
        if (StringUtils.isNotBlank((CharSequence)this.tTime.getText())) {
            try {
                time = Integer.parseInt(this.tTime.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.result.setCodeSystemCode(this.tTarif.getText());
        this.result.setCode(this.tKurz.getText());
        this.result.setText(this.tName.getText());
        this.result.setNetPrice(moneyNet);
        this.result.setPrice(moneyPrice);
        this.result.setMinutes(time);
        CoreModelServiceHolder.get().save((Identifiable)this.result);
        super.okPressed();
    }
}

