/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.service.CodeElementServiceHolder;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IXid;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.ui.dialogs.Messages;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class DiagnoseSelektor
extends FilteredItemsSelectionDialog {
    private List<IDiagnosis> diagnoses = new ArrayList<IDiagnosis>();

    public DiagnoseSelektor(Shell shell) {
        super(shell);
        this.setTitle(Messages.DiagnoseSelektorDialog_Title);
        this.diagnoses.add(new NoDiagnose());
        List diagnoseContributions = CodeElementServiceHolder.get().getContributionsByTyp(ICodeElementService.CodeElementTyp.DIAGNOSE);
        for (ICodeElementServiceContribution iCodeElementServiceContribution : diagnoseContributions) {
            this.diagnoses.addAll(iCodeElementServiceContribution.getElements((Map)CodeElementServiceHolder.createContext()));
        }
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return ((IDiagnosis)element).getLabel();
            }
        });
        this.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return ((IDiagnosis)element).getCodeSystemName() + " " + ((IDiagnosis)element).getLabel();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        String oldListLabel = WorkbenchMessages.FilteredItemsSelectionDialog_listLabel;
        this.setMessage(Messages.DiagnoseSelektorDialog_Message);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = "";
        Control ret = super.createDialogArea(parent);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = oldListLabel;
        return ret;
    }

    private void addDiagnoses(ITreeContentProvider tcp, Object[] roots) {
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (tcp.hasChildren(object)) {
                this.addDiagnoses(tcp, tcp.getChildren(object));
            } else {
                this.diagnoses.add((IDiagnosis)object);
            }
            ++n2;
        }
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("diagnoseselektor");
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                IDiagnosis diag = (IDiagnosis)item;
                return this.matches(diag.getLabel());
            }
        };
    }

    protected Comparator<IDiagnosis> getItemsComparator() {
        return new Comparator<IDiagnosis>(){

            @Override
            public int compare(IDiagnosis o1, IDiagnosis o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (IDiagnosis diagnose : this.diagnoses) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            contentProvider.add((Object)diagnose, itemsFilter);
        }
    }

    public String getElementName(Object item) {
        IDiagnosis diag = (IDiagnosis)item;
        return diag.getLabel();
    }

    private class NoDiagnose
    implements IDiagnosis {
        private NoDiagnose() {
        }

        public String getCodeSystemName() {
            return "";
        }

        public String getCodeSystemCode() {
            return "";
        }

        public String getId() {
            return "";
        }

        public String getCode() {
            return "";
        }

        public String getText() {
            return " keine ";
        }

        public String getLabel() {
            return this.getText();
        }

        public void setCode(String value) {
        }

        public void setText(String value) {
        }

        public boolean addXid(String domain, String id, boolean updateIfExists) {
            return false;
        }

        public IXid getXid(String domain) {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String value) {
        }

        public Long getLastupdate() {
            return null;
        }
    }
}

