/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class PrintMedicationHistoryHandler
extends AbstractHandler
implements IHandler {
    private static final String TOOPEN = " ... ";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        try {
            progress.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("PDF erzeugen", -1);
                    Optional<MedicationHistoryLetter> letter = PrintMedicationHistoryHandler.this.getToPrint();
                    if (letter.isPresent()) {
                        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                        ServiceReference serviceRef = bundleContext.getServiceReference(IFormattedOutputFactory.class);
                        if (serviceRef != null) {
                            File file;
                            block18: {
                                IFormattedOutputFactory service = (IFormattedOutputFactory)bundleContext.getService(serviceRef);
                                IFormattedOutput outputter = service.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.JAXB, IFormattedOutputFactory.OutputType.PDF);
                                ByteArrayOutputStream pdf = new ByteArrayOutputStream();
                                HashMap<String, String> parameters = new HashMap<String, String>();
                                parameters.put("current-date", LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
                                outputter.transform((Object)letter.get(), this.getClass().getResourceAsStream("/rsc/xslt/medhistory2fo.xslt"), (OutputStream)pdf, parameters);
                                bundleContext.ungetService(serviceRef);
                                file = null;
                                FileOutputStream fout = null;
                                try {
                                    try {
                                        file = File.createTempFile("medhistory_", ".pdf");
                                        fout = new FileOutputStream(file);
                                        fout.write(pdf.toByteArray());
                                    }
                                    catch (IOException e) {
                                        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)("Fehler beim PDF anlegen.\n" + e.getMessage())));
                                        LoggerFactory.getLogger(this.getClass()).error("Error creating PDF", (Throwable)e);
                                        if (fout != null) {
                                            try {
                                                fout.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block18;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (fout != null) {
                                        try {
                                            fout.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                if (fout != null) {
                                    try {
                                        fout.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (file != null) {
                                Program.launch((String)file.getAbsolutePath());
                            }
                        }
                    } else {
                        Display.getDefault().syncExec(() -> MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Info", (String)"Kein Patient ausgew\u00e4hlt, oder Patient hat keine Medikation.\n"));
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)("Fehler beim PDF erzeugen.\n" + e.getMessage()));
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating PDF", (Throwable)e);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.isFopServiceAvailable();
    }

    private boolean isFopServiceAvailable() {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        return bundleContext.getServiceReference(IFormattedOutputFactory.class) != null;
    }

    public Optional<MedicationHistoryLetter> getToPrint() {
        IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
        if (patient != null) {
            Query qbe = new Query(Prescription.class);
            qbe.add("PatientID", "=", patient.getId());
            List list = qbe.execute();
            if (!list.isEmpty()) {
                return Optional.of(MedicationHistoryLetter.of((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient, Patient.class), list));
            }
        }
        return Optional.empty();
    }

    @XmlRootElement(name="historyitem")
    private static class MedicationHistoryItem
    implements Comparable<MedicationHistoryItem> {
        @XmlTransient
        private TimeTool fromTool;
        @XmlElement
        private String from;
        @XmlElement
        private String to;
        @XmlElement
        private String article;
        @XmlElement
        private String dosage;

        private MedicationHistoryItem() {
        }

        public MedicationHistoryItem(String from, String to, Prescription p) {
            this.from = from;
            this.fromTool = new TimeTool(from);
            this.to = to;
            if (PrintMedicationHistoryHandler.TOOPEN.equals(to) && StringUtils.isNotBlank((CharSequence)p.getEndDate())) {
                this.to = p.getEndDate();
            }
            this.article = p.getArtikel() != null ? p.getArtikel().getLabel() : "?";
            this.dosage = p.getDosis();
        }

        @Override
        public int compareTo(MedicationHistoryItem other) {
            return other.fromTool.compareTo((Calendar)this.fromTool);
        }
    }

    @XmlRootElement(name="medicationhistory")
    private static class MedicationHistoryLetter {
        private List<MedicationHistoryItem> history;
        @XmlElement
        private String patientName;
        @XmlElement
        private String patientDob;

        private MedicationHistoryLetter() {
        }

        private MedicationHistoryLetter(Patient patient) {
            this.patientName = patient.getLabel(true);
            this.patientDob = patient.getGeburtsdatum();
            this.history = new ArrayList<MedicationHistoryItem>();
        }

        public void setHistory(List<MedicationHistoryItem> history) {
            this.history = history;
        }

        public List<MedicationHistoryItem> getHistory() {
            return this.history;
        }

        public static MedicationHistoryLetter of(Patient patient, List<Prescription> list) {
            MedicationHistoryLetter ret = new MedicationHistoryLetter(patient);
            for (Prescription prescription : list) {
                if (prescription.getEntryType() == EntryType.RECIPE) continue;
                SortedMap terms = prescription.getTerms();
                TimeTool[] tts = terms.keySet().toArray(new TimeTool[0]);
                int i = 0;
                while (i < tts.length - 1) {
                    if (i < tts.length - 1) {
                        ret.history.add(new MedicationHistoryItem(tts[i].toString(4), tts[i + 1].toString(4), prescription));
                    } else {
                        ret.history.add(new MedicationHistoryItem(tts[i].toString(4), PrintMedicationHistoryHandler.TOOPEN, prescription));
                    }
                    ++i;
                }
                ret.history.add(new MedicationHistoryItem(tts[tts.length - 1].toString(4), PrintMedicationHistoryHandler.TOOPEN, prescription));
            }
            Collections.sort(ret.history);
            return ret;
        }
    }
}

