/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.dialogs.EtiketteDruckenDialog;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;

public final class PrintContactLabelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IContact kontakt = ContextServiceHolder.get().getTyped(IContact.class).orElse(null);
        if (kontakt == null) {
            SWTHelper.showInfo("Kein Kontakt ausgew\u00e4hlt", "Bitte w\u00e4hlen Sie vor dem Drucken einen Kontakt!");
            return null;
        }
        EtiketteDruckenDialog dlg = new EtiketteDruckenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Kontakt)NoPoUtil.loadAsPersistentObject((Identifiable)kontakt, Kontakt.class), "AdressEtikette");
        dlg.setTitle(Messages.Print_AddressLabel);
        dlg.setMessage(Messages.GlobalActions_PrintContactLabelToolTip);
        if (!LocalConfigService.get((String)"Drucker/Etiketten/Choose", (boolean)true)) {
            dlg.setBlockOnOpen(false);
            dlg.open();
            if (dlg.doPrint()) {
                dlg.close();
            } else {
                SWTHelper.alert("Fehler beim Drucken", "Beim Drucken ist ein Fehler aufgetreten. Bitte \u00fcberpr\u00fcfen Sie die Einstellungen.");
            }
        } else {
            dlg.setBlockOnOpen(true);
            dlg.open();
        }
        return null;
    }
}

