/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.core.ui.views.rechnung.BillingProposalView;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class PrintBillingProposalHandler
extends AbstractHandler
implements IHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final BillingProposalView view = this.getOpenView(event);
        if (view != null) {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            try {
                progress.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("PDF erzeugen", -1);
                        BillingProposalView.ProposalLetter letter = view.getToPrint();
                        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                        ServiceReference serviceRef = bundleContext.getServiceReference(IFormattedOutputFactory.class);
                        if (serviceRef != null) {
                            File file;
                            block16: {
                                IFormattedOutputFactory service = (IFormattedOutputFactory)bundleContext.getService(serviceRef);
                                IFormattedOutput outputter = service.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.JAXB, IFormattedOutputFactory.OutputType.PDF);
                                ByteArrayOutputStream pdf = new ByteArrayOutputStream();
                                HashMap<String, String> parameters = new HashMap<String, String>();
                                parameters.put("current-date", LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
                                outputter.transform((Object)letter, this.getClass().getResourceAsStream("/rsc/xslt/proposal2fo.xslt"), (OutputStream)pdf, parameters);
                                bundleContext.ungetService(serviceRef);
                                file = null;
                                FileOutputStream fout = null;
                                try {
                                    try {
                                        file = File.createTempFile("proposal_", ".pdf");
                                        fout = new FileOutputStream(file);
                                        fout.write(pdf.toByteArray());
                                    }
                                    catch (IOException e) {
                                        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)("Fehler beim PDF anlegen.\n" + e.getMessage())));
                                        LoggerFactory.getLogger(this.getClass()).error("Error creating PDF", (Throwable)e);
                                        if (fout != null) {
                                            try {
                                                fout.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block16;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (fout != null) {
                                        try {
                                            fout.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                if (fout != null) {
                                    try {
                                        fout.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (file != null) {
                                Program.launch((String)file.getAbsolutePath());
                            }
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)("Fehler beim PDF erzeugen.\n" + e.getMessage()));
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating PDF", (Throwable)e);
            }
        }
        return null;
    }

    private BillingProposalView getOpenView(ExecutionEvent event) {
        try {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPage page = window.getActivePage();
            return (BillingProposalView)page.showView("ch.elexis.core.ui.views.rechnung.BillingProposalView");
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Konnte Rechnungs-Vorschlag View nicht \u00f6ffnen");
            return null;
        }
    }

    public boolean isEnabled() {
        return this.isFopServiceAvailable();
    }

    private boolean isFopServiceAvailable() {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        return bundleContext.getServiceReference(IFormattedOutputFactory.class) != null;
    }
}

