/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.views.rechnung.BillingProposalView;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.Result;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.LoggerFactory;

public class BillingProposalViewCreateBillsHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Konsultation> toBill = this.getToBill(event);
        Map sortedByYears = BillingUtil.getSortedByYear(toBill);
        if (!BillingUtil.canBillYears(new ArrayList(sortedByYears.keySet()))) {
            StringJoiner sj = new StringJoiner(", ");
            sortedByYears.keySet().forEach(i -> {
                StringJoiner stringJoiner2 = sj.add(Integer.toString(i));
            });
            if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Rechnung Validierung", (String)("Die Leistungen sind aus Jahren die nicht kombinierbar sind.\n\nWollen Sie separate Rechnungen f\u00fcr die Jahre " + sj.toString() + " erstellen?"))) {
                for (Integer year : sortedByYears.keySet()) {
                    this.createBill((List)sortedByYears.get(year));
                }
            }
        } else if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.Core_Create_Invoices, (String)Messages.KonsZumVerrechnenView2_createInvoicesMessageDialogQuestion)) {
            this.createBill(toBill);
        }
        return null;
    }

    private void createBill(final List<Konsultation> toBill) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            dialog.run(true, false, new IRunnableWithProgress(){
                private int successful = 0;
                private int errorneous = 0;
                private StringBuilder errorneousInfo = new StringBuilder();

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.Core_Create_Invoices, 3);
                    List billable = BillingUtil.filterNotBillable((List)toBill);
                    monitor.worked(1);
                    Map toBillMap = BillingUtil.getGroupedBillable((List)billable);
                    monitor.worked(1);
                    List results = BillingUtil.createBills((Map)toBillMap);
                    for (Result result : results) {
                        if (result.isOK()) {
                            ++this.successful;
                            continue;
                        }
                        this.errorneousInfo.append(result.getSeverity()).append(" -> ");
                        List messages = result.getMessages();
                        int i = 0;
                        while (i < messages.size()) {
                            if (i > 0) {
                                this.errorneousInfo.append(" / ");
                            }
                            this.errorneousInfo.append(((Result.msg)messages.get(i)).getText());
                            ++i;
                        }
                        this.errorneousInfo.append("\n");
                        ++this.errorneous;
                    }
                    monitor.worked(1);
                    monitor.done();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)MessageFormat.format("Es wurden {0} Rechnungen erfolgreich erstellt.\nBei {1} Rechnungen traten Fehler auf.\n{2}", successful, errorneous, errorneousInfo.toString()));
                        }
                    });
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Fehler beim Ausf\u00fchren der Rechnungserstelltung. Details siehe Log.");
            LoggerFactory.getLogger(BillingProposalViewCreateBillsHandler.class).error("Error creating bills", (Throwable)e);
        }
    }

    private List<Konsultation> getToBill(ExecutionEvent event) {
        String selectionParameter = event.getParameter("ch.elexis.core.ui.BillingProposalViewCreateBills.selection");
        if ("selection".equals(selectionParameter)) {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection != null && !selection.isEmpty()) {
                List selectionList = ((IStructuredSelection)selection).toList();
                if (selectionList.get(0) instanceof Konsultation) {
                    return selectionList.stream().map(o -> (Konsultation)o).collect(Collectors.toList());
                }
                if (selectionList.get(0) instanceof BillingProposalView.BillingInformation) {
                    return selectionList.stream().map(o -> ((BillingProposalView.BillingInformation)o).getKonsultation()).collect(Collectors.toList());
                }
            }
        } else {
            BillingProposalView view = this.getOpenView(event);
            if (view != null) {
                return view.getToBill();
            }
        }
        return Collections.emptyList();
    }

    private BillingProposalView getOpenView(ExecutionEvent event) {
        try {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPage page = window.getActivePage();
            return (BillingProposalView)page.showView("ch.elexis.core.ui.views.rechnung.BillingProposalView");
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Konnte Rechnungs-Vorschlag View nicht \u00f6ffnen");
            return null;
        }
    }
}

