/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import org.eclipse.jface.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestrictedAction
extends Action {
    protected EvaluatableACE evaluatableAce;
    protected static Logger log = LoggerFactory.getLogger(RestrictedAction.class);

    public RestrictedAction(EvaluatableACE evaluatableAce) {
        this.evaluatableAce = evaluatableAce;
        this.reflectRight();
    }

    public RestrictedAction(EvaluatableACE evaluatableAce, String text) {
        super(text);
        this.evaluatableAce = evaluatableAce;
        this.reflectRight();
    }

    public RestrictedAction(EvaluatableACE evaluatableAce, String text, int style) {
        super(text, style);
        this.evaluatableAce = evaluatableAce;
        this.reflectRight();
    }

    public void reflectRight() {
        if (this.evaluatableAce != null) {
            this.setEnabled(AccessControlServiceHolder.get().evaluate(this.evaluatableAce));
        }
    }

    public final void run() {
        if (this.evaluatableAce != null && AccessControlServiceHolder.get().evaluate(this.evaluatableAce)) {
            this.doRun();
        }
    }

    public abstract void doRun();
}

