/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;

public abstract class PersistentObjectLoader
implements ViewerConfigurer.ICommonViewerContentProvider,
ViewerConfigurer.IWorker {
    public static final String PARAM_FIELDNAMES = "fieldnames";
    public static final String PARAM_VALUES = "fieldvalues";
    protected CommonViewer cv;
    protected Query<? extends PersistentObject> qbe;
    private final LinkedList<QueryFilter> queryFilters = new LinkedList();
    protected String[] orderFields;
    private boolean bSuspended;
    protected Job job;
    protected HashMap<String, Object> privdata = new HashMap();

    public PersistentObjectLoader(CommonViewer cv, Query<? extends PersistentObject> qbe) {
        this.cv = cv;
        this.qbe = qbe;
        this.job = new Job(Messages.Core_Load_Files_ellipsis){

            protected IStatus run(IProgressMonitor monitor) {
                return PersistentObjectLoader.this.work(monitor, PersistentObjectLoader.this.privdata);
            }
        };
    }

    public Query<? extends PersistentObject> getQuery() {
        return this.qbe;
    }

    @Override
    public void startListening() {
        this.cv.getConfigurer().getControlFieldProvider().addChangeListener(this);
    }

    @Override
    public void stopListening() {
        this.cv.getConfigurer().getControlFieldProvider().removeChangeListener(this);
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
        this.stopListening();
        if (this.job != null) {
            this.job.cancel();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.job.schedule(0L);
    }

    @Override
    public void changed(HashMap<String, String> values) {
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            if (cfp.isEmpty()) {
                this.cv.notify(CommonViewer.Message.empty);
            } else {
                this.cv.notify(CommonViewer.Message.notempty);
            }
        }
        this.setRuntimeData(PARAM_VALUES, values);
        this.job.schedule();
    }

    @Override
    public void reorder(String field) {
        this.setOrderFields(field);
        this.job.schedule();
    }

    @Override
    public void selected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryFilter(QueryFilter fp) {
        LinkedList<QueryFilter> linkedList = this.queryFilters;
        synchronized (linkedList) {
            this.queryFilters.add(fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueryFilter(QueryFilter fp) {
        LinkedList<QueryFilter> linkedList = this.queryFilters;
        synchronized (linkedList) {
            this.queryFilters.remove(fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyQueryFilters() {
        LinkedList<QueryFilter> linkedList = this.queryFilters;
        synchronized (linkedList) {
            for (QueryFilter fp : this.queryFilters) {
                fp.apply(this.qbe);
            }
        }
    }

    public void setOrderFields(String ... name) {
        this.orderFields = name;
    }

    public void setRuntimeData(String key, Object value) {
        this.privdata.put(key, value);
    }

    public Object getRuntimeData(String key) {
        return this.privdata.get(key);
    }

    public void setSuspended(boolean bSuspend) {
        this.bSuspended = bSuspend;
    }

    public boolean isSuspended() {
        return this.bSuspended;
    }

    @Override
    public void init() {
    }

    public static interface QueryFilter {
        public void apply(Query<? extends PersistentObject> var1);
    }
}

