/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;

public class LeistungenExport {
    private HashMap<String, patums> patienten = new HashMap();

    public String doExport(String from, String until, String toDir) {
        TimeTool ttFrom = new TimeTool();
        TimeTool ttUntil = new TimeTool();
        if (!ttFrom.set(from)) {
            return "Konnte Beginndatum nicht lesen: " + from;
        }
        if (!ttUntil.set(until)) {
            return "Konnte Enddatum nicht lesen: " + until;
        }
        try {
            int UUID2 = 0;
            int PatientID = 1;
            int FallID = 2;
            int KonsID = 3;
            int Datum = 4;
            int Mandant2 = 5;
            int CodeSystemName = 6;
            int CodeSystemCode = 7;
            int Code = 8;
            int Text2 = 9;
            int Kostentraeger = 10;
            int TarmedAL = 11;
            int TarmedTL = 12;
            int Physio = 13;
            int Labor2 = 14;
            int Medikament = 15;
            int Medical = 16;
            int Migel = 17;
            int kantonal = 18;
            int andere = 19;
            String[] cols = new String[]{"UUID", "PatientID", "FallID", "KonsID", "Datum", "Mandant", "CodesystemName", "CodesystemCode", "Code", "Text", "Kostentraeger", "TarmedAL", "TarmedTL", "Physio", "Labor", "Medikament", "Medical", "MiGEL", "Kantonal", "Andere"};
            File dir = new File(toDir);
            if (!dir.exists() || !dir.isDirectory()) {
                return String.valueOf(dir) + " nicht gefunden oder ist kein Verzeichnis.";
            }
            File outFile = new File(dir, "Verrechnungen.csv");
            FileWriter writer = new FileWriter(outFile);
            CSVWriter out = new CSVWriter(writer);
            out.writeNext(cols);
            Query qbe = new Query(Konsultation.class);
            qbe.add("Datum", ">=", ttFrom.toString(9));
            qbe.add("Datum", "<=", ttUntil.toString(9));
            for (Konsultation k : qbe.execute()) {
                Patient pat;
                Fall fall = k.getFall();
                if (fall != null && (pat = fall.getPatient()) != null) {
                    patums pu = this.patienten.get(pat.getId());
                    if (pu == null) {
                        pu = new patums();
                        pu.ID = pat.getId();
                        pu.anzahlKons = 0;
                        pu.costMedical = 0.0;
                        pu.costMedicament = 0.0;
                        pu.costOther = 0.0;
                        pu.costPerCons = 0.0;
                        pu.costPhysio = 0.0;
                        pu.costTarmedAL = 0.0;
                        pu.costTarmedTL = 0.0;
                        pu.costTotal = 0.0;
                        this.patienten.put(pat.getId(), pu);
                    }
                    pu.anzahlKons = pu.anzahlKons + 1;
                    IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                    Mandant m = k.getMandant();
                    if (m != null) {
                        for (IBilled v : encounter.getBilled()) {
                            String[] col = new String[cols.length];
                            int i = 0;
                            while (i < cols.length) {
                                col[i] = "";
                                ++i;
                            }
                            col[UUID2] = v.getId();
                            col[PatientID] = pat.getId();
                            col[FallID] = fall.getId();
                            col[KonsID] = k.getId();
                            col[Datum] = k.getDatum();
                            col[Mandant2] = m.getId();
                            IBillable vv = v.getBillable();
                            if (vv != null) {
                                col[CodeSystemName] = vv.getCodeSystemName();
                                col[CodeSystemCode] = vv.getCodeSystemCode();
                                col[Code] = vv.getCode();
                                col[Text2] = vv.getText();
                                int offset = andere;
                                if (vv.getCodeSystemName().equals("Tarmed")) {
                                    offset = TarmedAL;
                                } else if (vv.getCodeSystemName().equals("Laborleistung")) {
                                    offset = Labor2;
                                } else if (vv.getCodeSystemName().equals("Physiotherapie")) {
                                    offset = Physio;
                                } else if (vv.getCodeSystemName().equals("Medicals")) {
                                    offset = Medical;
                                } else if (vv.getCodeSystemName().startsWith("Medikament")) {
                                    offset = Medikament;
                                } else if (vv.getCodeSystemName().equals("MiGeL")) {
                                    offset = Migel;
                                }
                                col[offset] = v.getTotal().getAmountAsString();
                            }
                            out.writeNext(col);
                        }
                    }
                }
                out.close();
            }
            return "Ok. Die gew\u00fcnschten Dateien sind erstellt.";
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return "Exception: " + ex.getClass().getName() + "; " + ex.getMessage();
        }
    }

    class patums {
        String ID;
        TimeTool gebDat;
        String sex;
        TimeTool erstkons;
        TimeTool letztkons;
        Integer anzahlKons;
        Double costPerCons;
        Double costTotal;
        Double costTarmedAL;
        Double costTarmedTL;
        Double costMedicament;
        Double costMedical;
        Double costPhysio;
        Double costOther;

        patums() {
        }
    }
}

