/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.reminder.viewers;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.reminder.viewers.ReminderColumnType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ReminderColumnFactory {
    private final Font boldFont;

    public ReminderColumnFactory(Font boldFont) {
        this.boldFont = boldFont;
    }

    public void createColumns(TableViewer viewer, ReminderColumnType ... types) {
        String hiddenPref = ConfigServiceHolder.getUser((String)"usr/reminder/columns/hidden", (String)"");
        Set hiddenCols = Arrays.stream(hiddenPref.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        int index = 0;
        ReminderColumnType[] reminderColumnTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ReminderColumnType type = reminderColumnTypeArray[n2];
            String header = type.getTitle();
            if (!hiddenCols.contains(header)) {
                TableViewerColumn col = switch (type) {
                    case ReminderColumnType.TYPE -> this.createTypeColumn(viewer, index);
                    case ReminderColumnType.DATE -> this.createDateColumn(viewer, index);
                    case ReminderColumnType.RESPONSIBLE -> this.createResponsibleColumn(viewer, index);
                    case ReminderColumnType.STATUS -> this.createStatusColumn(viewer, index);
                    case ReminderColumnType.PATIENT -> this.createPatientColumn(viewer, index);
                    case ReminderColumnType.DESCRIPTION -> this.createDescriptionColumn(viewer, index);
                    default -> throw new MatchException(null, null);
                };
                TableColumn column = col.getColumn();
                column.setResizable(true);
                column.setMoveable(true);
                column.setData("hidden", (Object)false);
                ++index;
            }
            ++n2;
        }
        viewer.getTable().addListener(11, e -> {
            Table table = viewer.getTable();
            if (table.getColumnCount() > 0) {
                int totalWidth = table.getClientArea().width;
                int fixedWidth = 0;
                int i = 0;
                while (i < table.getColumnCount() - 1) {
                    fixedWidth += table.getColumn(i).getWidth();
                    ++i;
                }
                int remaining = Math.max(100, totalWidth - fixedWidth);
                table.getColumn(table.getColumnCount() - 1).setWidth(remaining);
            }
        });
    }

    private TableViewerColumn createTypeColumn(TableViewer viewer, int index) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setWidth(ReminderColumnType.TYPE.getDefaultWidth());
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                IReminder reminder;
                if (element instanceof IReminder && (reminder = (IReminder)element).getType() != null) {
                    return switch (reminder.getType()) {
                        case Type.PRINT, Type.PRINT_DRUG_STICKER -> Images.IMG_PRINTER.getImage();
                        case Type.MAKE_APPOINTMENT -> Images.IMG_CALENDAR.getImage();
                        case Type.DISPENSE_MEDICATION -> Images.IMG_PILL.getImage();
                        case Type.PROCESS_SERVICE_RECORDING -> Images.IMG_MONEY.getImage();
                        case Type.READ_DOCUMENT, Type.CHECK_LAB_RESULT -> Images.IMG_EYE_WO_SHADOW.getImage();
                        case Type.SEND_DOCUMENT -> Images.IMG_MAIL_SEND.getImage();
                        default -> null;
                    };
                }
                return null;
            }

            public String getText(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                IReminder reminder;
                if (element instanceof IReminder && (reminder = (IReminder)element).getType() != null) {
                    return reminder.getType().getLocaleText();
                }
                return null;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)this.createSortSelectionAdapter(viewer, col.getColumn(), index));
        return col;
    }

    private TableViewerColumn createDateColumn(TableViewer viewer, int index) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(ReminderColumnType.DATE.getTitle());
        col.getColumn().setWidth(ReminderColumnType.DATE.getDefaultWidth());
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String getText(Object element) {
                IReminder r = (IReminder)element;
                return r.getDue() != null ? this.fmt.format(r.getDue()) : "";
            }

            /*
             * WARNING - void declaration
             */
            public Color getBackground(Object element) {
                void r;
                if (!(element instanceof IReminder)) {
                    return null;
                }
                IReminder iReminder = (IReminder)element;
                LocalDate now = LocalDate.now();
                LocalDate due = r.getDue();
                if (r.getStatus() != null && r.getStatus().toString().equalsIgnoreCase("IN_PROGRESS")) {
                    return ReminderColumnType.ReminderColorType.IN_PROGRESS.getColor();
                }
                if (due != null) {
                    if (due.isBefore(now)) {
                        return ReminderColumnType.ReminderColorType.OVERDUE.getColor();
                    }
                    if (due.isEqual(now)) {
                        return ReminderColumnType.ReminderColorType.DUE.getColor();
                    }
                    return ReminderColumnType.ReminderColorType.OPEN.getColor();
                }
                return null;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)this.createSortSelectionAdapter(viewer, col.getColumn(), index));
        return col;
    }

    private TableViewerColumn createStatusColumn(TableViewer viewer, int index) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(ReminderColumnType.STATUS.getTitle());
        col.getColumn().setWidth(ReminderColumnType.STATUS.getDefaultWidth());
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder r;
                if (element instanceof IReminder && (r = (IReminder)element).getStatus() != null) {
                    return r.getStatus().getLocaleText();
                }
                return "";
            }

            /*
             * WARNING - void declaration
             */
            public Color getForeground(Object element) {
                void r;
                if (!(element instanceof IReminder)) {
                    return null;
                }
                IReminder iReminder = (IReminder)element;
                LocalDate now = LocalDate.now();
                LocalDate due = r.getDue();
                if (r.getStatus() != null && r.getStatus().toString().equalsIgnoreCase("IN_PROGRESS")) {
                    return ReminderColumnType.ReminderColorType.IN_PROGRESS.getColor();
                }
                if (due != null) {
                    if (due.isBefore(now)) {
                        return ReminderColumnType.ReminderColorType.OVERDUE.getColor();
                    }
                    if (due.isEqual(now)) {
                        return ReminderColumnType.ReminderColorType.DUE.getColor();
                    }
                    return ReminderColumnType.ReminderColorType.OPEN.getColor();
                }
                if (r.getStatus() != null) {
                    switch (r.getStatus()) {
                        case CLOSED: {
                            return Display.getDefault().getSystemColor(16);
                        }
                        case OPEN: {
                            return ReminderColumnType.ReminderColorType.OPEN.getColor();
                        }
                        case ON_HOLD: {
                            return Display.getDefault().getSystemColor(8);
                        }
                    }
                    return null;
                }
                return null;
            }

            public Color getBackground(Object element) {
                IReminder r;
                if (element instanceof IReminder && ReminderColumnFactory.this.isClosed(r = (IReminder)element)) {
                    return ReminderColumnType.ReminderColorType.CLOSED.getColor();
                }
                return null;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)this.createSortSelectionAdapter(viewer, col.getColumn(), index));
        return col;
    }

    private TableViewerColumn createPatientColumn(TableViewer viewer, int index) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(ReminderColumnType.PATIENT.getTitle());
        col.getColumn().setWidth(ReminderColumnType.PATIENT.getDefaultWidth());
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder r;
                if (element instanceof IReminder && (r = (IReminder)element).getContact() != null) {
                    IContact c = r.getContact();
                    return c.getDescription1() + " " + c.getDescription2();
                }
                return "";
            }

            public Color getBackground(Object element) {
                IReminder r;
                if (element instanceof IReminder && ReminderColumnFactory.this.isClosed(r = (IReminder)element)) {
                    return ReminderColumnType.ReminderColorType.CLOSED.getColor();
                }
                return null;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)this.createSortSelectionAdapter(viewer, col.getColumn(), index));
        return col;
    }

    private TableViewerColumn createDescriptionColumn(TableViewer viewer, int index) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(ReminderColumnType.DESCRIPTION.getTitle());
        col.getColumn().setWidth(ReminderColumnType.DESCRIPTION.getDefaultWidth());
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder r = (IReminder)element;
                return r.getSubject() == null || r.getSubject().isEmpty() ? r.getMessage() : r.getSubject();
            }

            public Font getFont(Object element) {
                IReminder r;
                if (element instanceof IReminder && (r = (IReminder)element).getPriority() == Priority.HIGH) {
                    return ReminderColumnFactory.this.boldFont;
                }
                return null;
            }

            public Color getBackground(Object element) {
                IReminder r;
                if (element instanceof IReminder && ReminderColumnFactory.this.isClosed(r = (IReminder)element)) {
                    return ReminderColumnType.ReminderColorType.CLOSED.getColor();
                }
                return null;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)this.createSortSelectionAdapter(viewer, col.getColumn(), index));
        return col;
    }

    private TableViewerColumn createResponsibleColumn(TableViewer viewer, int index) {
        TableViewerColumn col = new TableViewerColumn(viewer, 0);
        col.getColumn().setText(ReminderColumnType.RESPONSIBLE.getTitle());
        col.getColumn().setWidth(ReminderColumnType.RESPONSIBLE.getDefaultWidth());
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IReminder) {
                    IReminder r = (IReminder)element;
                    if (r.isResponsibleAll()) {
                        return Messages.Core_All;
                    }
                    return r.getResponsible().stream().map(c -> c.isMandator() ? c.getDescription1() + " " + c.getDescription2() : c.getLabel()).reduce((a, b) -> a + " | " + b).orElse("");
                }
                return "";
            }

            public Color getBackground(Object element) {
                IReminder r;
                if (element instanceof IReminder && ReminderColumnFactory.this.isClosed(r = (IReminder)element)) {
                    return ReminderColumnType.ReminderColorType.CLOSED.getColor();
                }
                return null;
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)this.createSortSelectionAdapter(viewer, col.getColumn(), index));
        return col;
    }

    private boolean isClosed(IReminder r) {
        return r.getStatus() == ProcessStatus.CLOSED;
    }

    private SelectionAdapter createSortSelectionAdapter(final TableViewer viewer, final TableColumn column, final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerComparator comp = viewer.getComparator();
                if (comp instanceof ReminderComparator) {
                    ReminderComparator rc = (ReminderComparator)comp;
                    rc.setColumn(index);
                    int dir = rc.getDirection();
                    viewer.getTable().setSortColumn(column);
                    viewer.getTable().setSortDirection(dir);
                    viewer.refresh(true);
                }
            }
        };
    }

    public static class ReminderComparator
    extends ViewerComparator
    implements Comparator<IReminder> {
        private int column = -1;
        private int direction = 1024;

        @Override
        public int compare(IReminder r1, IReminder r2) {
            int result = 0;
            try {
                switch (this.column) {
                    case 0: {
                        String t1 = r1.getType() != null ? r1.getType().getLocaleText() : "";
                        String t2 = r2.getType() != null ? r2.getType().getLocaleText() : "";
                        result = this.compareByString(t1, t2);
                        break;
                    }
                    case 1: {
                        result = this.compareByDate(r1, r2);
                        break;
                    }
                    case 2: {
                        String resp1 = this.getResponsibleString(r1);
                        String resp2 = this.getResponsibleString(r2);
                        result = this.compareByString(resp1, resp2);
                        break;
                    }
                    case 3: {
                        String s1 = r1.getStatus() != null ? r1.getStatus().getLocaleText() : "";
                        String s2 = r2.getStatus() != null ? r2.getStatus().getLocaleText() : "";
                        result = this.compareByString(s1, s2);
                        break;
                    }
                    case 4: {
                        String p1 = this.getPatientName(r1);
                        String p2 = this.getPatientName(r2);
                        result = this.compareByString(p1, p2);
                        break;
                    }
                    case 5: {
                        String subj1 = StringUtils.isNotEmpty((CharSequence)r1.getSubject()) ? r1.getSubject() : r1.getMessage();
                        String subj2 = StringUtils.isNotEmpty((CharSequence)r2.getSubject()) ? r2.getSubject() : r2.getMessage();
                        result = this.compareByString(subj1, subj2);
                        break;
                    }
                    default: {
                        result = this.compareByDate(r1, r2);
                        break;
                    }
                }
            }
            catch (Exception e) {
                result = 0;
            }
            return this.direction == 128 ? -result : result;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare((IReminder)e1, (IReminder)e2);
        }

        private int compareByDate(IReminder r1, IReminder r2) {
            if (r1.getDue() != null && r2.getDue() != null) {
                return r1.getDue().compareTo(r2.getDue());
            }
            if (r1.getDue() == null && r2.getDue() == null) {
                return 0;
            }
            return r1.getDue() == null ? 1 : -1;
        }

        private int compareByString(String s1, String s2) {
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareToIgnoreCase(s2);
        }

        private String getPatientName(IReminder r) {
            if (r.getContact() == null) {
                return "";
            }
            IContact c = r.getContact();
            return (StringUtils.defaultString((String)c.getDescription1()) + " " + StringUtils.defaultString((String)c.getDescription2())).trim();
        }

        private String getResponsibleString(IReminder r) {
            if (r.isResponsibleAll()) {
                return "Alle";
            }
            return r.getResponsible().stream().map(c -> c.isMandator() ? c.getDescription1() + " " + c.getDescription2() : c.getLabel()).reduce((a, b) -> a + " | " + b).orElse("");
        }

        public void setColumn(int index) {
            if (this.column == index) {
                this.direction = this.direction == 1024 ? 128 : 1024;
            } else {
                this.column = index;
                this.direction = 1024;
            }
        }

        public int getDirection() {
            return this.direction;
        }
    }
}

