/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.util.Messages;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public final class MandatorUIUtil {
    private MandatorUIUtil() {
    }

    public static String buildMandatorLabel(IMandator mandator) {
        if (mandator == null) {
            return "";
        }
        String name = mandator.getDescription1();
        String vorname = mandator.getDescription2();
        String kuerzel = mandator.getDescription3();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sb.append(name);
        }
        if (StringUtils.isNotBlank((CharSequence)vorname)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(vorname);
        }
        if (StringUtils.isNotBlank((CharSequence)kuerzel)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append('(').append(kuerzel).append(')');
        }
        return sb.toString();
    }

    public static String getMandatorLabel(Object element) {
        if (element instanceof IMandator) {
            IMandator mandator = (IMandator)element;
            return MandatorUIUtil.buildMandatorLabel(mandator);
        }
        return element != null ? element.toString() : "";
    }

    public static Comparator<Object> createMandatorComparator(Set<String> lockedMandatorIds) {
        return (o1, o2) -> {
            boolean locked2;
            boolean locked1 = MandatorUIUtil.isLockedMandator(o1, lockedMandatorIds);
            if (locked1 != (locked2 = MandatorUIUtil.isLockedMandator(o2, lockedMandatorIds))) {
                return locked1 ? 1 : -1;
            }
            String l1 = MandatorUIUtil.getMandatorLabel(o1);
            String l2 = MandatorUIUtil.getMandatorLabel(o2);
            return StringUtils.compareIgnoreCase((String)l1, (String)l2);
        };
    }

    private static boolean isLockedMandator(Object o, Set<String> lockedMandatorIds) {
        if (!(o instanceof IMandator) || lockedMandatorIds == null) {
            return false;
        }
        IMandator m = (IMandator)o;
        return lockedMandatorIds.contains(m.getId());
    }

    public static ColumnLabelProvider createMandatorLabelProvider(final Set<String> lockedMandatorIds) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return MandatorUIUtil.getMandatorLabel(element);
            }

            public Color getForeground(Object element) {
                if (MandatorUIUtil.isLockedMandator(element, lockedMandatorIds)) {
                    return Display.getCurrent().getSystemColor(16);
                }
                return super.getForeground(element);
            }

            public String getToolTipText(Object element) {
                if (MandatorUIUtil.isLockedMandator(element, lockedMandatorIds)) {
                    return Messages.MandatorFilter_lockedMandatorTooltip;
                }
                return null;
            }
        };
    }

    public static MandatorSelectionData loadMandatorsAndLockedIds(IModelService modelService) {
        IQuery mandatorQuery = modelService.getQuery(IMandator.class);
        List mandators = mandatorQuery.execute();
        IQuery userQuery = modelService.getQuery(IUser.class);
        userQuery.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null);
        userQuery.and((EStructuralFeature)ModelPackage.Literals.IUSER__ACTIVE, IQuery.COMPARATOR.EQUALS, (Object)Boolean.FALSE);
        List inactiveUsers = userQuery.execute();
        Set<String> lockedMandatorIds = inactiveUsers.stream().map(IUser::getAssignedContact).filter(contact -> contact != null).map(contact -> contact.getId()).collect(Collectors.toSet());
        return new MandatorSelectionData(mandators, lockedMandatorIds);
    }

    public static final class MandatorSelectionData {
        private final List<IMandator> mandators;
        private final Set<String> lockedMandatorIds;

        public MandatorSelectionData(List<IMandator> mandators, Set<String> lockedMandatorIds) {
            this.mandators = mandators;
            this.lockedMandatorIds = lockedMandatorIds;
        }

        public List<IMandator> getMandators() {
            return this.mandators;
        }

        public Set<String> getLockedMandatorIds() {
            return this.lockedMandatorIds;
        }
    }
}

