/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.inputs.DecoratedStringChooser;
import ch.elexis.core.ui.util.DecoratedString;
import ch.elexis.core.ui.views.reminder.viewers.ReminderColumnType;
import ch.elexis.data.Reminder;
import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ReminderPrefences
extends PreferencePage
implements IWorkbenchPreferencePage {
    DecoratedString[] strings;
    private Button showRemindersOnPatientSelectionEventBtn;
    private ListViewer lViewerChoosen;
    private ListViewer lViewerAvailable;
    private String[] choosenFields;
    private String[] availableFields;
    private Label lblInfo;
    private String prefixPrevLabel = Messages.ReminderPrefences_PrefixPrevLabel;
    private Button defaultPatientRelated;
    private Button defaultResponsibleSelf;
    private ListViewer lViewerVisible;
    private ListViewer lViewerHidden;

    public ReminderPrefences() {
        super(Messages.ReminderPrefences_Reminders);
        this.strings = new DecoratedString[5];
        this.strings[0] = new DecoratedString(ProcessStatus.OPEN.getLocaleText(), ProcessStatus.OPEN.name());
        this.strings[1] = new DecoratedString(ProcessStatus.IN_PROGRESS.getLocaleText(), ProcessStatus.IN_PROGRESS.name());
        this.strings[2] = new DecoratedString(ProcessStatus.DUE.getLocaleText(), ProcessStatus.DUE.name());
        this.strings[3] = new DecoratedString(ProcessStatus.OVERDUE.getLocaleText(), ProcessStatus.OVERDUE.name());
        this.strings[4] = new DecoratedString(ProcessStatus.CLOSED.getLocaleText(), ProcessStatus.CLOSED.name());
        this.choosenFields = ConfigServiceHolder.getUser((String)"reminder/patientlabel/choosen", (String)Reminder.LabelFields.LASTNAME.toString()).split(",");
        if (this.choosenFields.length == 3) {
            this.availableFields = new String[0];
        } else {
            String defValue = Reminder.LabelFields.PAT_ID.toString() + "," + Reminder.LabelFields.FIRSTNAME.toString();
            this.availableFields = ConfigServiceHolder.getUser((String)"reminder/patientlabel/available", (String)defValue).split(",");
        }
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        int nrElementsInTop = 3;
        ret.setLayout((Layout)new GridLayout(nrElementsInTop, true));
        new Label(ret, 0).setText(Messages.ReminderPrefences_SetColors);
        DecoratedStringChooser chooser = new DecoratedStringChooser(ret, "reminder/colors", this.strings);
        chooser.setLayoutData(new GridData(4, 128, true, false, nrElementsInTop, 1));
        this.showRemindersOnPatientSelectionEventBtn = new Button(ret, 32);
        this.showRemindersOnPatientSelectionEventBtn.setText(Messages.ReminderPrefences_ShowPatientSelectionRedminders);
        this.showRemindersOnPatientSelectionEventBtn.setSelection(ConfigServiceHolder.getUser((String)"reminder/showPatientChangeReminder", (boolean)false));
        this.showRemindersOnPatientSelectionEventBtn.setLayoutData((Object)new GridData(4, 128, true, false, nrElementsInTop, 1));
        this.defaultPatientRelated = new Button(ret, 32);
        this.defaultPatientRelated.setText(Messages.ReminderPref_defaultPatientRelated);
        this.defaultPatientRelated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.getUser((String)"reminder/defaultPatientRelated", (boolean)ReminderPrefences.this.defaultPatientRelated.getSelection());
            }
        });
        this.defaultPatientRelated.setSelection(ConfigServiceHolder.getUser((String)"reminder/defaultPatientRelated", (boolean)true));
        this.defaultPatientRelated.setLayoutData((Object)new GridData(4, 128, true, false, nrElementsInTop, 1));
        this.defaultResponsibleSelf = new Button(ret, 32);
        this.defaultResponsibleSelf.setText(Messages.ReminderPref_defaultReponsibleSelf);
        this.defaultResponsibleSelf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.getUser((String)"reminder/defaultResponsibleSelf", (boolean)ReminderPrefences.this.defaultResponsibleSelf.getSelection());
            }
        });
        this.defaultResponsibleSelf.setSelection(ConfigServiceHolder.getUser((String)"reminder/defaultResponsibleSelf", (boolean)false));
        this.defaultResponsibleSelf.setLayoutData((Object)new GridData(4, 128, true, false, nrElementsInTop, 1));
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        Label lblSeparator = new Label(ret, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblLabelConfig = new Label(ret, 0);
        lblLabelConfig.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        lblLabelConfig.setText(Messages.ReminderPrefences_LabelConfig);
        Label lblChoosen = new Label(ret, 0);
        lblChoosen.setText(Messages.ReminderPrefences_Choosen);
        new Label(ret, 0);
        Label lblAvailable = new Label(ret, 0);
        lblAvailable.setText(Messages.ReminderPrefences_Available);
        GridData gdListViewer = new GridData();
        gdListViewer.horizontalAlignment = 4;
        gdListViewer.verticalAlignment = 0x1000000;
        gdListViewer.minimumHeight = 100;
        gdListViewer.heightHint = 100;
        this.lViewerChoosen = new ListViewer(ret, 2560);
        this.lViewerChoosen.getList().setLayoutData((Object)gdListViewer);
        this.lViewerChoosen.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lViewerChoosen.setInput((Object)this.choosenFields);
        Composite btnComposite = new Composite(ret, 0);
        btnComposite.setLayout((Layout)new GridLayout());
        btnComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Button btnAdd = new Button(btnComposite, 8);
        btnAdd.setImage(Images.IMG_PREVIOUS.getImage());
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ReminderPrefences.this.lViewerAvailable.getSelection();
                String item = (String)sel.getFirstElement();
                ReminderPrefences.this.lViewerAvailable.remove((Object)item);
                ReminderPrefences.this.lViewerChoosen.add((Object)item);
                ReminderPrefences.this.lblInfo.setText(ReminderPrefences.this.getPreviewLabel());
            }
        });
        Button btnRemove = new Button(btnComposite, 8);
        btnRemove.setImage(Images.IMG_NEXT.getImage());
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ReminderPrefences.this.lViewerChoosen.getSelection();
                String item = (String)sel.getFirstElement();
                ReminderPrefences.this.lViewerChoosen.remove((Object)item);
                ReminderPrefences.this.lViewerAvailable.add((Object)item);
                ReminderPrefences.this.lblInfo.setText(ReminderPrefences.this.getPreviewLabel());
            }
        });
        this.lViewerAvailable = new ListViewer(ret, 2560);
        this.lViewerAvailable.getList().setLayoutData((Object)gdListViewer);
        this.lViewerAvailable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lViewerAvailable.setInput((Object)this.availableFields);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        this.lblInfo = new Label(ret, 0);
        this.lblInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.lblInfo.setText(this.getPreviewLabel());
        Label lblSeparator2 = new Label(ret, 258);
        lblSeparator2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblColumnConfig = new Label(ret, 0);
        lblColumnConfig.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        lblColumnConfig.setText(Messages.ReminderPrefences_ColumnConfig);
        Label lblVisible = new Label(ret, 0);
        lblVisible.setText(Messages.ReminderPrefences_Visible);
        new Label(ret, 0);
        Label lblHidden = new Label(ret, 0);
        lblHidden.setText(Messages.ReminderPrefences_Hidden);
        GridData gdListViewerColumns = new GridData();
        gdListViewerColumns.horizontalAlignment = 4;
        gdListViewerColumns.verticalAlignment = 0x1000000;
        gdListViewerColumns.minimumHeight = 100;
        gdListViewerColumns.heightHint = 100;
        this.lViewerVisible = new ListViewer(ret, 2560);
        this.lViewerVisible.getList().setLayoutData((Object)gdListViewerColumns);
        this.lViewerVisible.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        String defaultColumns = String.join((CharSequence)",", ReminderColumnType.getAllTitles());
        CharSequence[] visibleColumns = ConfigServiceHolder.getUser((String)"usr/reminder/columns/visible", (String)defaultColumns).split(",");
        String hiddenValue = ConfigServiceHolder.getUser((String)"usr/reminder/columns/hidden", (String)"");
        String[] hiddenColumns = hiddenValue.split(",");
        ArrayList<String> cleanedHidden = new ArrayList<String>();
        String[] stringArray = hiddenColumns;
        int n = hiddenColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && !s.trim().isEmpty()) {
                cleanedHidden.add(s.trim());
            }
            ++n2;
        }
        hiddenColumns = cleanedHidden.toArray(new String[0]);
        this.lViewerVisible.setInput((Object)visibleColumns);
        Composite btnCompositeCols = new Composite(ret, 0);
        btnCompositeCols.setLayout((Layout)new GridLayout());
        btnCompositeCols.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Button btnAddCol = new Button(btnCompositeCols, 8);
        btnAddCol.setImage(Images.IMG_PREVIOUS.getImage());
        btnAddCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ReminderPrefences.this.lViewerHidden.getSelection();
                String item = (String)sel.getFirstElement();
                if (item != null) {
                    ReminderPrefences.this.lViewerHidden.remove((Object)item);
                    ReminderPrefences.this.lViewerVisible.add((Object)item);
                }
            }
        });
        Button btnRemoveCol = new Button(btnCompositeCols, 8);
        btnRemoveCol.setImage(Images.IMG_NEXT.getImage());
        btnRemoveCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ReminderPrefences.this.lViewerVisible.getSelection();
                String item = (String)sel.getFirstElement();
                if (item != null) {
                    ReminderPrefences.this.lViewerVisible.remove((Object)item);
                    ReminderPrefences.this.lViewerHidden.add((Object)item);
                }
            }
        });
        this.lViewerHidden = new ListViewer(ret, 2560);
        this.lViewerHidden.getList().setLayoutData((Object)gdListViewerColumns);
        this.lViewerHidden.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lViewerHidden.setInput((Object)hiddenColumns);
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        Label lblColInfo = new Label(ret, 0);
        lblColInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        lblColInfo.setText(Messages.ReminderPrefences_ColInfo + String.join((CharSequence)", ", visibleColumns));
        return ret;
    }

    private String getPreviewLabel() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.lViewerChoosen.getList().getItems().length) {
            sb.append(this.lViewerChoosen.getList().getItems()[i]);
            if (i < this.lViewerChoosen.getList().getItems().length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return this.prefixPrevLabel + ":\t\t" + sb.toString();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performOk() {
        ConfigServiceHolder.setUser((String)"reminder/showPatientChangeReminder", (boolean)this.showRemindersOnPatientSelectionEventBtn.getSelection());
        ConfigServiceHolder.setUser((String)"reminder/defaultPatientRelated", (boolean)this.defaultPatientRelated.getSelection());
        ConfigServiceHolder.setUser((String)"reminder/defaultResponsibleSelf", (boolean)this.defaultResponsibleSelf.getSelection());
        ConfigServiceHolder.setUser((String)"reminder/patientlabel/choosen", (String)this.getListAsString(this.lViewerChoosen.getList().getItems()));
        ConfigServiceHolder.setUser((String)"reminder/patientlabel/available", (String)this.getListAsString(this.lViewerAvailable.getList().getItems()));
        ConfigServiceHolder.setUser((String)"usr/reminder/columns/visible", (String)this.getListAsString(this.lViewerVisible.getList().getItems()));
        ConfigServiceHolder.setUser((String)"usr/reminder/columns/hidden", (String)this.getListAsString(this.lViewerHidden.getList().getItems()));
        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IReminder.class);
        return super.performOk();
    }

    private String getListAsString(String[] items) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            sb.append(item);
            sb.append(",");
            ++n2;
        }
        return sb.toString();
    }
}

