/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder.internal.handler;

import ch.elexis.core.mediorder.MediorderEntryState;
import ch.elexis.core.mediorder.MediorderUtil;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStockService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class CreatePatientOrderHandler {
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.model)")
    IModelService coreModelService;
    @Inject
    EPartService partService;
    @Inject
    IContextService contextService;
    @Inject
    IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, IConfigService configService, IOrderService orderService, IStockService stockService) {
        boolean excludeAlreadyOrderedItems = configService.get("inventory/order_exclude_already_ordered_items", false);
        IQuery queryStock = this.coreModelService.getQuery(IStock.class);
        queryStock.and("id", IQuery.COMPARATOR.LIKE, (Object)"PatientStock-%");
        List patientStocks = queryStock.execute();
        List stockEntries = patientStocks.parallelStream().flatMap(s -> s.getStockEntries().stream()).toList();
        if (excludeAlreadyOrderedItems) {
            stockEntries = new ArrayList(stockEntries);
            Iterator iterator = stockEntries.iterator();
            while (iterator.hasNext()) {
                IStockEntry stockEntry = (IStockEntry)iterator.next();
                if (orderService.findOpenOrderEntryForStockEntry(stockEntry) == null && !MediorderEntryState.AWAITING_REQUEST.equals((Object)MediorderUtil.determineState((IStockEntry)stockEntry))) continue;
                iterator.remove();
            }
        }
        if (stockEntries.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"Keine anwendbaren Eintr\u00e4ge", (String)"Keine anwendbaren Eintr\u00e4ge gefunden");
            return;
        }
        IOrder order = (IOrder)this.coreModelService.create(IOrder.class);
        order.setTimestamp(LocalDateTime.now());
        order.setName("Medikamentenbestellung");
        this.coreModelService.save((Identifiable)order);
        for (IStockEntry stockEntry : stockEntries) {
            if (stockEntry.getArticle() != null) {
                if (stockEntry.getMaximumStock() == 0) continue;
                orderService.addRefillForStockEntryToOrder(stockEntry, order);
                continue;
            }
            LoggerFactory.getLogger(this.getClass()).warn("Could not resolve article [{}] of stock entry [{}]", (Object)stockEntry.getLabel(), (Object)stockEntry.getId());
        }
        this.eventBroker.post("info/elexis/model/reload", IStock.class);
        MPart orderPart = this.partService.findPart("ch.elexis.OrderManagementView");
        if (orderPart == null) {
            orderPart = this.partService.createPart("ch.elexis.OrderManagementView");
        }
        this.partService.showPart(orderPart, EPartService.PartState.VISIBLE);
        this.contextService.setTyped((Object)order);
    }
}

